/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.models.base.extensions.commonext.globaltran.GlobalTransaction;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.csi.GlobalTranConfigData;
import com.ibm.ws.security.util.AccessController;

public class GlobalTranConfigDataImpl
implements GlobalTranConfigData {
    private static final TraceComponent tc = Tr.register(GlobalTranConfigDataImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private int timeout = 0;
    private boolean isSendWSAT = false;

    public GlobalTranConfigDataImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Default CTOR was called, using default values for config data");
        }
    }

    public GlobalTranConfigDataImpl(EnterpriseBeanExtension enterpriseBeanExtension) {
        if (enterpriseBeanExtension != null) {
            GlobalTransaction globalTransaction;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CTOR was passed non-null EnterpriseBeanExtension object for config data");
            }
            if ((globalTransaction = enterpriseBeanExtension.getGlobalTransaction()) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "We have a globlTransaction object, so use the 5.0 or later config data");
                }
                this.init(globalTransaction);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CTOR was passed a null EnterpriseBeanExtension object for config data");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "CTOR was passed a null EnterpriseBeanExtension object, using default values for config data");
        }
    }

    public GlobalTranConfigDataImpl(GlobalTransaction globalTransaction) {
        this.init(globalTransaction);
    }

    private void init(GlobalTransaction globalTransaction) {
        if (globalTransaction != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "init was passed non-null GlobalTransaction object for config data");
            }
            this.timeout = globalTransaction.getComponentTransactionTimeout();
            this.isSendWSAT = globalTransaction.isSendWSAT();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "init was passed a null GlobalTransaction object, using default values for config data");
        }
    }

    public int getTransactionTimeout() {
        return this.timeout;
    }

    public boolean isSendWSAT() {
        return this.isSendWSAT;
    }

    public String toString() {
        String string = (String)AccessController.doPrivileged(new SystemGetPropertyPrivileged("line.separator", "\n"));
        String string2 = "                                 ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + string2 + "      ****** GLOBAL-TRANSACTION *******");
        stringBuffer.append(string + string2 + "Timeout=" + this.timeout);
        stringBuffer.append(string + string2 + "isSendWSAT=" + this.isSendWSAT);
        return stringBuffer.toString();
    }
}

