/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;

public final class DeploymentUtil {
    public static String methodKey(Method method) {
        StringBuffer stringBuffer = new StringBuffer(method.getName());
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static Method[] getAllMethods(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>(methodArray.length);
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (Modifier.isStatic(method.getModifiers())) continue;
            String string = DeploymentUtil.methodKey(method);
            String string2 = method.getDeclaringClass().getName();
            if ((string2.equals("javax.ejb.EJBObject") || string2.equals("javax.ejb.EJBLocalObject")) && !method.getName().equals("remove")) continue;
            Method method2 = (Method)hashMap.get(string);
            if (method2 == null) {
                hashMap.put(string, method);
                arrayList.add(method);
                continue;
            }
            Class<?> clazz2 = method.getDeclaringClass();
            Class<?> clazz3 = method2.getDeclaringClass();
            if (!clazz3.isAssignableFrom(clazz2)) continue;
            hashMap.put(string, method);
            arrayList.set(arrayList.indexOf(method2), method);
        }
        return DeploymentUtil.sortMethods(arrayList);
    }

    public static Method[] getMethods(Class clazz) {
        return DeploymentUtil.getMethods(clazz, null);
    }

    public static Method[] getMethods(Class clazz, Class[] classArray) {
        Class<?> clazz2;
        Class<?> clazz3;
        Method method;
        String string;
        Object object;
        int n;
        int n2 = 0;
        Method[] methodArray = null;
        int n3 = 0;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (clazz != null) {
            methodArray = clazz.getMethods();
            n2 = methodArray.length;
        }
        if (classArray != null) {
            n3 = classArray.length;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2 + n3 * 10);
        for (n = 0; n < n2; ++n) {
            Method method2 = methodArray[n];
            if (Modifier.isStatic(method2.getModifiers())) continue;
            object = DeploymentUtil.methodKey(method2);
            string = method2.getDeclaringClass().getName();
            if (string.equals("javax.ejb.EJBObject") || string.equals("javax.ejb.EJBLocalObject")) continue;
            method = (Method)hashMap.get(object);
            if (method == null) {
                hashMap.put(object, method2);
                arrayList.add(method2);
                continue;
            }
            clazz3 = method2.getDeclaringClass();
            clazz2 = method.getDeclaringClass();
            if (!clazz2.isAssignableFrom(clazz3)) continue;
            hashMap.put(object, method2);
            arrayList.set(arrayList.indexOf(method), method2);
        }
        for (n = 0; n < n3; ++n) {
            methodArray = classArray[n].getMethods();
            n2 = methodArray.length;
            arrayList.ensureCapacity(arrayList.size() + n2);
            for (int i = 0; i < n2; ++i) {
                object = methodArray[i];
                if (Modifier.isStatic(((Method)object).getModifiers())) continue;
                string = DeploymentUtil.methodKey((Method)object);
                method = (Method)hashMap.get(string);
                if (method == null) {
                    hashMap.put(string, object);
                    arrayList.add(object);
                    continue;
                }
                clazz3 = ((Method)object).getDeclaringClass();
                clazz2 = method.getDeclaringClass();
                if (!clazz2.isAssignableFrom(clazz3)) continue;
                hashMap.put(string, object);
                arrayList.set(arrayList.indexOf(method), object);
            }
        }
        return DeploymentUtil.sortMethods(arrayList);
    }

    private static Method[] sortMethods(ArrayList arrayList) {
        int n = arrayList.size();
        Method[] methodArray = new Method[n];
        for (int i = 0; i < n; ++i) {
            Method method = (Method)arrayList.get(i);
            String string = method.toString();
            for (int j = 0; j < i && string.compareTo(methodArray[j].toString()) > 0; ++j) {
            }
            for (int j = j; j <= i; ++j) {
                Method method2 = methodArray[j];
                methodArray[j] = method;
                method = method2;
            }
        }
        return methodArray;
    }
}

