/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.SystemException;

public class ConfigURLProperties
extends Properties {
    private static final long serialVersionUID = 4327870282077085354L;
    private static TraceComponent tc = Tr.register("SASRas", null, "com.ibm.ISecurityL13SupportImpl.sec");
    protected Hashtable specifiers;
    public ORB _orb = null;
    private static ConfigURLProperties configURLProps = null;
    private static boolean securityEnabled = false;
    private static boolean serverSecurityEnabled = true;
    private static boolean processIsServer = false;

    public static ConfigURLProperties getInstance() {
        if (configURLProps == null) {
            configURLProps = new ConfigURLProperties();
        }
        return configURLProps;
    }

    public void init(String string, ORB oRB) {
        String string2;
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigURLProperties.init", new Object[]{string});
        }
        this._orb = oRB;
        configURLProps = this;
        this.specifiers = new Hashtable();
        if (string != null) {
            this.loadPropertiesFile(string);
        }
        if ((string3 = this.getProperty("com.ibm.CORBA.securityEnabled")) != null && (string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("yes"))) {
            securityEnabled = true;
        }
        String string4 = this.getProperty("com.ibm.CORBA.serverSecurityEnabled");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "*** serverSecEnabled = " + string4);
        }
        boolean bl = false;
        if (string4 == null || string4.equals("null")) {
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "foundNullServerSecEnabled = " + bl);
                Tr.debug(tc, "A serverSecEnabled is null, securityEnabled = " + securityEnabled);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "B serverSecEnabled is " + string4 + " securityEnabled = " + securityEnabled);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "foundNullServerSecEnabled = " + bl);
        }
        if (bl) {
            serverSecurityEnabled = securityEnabled;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverSecurityEnabled set to securityEnabled");
            }
        } else if (string4.equalsIgnoreCase("true") || string4.equalsIgnoreCase("yes")) {
            serverSecurityEnabled = true;
        } else {
            serverSecurityEnabled = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverSecurityEnabled set to false");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "serverSecurityEnabled = " + serverSecurityEnabled);
        }
        if ((string2 = this.getProperty("com.ibm.CORBA.processIsServer")) != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"))) {
            processIsServer = true;
        }
        String string5 = this.getProperty("com.ibm.ws.security.CommTrace.ExcludeServiceContexts");
        String string6 = this._orb.getProperty("com.ibm.ws.security.CommTrace.ExcludeServiceContexts");
        if (string5 != null && !string5.equals(string6)) {
            this.setProperty("com.ibm.ws.security.CommTrace.ExcludeServiceContexts", string5);
        } else if (string5 == null && string6 == null && !"".equals("")) {
            this.setProperty("com.ibm.ws.security.CommTrace.ExcludeServiceContexts", "");
        }
        this.dumpProperties();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigURLProperties.init");
        }
    }

    protected void loadPropertiesFile(String string) throws SystemException {
        String string2;
        block17: {
            string2 = "ConfigURLProperties.loadPropertiesFile";
            String string3 = "";
            final String string4 = string;
            String string5 = "";
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, string2, new Object[]{string4});
            }
            if (string4 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string2);
                }
                return;
            }
            try {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            InputStream inputStream = null;
                            try {
                                URL uRL = new URL(string4);
                                inputStream = uRL.openStream();
                                ConfigURLProperties.this.load(inputStream);
                            }
                            catch (Exception exception) {
                                throw exception;
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            return null;
                        }
                    });
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, string2);
                    }
                    return;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", "174", this);
                    Tr.warning(tc, "security.JSAS0631E", (Object)new Object[]{string2, string, privilegedActionException});
                    string5 = this.validateURL(string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", "182", this);
                Tr.warning(tc, "security.JSAS0631E", (Object)new Object[]{string2, string, exception});
                string5 = this.validateURL(string);
            }
            final String string6 = string5;
            Tr.debug(tc, "Retry URL = " + string6);
            try {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            InputStream inputStream = null;
                            try {
                                URL uRL = new URL(string6);
                                inputStream = uRL.openStream();
                                ConfigURLProperties.this.load(inputStream);
                            }
                            catch (Exception exception) {
                                throw exception;
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", "207", this);
                    Tr.error(tc, "security.JSAS0629E", new Object[]{string2, string6, privilegedActionException});
                    throw privilegedActionException.getException();
                }
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", "215", this);
                Tr.error(tc, "security.JSAS1478W");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string2);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", "221", this);
                Tr.error(tc, "security.JSAS1478W");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, string2);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.ConfigURLProperties.loadPropertiesFile", "227", this);
                Tr.error(tc, "security.JSAS1478W");
                if (!tc.isEntryEnabled()) break block17;
                Tr.exit(tc, string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string2);
        }
    }

    String validateURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Existing propertiesURL: " + string);
        }
        int n = 0;
        for (int i = string.indexOf(58, 0) + 1; i < string.length(); ++i) {
            if (string.charAt(i) == '/' || string.charAt(i) == '\\') continue;
            n = i;
            break;
        }
        stringBuffer.append("file:/");
        stringBuffer.append(string.substring(n));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New propertiesURL: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public String getProperty(String string) {
        String string2 = string;
        String string3 = this._orb.getProperty(string);
        if (string3 == null || string3.equals("")) {
            string3 = System.getProperty(string2);
        }
        if (string3 == null || string3.equals("")) {
            string3 = super.getProperty(string);
        }
        return string3;
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static boolean isServerSecurityEnabled() {
        return serverSecurityEnabled;
    }

    public static boolean processIsServer() {
        return processIsServer;
    }

    public void dumpProperties() {
        if (this.size() > 0) {
            Tr.debug(tc, "Printing ConfigURLProperties...");
            Enumeration<?> enumeration = this.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null) continue;
                String string2 = this.getProperty(string);
                if (string.endsWith("Password")) {
                    String string3 = "ConfigURLProperties.dumpProperties";
                    String string4 = "";
                    try {
                        PasswordUtil.decode(string2);
                    }
                    catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                        string2 = SecurityConfiguration.mask((String)string2);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ISecurityUtilityImpl.ConfigURLProperties.dumpProperties", "365", this);
                        string4 = "security.JSAS0486E";
                        SecurityLogger.logError(string4, new Object[]{string3, exception});
                    }
                }
                Tr.debug(tc, string + " = " + string2);
            }
        }
    }
}

