/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.schemagen;

import com.sun.istack.Nullable;
import com.sun.xml.bind.Util;
import com.sun.xml.bind.api.CompositeStructure;
import com.sun.xml.bind.v2.TODO;
import com.sun.xml.bind.v2.model.core.Adapter;
import com.sun.xml.bind.v2.model.core.ArrayInfo;
import com.sun.xml.bind.v2.model.core.AttributePropertyInfo;
import com.sun.xml.bind.v2.model.core.ClassInfo;
import com.sun.xml.bind.v2.model.core.Element;
import com.sun.xml.bind.v2.model.core.ElementInfo;
import com.sun.xml.bind.v2.model.core.ElementPropertyInfo;
import com.sun.xml.bind.v2.model.core.EnumConstant;
import com.sun.xml.bind.v2.model.core.EnumLeafInfo;
import com.sun.xml.bind.v2.model.core.MapPropertyInfo;
import com.sun.xml.bind.v2.model.core.NonElement;
import com.sun.xml.bind.v2.model.core.NonElementRef;
import com.sun.xml.bind.v2.model.core.PropertyInfo;
import com.sun.xml.bind.v2.model.core.ReferencePropertyInfo;
import com.sun.xml.bind.v2.model.core.TypeInfo;
import com.sun.xml.bind.v2.model.core.TypeInfoSet;
import com.sun.xml.bind.v2.model.core.TypeRef;
import com.sun.xml.bind.v2.model.core.ValuePropertyInfo;
import com.sun.xml.bind.v2.model.core.WildcardMode;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.bind.v2.runtime.SwaRefAdapter;
import com.sun.xml.bind.v2.schemagen.FoolProofResolver;
import com.sun.xml.bind.v2.schemagen.Form;
import com.sun.xml.bind.v2.schemagen.MultiMap;
import com.sun.xml.bind.v2.schemagen.XmlSchemaGenerator;
import com.sun.xml.bind.v2.schemagen.xmlschema.Annotated;
import com.sun.xml.bind.v2.schemagen.xmlschema.Any;
import com.sun.xml.bind.v2.schemagen.xmlschema.AttrDecls;
import com.sun.xml.bind.v2.schemagen.xmlschema.ComplexExtension;
import com.sun.xml.bind.v2.schemagen.xmlschema.ComplexType;
import com.sun.xml.bind.v2.schemagen.xmlschema.ComplexTypeHost;
import com.sun.xml.bind.v2.schemagen.xmlschema.ExplicitGroup;
import com.sun.xml.bind.v2.schemagen.xmlschema.Import;
import com.sun.xml.bind.v2.schemagen.xmlschema.List;
import com.sun.xml.bind.v2.schemagen.xmlschema.LocalAttribute;
import com.sun.xml.bind.v2.schemagen.xmlschema.LocalElement;
import com.sun.xml.bind.v2.schemagen.xmlschema.Schema;
import com.sun.xml.bind.v2.schemagen.xmlschema.SimpleExtension;
import com.sun.xml.bind.v2.schemagen.xmlschema.SimpleRestriction;
import com.sun.xml.bind.v2.schemagen.xmlschema.SimpleType;
import com.sun.xml.bind.v2.schemagen.xmlschema.SimpleTypeHost;
import com.sun.xml.bind.v2.schemagen.xmlschema.TopLevelAttribute;
import com.sun.xml.bind.v2.schemagen.xmlschema.TopLevelElement;
import com.sun.xml.bind.v2.schemagen.xmlschema.TypeHost;
import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.TxwException;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.output.ResultFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.MimeType;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlSchemaGenerator<T, C, F, M> {
    private static final Logger logger = Util.getClassLogger();
    private final Map<String, Namespace> namespaces = new TreeMap<String, Namespace>(NAMESPACE_COMPARATOR);
    private Navigator<T, C, F, M> navigator;
    private final TypeInfoSet<T, C, F, M> types;
    private final NonElement<T, C> stringType;
    private final NonElement<T, C> anyType;
    private static final Comparator<String> NAMESPACE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String lhs, String rhs) {
            return -lhs.compareTo(rhs);
        }
    };
    private static final String newline = "\n";

    public XmlSchemaGenerator(Navigator<T, C, F, M> navigator, TypeInfoSet<T, C, F, M> types) {
        this.navigator = navigator;
        this.types = types;
        this.stringType = types.getTypeInfo(navigator.ref(String.class));
        this.anyType = types.getAnyTypeInfo();
        for (ClassInfo<T, Object> classInfo : types.beans().values()) {
            this.add(classInfo);
        }
        for (ElementInfo elementInfo : types.getElementMappings(null).values()) {
            this.add(elementInfo);
        }
        for (EnumLeafInfo enumLeafInfo : types.enums().values()) {
            this.add(enumLeafInfo);
        }
        for (ArrayInfo arrayInfo : types.arrays().values()) {
            this.add(arrayInfo);
        }
    }

    private Namespace getNamespace(String uri) {
        Namespace n = this.namespaces.get(uri);
        if (n == null) {
            n = new Namespace(uri);
            this.namespaces.put(uri, n);
        }
        return n;
    }

    public void add(ClassInfo<T, C> clazz) {
        QName tn;
        assert (clazz != null);
        String nsUri = null;
        if (clazz.getClazz() == this.navigator.asDecl(CompositeStructure.class)) {
            return;
        }
        if (clazz.isElement()) {
            nsUri = clazz.getElementName().getNamespaceURI();
            Namespace ns = this.getNamespace(nsUri);
            ns.classes.add(clazz);
            ns.addDependencyTo(clazz.getTypeName());
            this.add(clazz.getElementName(), false, clazz);
        }
        if ((tn = clazz.getTypeName()) != null) {
            nsUri = tn.getNamespaceURI();
        } else if (nsUri == null) {
            return;
        }
        Namespace n = this.getNamespace(nsUri);
        n.classes.add(clazz);
        for (PropertyInfo<T, C> p : clazz.getProperties()) {
            AttributePropertyInfo ap;
            String aUri;
            n.processForeignNamespaces(p);
            if (p instanceof AttributePropertyInfo && (aUri = (ap = (AttributePropertyInfo)p).getXmlName().getNamespaceURI()).length() > 0) {
                this.getNamespace(aUri).addGlobalAttribute(ap);
                n.addDependencyTo(ap.getXmlName());
            }
            if (!(p instanceof ElementPropertyInfo)) continue;
            ElementPropertyInfo ep = (ElementPropertyInfo)p;
            for (TypeRef tref : ep.getTypes()) {
                String eUri = tref.getTagName().getNamespaceURI();
                if (eUri.length() <= 0 || eUri.equals(n.uri)) continue;
                this.getNamespace(eUri).addGlobalElement(tref);
                n.addDependencyTo(tref.getTagName());
            }
        }
        ClassInfo<T, C> bc = clazz.getBaseClass();
        if (bc != null) {
            this.add(bc);
        }
    }

    public void add(ElementInfo<T, C> elem) {
        assert (elem != null);
        QName name = elem.getElementName();
        Namespace n = this.getNamespace(name.getNamespaceURI());
        MultiMap multiMap = n.elementDecls;
        String string = name.getLocalPart();
        Namespace namespace = n;
        namespace.getClass();
        multiMap.put(string, namespace.new Namespace.ElementWithType(true, elem.getContentType()));
        n.processForeignNamespaces(elem.getProperty());
    }

    public void add(EnumLeafInfo<T, C> envm) {
        QName typeName;
        assert (envm != null);
        String nsUri = null;
        if (envm.isElement()) {
            nsUri = envm.getElementName().getNamespaceURI();
            Namespace ns = this.getNamespace(nsUri);
            ns.enums.add(envm);
            ns.addDependencyTo(envm.getTypeName());
            this.add(envm.getElementName(), false, envm);
        }
        if ((typeName = envm.getTypeName()) != null) {
            nsUri = typeName.getNamespaceURI();
        } else if (nsUri == null) {
            return;
        }
        Namespace n = this.getNamespace(nsUri);
        n.enums.add(envm);
        n.addDependencyTo(envm.getBaseType().getTypeName());
    }

    public void add(ArrayInfo<T, C> a) {
        assert (a != null);
        String namespaceURI = a.getTypeName().getNamespaceURI();
        Namespace n = this.getNamespace(namespaceURI);
        n.arrays.add(a);
        n.addDependencyTo(a.getItemType().getTypeName());
    }

    public void add(QName tagName, boolean isNillable, NonElement<T, C> type) {
        if (type != null && type.getType() == this.navigator.ref(CompositeStructure.class)) {
            return;
        }
        Namespace n = this.getNamespace(tagName.getNamespaceURI());
        MultiMap multiMap = n.elementDecls;
        String string = tagName.getLocalPart();
        Namespace namespace = n;
        namespace.getClass();
        multiMap.put(string, namespace.new Namespace.ElementWithType(isNillable, type));
        if (type != null) {
            n.addDependencyTo(type.getTypeName());
        }
    }

    public void write(SchemaOutputResolver resolver) throws IOException {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        resolver = new FoolProofResolver(resolver);
        HashMap<Namespace, Result> out = new HashMap<Namespace, Result>();
        this.namespaces.remove("http://www.w3.org/2001/XMLSchema");
        for (Namespace n : this.namespaces.values()) {
            Result output = resolver.createOutput(n.uri, "schema" + (out.size() + 1) + ".xsd");
            if (output == null) continue;
            out.put(n, output);
        }
        for (Namespace n : this.namespaces.values()) {
            Result result = (Result)out.get(n);
            if (result == null) continue;
            n.writeTo(result, out);
            if (!(result instanceof StreamResult)) continue;
            OutputStream outputStream = ((StreamResult)result).getOutputStream();
            if (outputStream != null) {
                outputStream.close();
                continue;
            }
            Writer writer = ((StreamResult)result).getWriter();
            if (writer == null) continue;
            writer.close();
        }
    }

    private static String getProcessContentsModeName(WildcardMode wc) {
        switch (wc) {
            case LAX: 
            case SKIP: {
                return wc.name().toLowerCase();
            }
            case STRICT: {
                return null;
            }
        }
        throw new IllegalStateException();
    }

    protected static String relativize(String uri, String baseUri) {
        try {
            assert (uri != null);
            if (baseUri == null) {
                return uri;
            }
            URI theUri = new URI(com.sun.xml.bind.v2.schemagen.Util.escapeURI(uri));
            URI theBaseUri = new URI(com.sun.xml.bind.v2.schemagen.Util.escapeURI(baseUri));
            if (theUri.isOpaque() || theBaseUri.isOpaque()) {
                return uri;
            }
            if (!com.sun.xml.bind.v2.schemagen.Util.equalsIgnoreCase(theUri.getScheme(), theBaseUri.getScheme()) || !com.sun.xml.bind.v2.schemagen.Util.equal(theUri.getAuthority(), theBaseUri.getAuthority())) {
                return uri;
            }
            String uriPath = theUri.getPath();
            String basePath = theBaseUri.getPath();
            if (!basePath.endsWith("/")) {
                basePath = com.sun.xml.bind.v2.schemagen.Util.normalizeUriPath(basePath);
            }
            if (uriPath.equals(basePath)) {
                return ".";
            }
            String relPath = XmlSchemaGenerator.calculateRelativePath(uriPath, basePath);
            if (relPath == null) {
                return uri;
            }
            StringBuffer relUri = new StringBuffer();
            relUri.append(relPath);
            if (theUri.getQuery() != null) {
                relUri.append('?').append(theUri.getQuery());
            }
            if (theUri.getFragment() != null) {
                relUri.append('#').append(theUri.getFragment());
            }
            return relUri.toString();
        }
        catch (URISyntaxException e) {
            throw new InternalError("Error escaping one of these uris:\n\t" + uri + "\n\t" + baseUri);
        }
    }

    private static String calculateRelativePath(String uri, String base) {
        if (base == null) {
            return null;
        }
        if (uri.startsWith(base)) {
            return uri.substring(base.length());
        }
        return "../" + XmlSchemaGenerator.calculateRelativePath(uri, com.sun.xml.bind.v2.schemagen.Util.getParentUriPath(base));
    }

    static /* synthetic */ NonElement access$700(XmlSchemaGenerator x0) {
        return x0.stringType;
    }

    static /* synthetic */ NonElement access$800(XmlSchemaGenerator x0) {
        return x0.anyType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Namespace {
        final String uri;
        private final Set<Namespace> depends = new LinkedHashSet<Namespace>();
        private boolean selfReference;
        private final Set<ClassInfo<T, C>> classes = new LinkedHashSet();
        private final Set<EnumLeafInfo<T, C>> enums = new LinkedHashSet();
        private final Set<ArrayInfo<T, C>> arrays = new LinkedHashSet();
        private final MultiMap<String, NonElement<T, C>> attributeDecls = new MultiMap(XmlSchemaGenerator.access$700(XmlSchemaGenerator.this));
        private final MultiMap<String, com.sun.xml.bind.v2.schemagen.XmlSchemaGenerator$Namespace.ElementDeclaration> elementDecls = new MultiMap(new ElementWithType(true, XmlSchemaGenerator.access$800(XmlSchemaGenerator.this)));
        private Form attributeFormDefault;
        private Form elementFormDefault;

        public Namespace(String uri) {
            this.uri = uri;
            assert (!XmlSchemaGenerator.this.namespaces.containsKey(uri));
            XmlSchemaGenerator.this.namespaces.put(uri, this);
        }

        private void processForeignNamespaces(PropertyInfo<T, C> p) {
            for (TypeInfo t : p.ref()) {
                if (t instanceof Element) {
                    this.addDependencyTo(((Element)t).getElementName());
                }
                if (!(t instanceof NonElement)) continue;
                this.addDependencyTo(((NonElement)t).getTypeName());
            }
        }

        private void addDependencyTo(@Nullable QName qname) {
            if (qname == null) {
                return;
            }
            String nsUri = qname.getNamespaceURI();
            if (nsUri.equals("http://www.w3.org/2001/XMLSchema")) {
                return;
            }
            if (nsUri.equals(this.uri)) {
                this.selfReference = true;
                return;
            }
            this.depends.add(XmlSchemaGenerator.this.getNamespace(nsUri));
        }

        private void writeTo(Result result, Map<Namespace, Result> out) throws IOException {
            try {
                Schema schema = TXW.create(Schema.class, ResultFactory.createSerializer(result));
                Map<String, String> xmlNs = XmlSchemaGenerator.this.types.getXmlNs(this.uri);
                for (Map.Entry<String, String> entry : xmlNs.entrySet()) {
                    schema._namespace(entry.getValue(), entry.getKey());
                }
                this.attributeFormDefault = Form.get(XmlSchemaGenerator.this.types.getAttributeFormDefault(this.uri));
                this.attributeFormDefault.declare("attributeFormDefault", schema);
                this.elementFormDefault = Form.get(XmlSchemaGenerator.this.types.getElementFormDefault(this.uri));
                this.elementFormDefault.declare("elementFormDefault", schema);
                if (!xmlNs.containsValue("http://www.w3.org/2001/XMLSchema") && !xmlNs.containsKey("xs")) {
                    schema._namespace("http://www.w3.org/2001/XMLSchema", "xs");
                }
                schema.version("1.0");
                if (this.uri.length() != 0) {
                    schema.targetNamespace(this.uri);
                }
                for (Namespace namespace : this.depends) {
                    schema._namespace(namespace.uri);
                }
                if (this.selfReference && this.uri.length() != 0) {
                    schema._namespace(this.uri, "tns");
                }
                schema._pcdata(XmlSchemaGenerator.newline);
                for (Namespace namespace : this.depends) {
                    Import imp = schema._import();
                    if (namespace.uri.length() != 0) {
                        imp.namespace(namespace.uri);
                    }
                    imp.schemaLocation(XmlSchemaGenerator.relativize(out.get(namespace).getSystemId(), result.getSystemId()));
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (Map.Entry entry : this.elementDecls.entrySet()) {
                    ((ElementDeclaration)entry.getValue()).writeTo((String)entry.getKey(), schema);
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (ClassInfo classInfo : this.classes) {
                    if (classInfo.getTypeName() == null) continue;
                    if (this.uri.equals(classInfo.getTypeName().getNamespaceURI())) {
                        this.writeClass(classInfo, schema);
                    }
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (EnumLeafInfo enumLeafInfo : this.enums) {
                    if (enumLeafInfo.getTypeName() == null) continue;
                    if (this.uri.equals(enumLeafInfo.getTypeName().getNamespaceURI())) {
                        this.writeEnum(enumLeafInfo, schema);
                    }
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (ArrayInfo arrayInfo : this.arrays) {
                    this.writeArray(arrayInfo, schema);
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (Map.Entry entry : this.attributeDecls.entrySet()) {
                    TopLevelAttribute a = schema.attribute();
                    a.name((String)entry.getKey());
                    this.writeTypeRef((TypeHost)a, (NonElement)entry.getValue(), "type");
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                schema.commit();
            }
            catch (TxwException e) {
                logger.log(Level.INFO, e.getMessage(), e);
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }

        private void writeTypeRef(TypeHost th, NonElementRef<T, C> typeRef, String refAttName) {
            switch (typeRef.getSource().id()) {
                case ID: {
                    th._attribute(refAttName, (Object)new QName("http://www.w3.org/2001/XMLSchema", "ID"));
                    return;
                }
                case IDREF: {
                    th._attribute(refAttName, (Object)new QName("http://www.w3.org/2001/XMLSchema", "IDREF"));
                    return;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            MimeType mimeType = typeRef.getSource().getExpectedMimeType();
            if (mimeType != null) {
                th._attribute(new QName("http://www.w3.org/2005/05/xmlmime", "expectedContentTypes", "xmime"), (Object)mimeType.toString());
            }
            if (this.generateSwaRefAdapter(typeRef)) {
                th._attribute(refAttName, (Object)new QName("http://ws-i.org/profiles/basic/1.1/xsd", "swaRef", "ref"));
                return;
            }
            if (typeRef.getSource().getSchemaType() != null) {
                th._attribute(refAttName, (Object)typeRef.getSource().getSchemaType());
                return;
            }
            this.writeTypeRef(th, typeRef.getTarget(), refAttName);
        }

        private boolean generateSwaRefAdapter(NonElementRef<T, C> typeRef) {
            Adapter adapter = typeRef.getSource().getAdapter();
            if (adapter == null) {
                return false;
            }
            Object o = XmlSchemaGenerator.this.navigator.asDecl(SwaRefAdapter.class);
            if (o == null) {
                return false;
            }
            return o.equals(adapter.adapterType);
        }

        private void writeTypeRef(TypeHost th, NonElement<T, C> type, String refAttName) {
            if (type.getTypeName() == null) {
                if (type instanceof ClassInfo) {
                    this.writeClass((ClassInfo)type, th);
                } else {
                    this.writeEnum((EnumLeafInfo)type, (SimpleTypeHost)th);
                }
            } else {
                th._attribute(refAttName, (Object)type.getTypeName());
            }
        }

        private void writeArray(ArrayInfo<T, C> a, Schema schema) {
            ComplexType ct = schema.complexType().name(a.getTypeName().getLocalPart());
            ct._final("#all");
            LocalElement le = ct.sequence().element().name("item");
            le.type(a.getItemType().getTypeName());
            le.minOccurs(0).maxOccurs("unbounded");
            le.nillable(true);
            ct.commit();
        }

        private void writeEnum(EnumLeafInfo<T, C> e, SimpleTypeHost th) {
            SimpleType st = th.simpleType();
            this.writeName(e, st);
            SimpleRestriction base = st.restriction();
            this.writeTypeRef((TypeHost)base, e.getBaseType(), "base");
            for (EnumConstant c : e.getConstants()) {
                base.enumeration().value(c.getLexicalValue());
            }
            st.commit();
        }

        private void writeClass(ClassInfo<T, C> c, TypeHost parent) {
            if (this.containsValueProp(c)) {
                if (c.getProperties().size() == 1) {
                    ValuePropertyInfo vp = (ValuePropertyInfo)c.getProperties().get(0);
                    SimpleType st = ((SimpleTypeHost)parent).simpleType();
                    this.writeName(c, st);
                    if (vp.isCollection()) {
                        this.writeTypeRef((TypeHost)st.list(), vp.getTarget(), "itemType");
                    } else {
                        this.writeTypeRef((TypeHost)st.restriction(), vp.getTarget(), "base");
                    }
                    return;
                }
                ComplexType ct = ((ComplexTypeHost)parent).complexType();
                this.writeName(c, ct);
                if (c.isFinal()) {
                    ct._final("extension restriction");
                }
                SimpleExtension se = ct.simpleContent().extension();
                se.block();
                block4: for (PropertyInfo p : c.getProperties()) {
                    switch (p.kind()) {
                        case ATTRIBUTE: {
                            this.handleAttributeProp((AttributePropertyInfo)p, se);
                            continue block4;
                        }
                        case VALUE: {
                            TODO.checkSpec("what if vp.isCollection() == true?");
                            ValuePropertyInfo vp = (ValuePropertyInfo)p;
                            se.base(vp.getTarget().getTypeName());
                            continue block4;
                        }
                    }
                    assert (false);
                    throw new IllegalStateException();
                }
                se.commit();
                TODO.schemaGenerator("figure out what to do if bc != null");
                TODO.checkSpec("handle sec 8.9.5.2, bullet #4");
                return;
            }
            ComplexType ct = ((ComplexTypeHost)parent).complexType();
            this.writeName(c, ct);
            if (c.isFinal()) {
                ct._final("extension restriction");
            }
            if (c.isAbstract()) {
                ct._abstract(true);
            }
            ct.block();
            TypedXmlWriter compositor = null;
            AttrDecls contentModel = ct;
            ClassInfo bc = c.getBaseClass();
            if (bc != null) {
                if (bc.hasValueProperty()) {
                    SimpleExtension se = ct.simpleContent().extension();
                    contentModel = se;
                    se.base(bc.getTypeName());
                } else {
                    ComplexExtension ce = ct.complexContent().extension();
                    contentModel = ce;
                    ce.base(bc.getTypeName());
                    compositor = c.isOrdered() ? ce.sequence() : ce.all();
                }
            }
            if (c.hasProperties()) {
                if (compositor == null) {
                    compositor = c.isOrdered() ? ct.sequence() : ct.all();
                }
                compositor.block();
                for (PropertyInfo p : c.getProperties()) {
                    if (p instanceof ReferencePropertyInfo && ((ReferencePropertyInfo)p).isMixed()) {
                        ct.mixed(true);
                    }
                    this.writeProperty(p, contentModel, (ExplicitGroup)compositor);
                }
                compositor.commit();
            }
            if (c.hasAttributeWildcard()) {
                contentModel.anyAttribute().namespace("##other").processContents("skip");
            }
            ct.commit();
        }

        private void writeName(NonElement<T, C> c, TypedXmlWriter xw) {
            QName tn = c.getTypeName();
            if (tn != null) {
                xw._attribute("name", (Object)tn.getLocalPart());
            }
        }

        private boolean containsValueProp(ClassInfo<T, C> c) {
            for (PropertyInfo p : c.getProperties()) {
                if (!(p instanceof ValuePropertyInfo)) continue;
                return true;
            }
            return false;
        }

        private void writeProperty(PropertyInfo<T, C> p, AttrDecls attr, ExplicitGroup compositor) {
            switch (p.kind()) {
                case ELEMENT: {
                    this.handleElementProp((ElementPropertyInfo)p, compositor);
                    break;
                }
                case ATTRIBUTE: {
                    this.handleAttributeProp((AttributePropertyInfo)p, attr);
                    break;
                }
                case REFERENCE: {
                    this.handleReferenceProp((ReferencePropertyInfo)p, compositor);
                    break;
                }
                case MAP: {
                    this.handleMapProp((MapPropertyInfo)p, compositor);
                    break;
                }
                case VALUE: {
                    assert (false);
                    throw new IllegalStateException();
                }
                default: {
                    assert (false);
                    throw new IllegalStateException();
                }
            }
        }

        private void handleElementProp(ElementPropertyInfo<T, C> ep, ExplicitGroup compositor) {
            QName ename = ep.getXmlName();
            Annotated occurs = null;
            if (ep.isValueList()) {
                TypeRef t = ep.getTypes().get(0);
                LocalElement e = compositor.element();
                QName tn = t.getTagName();
                e.name(tn.getLocalPart());
                List lst = e.simpleType().list();
                this.writeTypeRef((TypeHost)lst, t, "itemType");
                this.elementFormDefault.writeForm(e, tn);
                return;
            }
            if (ep.isCollection()) {
                if (ename != null) {
                    LocalElement e = compositor.element();
                    if (ename.getNamespaceURI().length() > 0 && !ename.getNamespaceURI().equals(this.uri)) {
                        e.ref(new QName(ename.getNamespaceURI(), ename.getLocalPart()));
                        return;
                    }
                    this.elementFormDefault.writeForm(e, ename);
                    ComplexType p = e.name(ename.getLocalPart()).complexType();
                    if (ep.isCollectionNillable()) {
                        e.nillable(true);
                    } else {
                        e.minOccurs(0);
                    }
                    if (ep.getTypes().size() == 1) {
                        compositor = p.sequence();
                    } else {
                        occurs = compositor = p.choice();
                    }
                } else if (ep.getTypes().size() > 1) {
                    occurs = compositor = compositor.choice();
                }
            } else if (ep.getTypes().size() > 1) {
                occurs = compositor = compositor.choice();
            }
            for (TypeRef t : ep.getTypes()) {
                QName tn;
                LocalElement e = compositor.element();
                if (occurs == null) {
                    occurs = e;
                }
                if (this.canBeDirectElementRef(t, tn = t.getTagName()) || !tn.getNamespaceURI().equals(this.uri) && tn.getNamespaceURI().length() > 0) {
                    e.ref(tn);
                } else {
                    e.name(tn.getLocalPart());
                    this.writeTypeRef((TypeHost)e, t, "type");
                    this.elementFormDefault.writeForm(e, tn);
                }
                if (t.isNillable()) {
                    e.nillable(true);
                }
                if (t.getDefaultValue() == null) continue;
                e._default(t.getDefaultValue());
            }
            if (ep.isCollection()) {
                occurs.maxOccurs("unbounded");
            }
            if (!ep.isRequired()) {
                occurs.minOccurs(0);
            }
        }

        private boolean canBeDirectElementRef(TypeRef<T, C> t, QName tn) {
            if (t.isNillable() || t.getDefaultValue() != null) {
                return false;
            }
            if (t.getTarget() instanceof Element) {
                Element te = (Element)((Object)t.getTarget());
                QName targetTagName = te.getElementName();
                return targetTagName != null && targetTagName.equals(tn);
            }
            return false;
        }

        private void handleAttributeProp(AttributePropertyInfo<T, C> ap, AttrDecls attr) {
            LocalAttribute localAttribute = attr.attribute();
            String attrURI = ap.getXmlName().getNamespaceURI();
            if (attrURI.equals("") || attrURI.equals(this.uri)) {
                String refAtt;
                SimpleTypeHost th;
                localAttribute.name(ap.getXmlName().getLocalPart());
                if (ap.isCollection()) {
                    th = localAttribute.simpleType().list();
                    refAtt = "itemType";
                } else {
                    th = localAttribute;
                    refAtt = "type";
                }
                this.writeTypeRef((TypeHost)th, ap, refAtt);
                this.attributeFormDefault.writeForm(localAttribute, ap.getXmlName());
            } else {
                localAttribute.ref(ap.getXmlName());
            }
            if (ap.isRequired()) {
                localAttribute.use("required");
            }
        }

        private void handleReferenceProp(ReferencePropertyInfo<T, C> rp, ExplicitGroup compositor) {
            QName ename = rp.getXmlName();
            Annotated occurs = null;
            if (rp.isCollection()) {
                if (ename != null) {
                    LocalElement e = compositor.element();
                    ComplexType p = e.name(ename.getLocalPart()).complexType();
                    this.elementFormDefault.writeForm(e, ename);
                    if (rp.isCollectionNillable()) {
                        e.nillable(true);
                    }
                    if (rp.getElements().size() == 1) {
                        compositor = p.sequence();
                    } else {
                        occurs = compositor = p.choice();
                    }
                } else if (rp.getElements().size() > 1) {
                    occurs = compositor = compositor.choice();
                }
            }
            TODO.checkSpec("should we loop in the case of a non-collection ep?");
            for (Element e : rp.getElements()) {
                LocalElement eref = compositor.element();
                if (occurs == null) {
                    occurs = eref;
                }
                QName en = e.getElementName();
                if (e.getScope() != null) {
                    boolean qualified = en.getNamespaceURI().equals(this.uri);
                    boolean unqualified = en.getNamespaceURI().equals("");
                    if (qualified || unqualified) {
                        if (unqualified) {
                            if (this.elementFormDefault.isEffectivelyQualified) {
                                eref.form("unqualified");
                            }
                        } else if (!this.elementFormDefault.isEffectivelyQualified) {
                            eref.form("qualified");
                        }
                        eref.name(en.getLocalPart());
                        if (e instanceof ClassInfo) {
                            this.writeTypeRef((TypeHost)eref, (ClassInfo)((Object)e), "type");
                            continue;
                        }
                        this.writeTypeRef((TypeHost)eref, ((ElementInfo)e).getContentType(), "type");
                        continue;
                    }
                }
                eref.ref(en);
            }
            WildcardMode wc = rp.getWildcard();
            if (wc != null) {
                Any any = compositor.any();
                String pcmode = XmlSchemaGenerator.getProcessContentsModeName(wc);
                if (pcmode != null) {
                    any.processContents(pcmode);
                }
                TODO.schemaGenerator("generate @namespace ???");
                if (occurs == null) {
                    occurs = any;
                }
            }
            if (rp.isCollection()) {
                occurs.maxOccurs("unbounded");
            }
        }

        private void handleMapProp(MapPropertyInfo<T, C> mp, ExplicitGroup compositor) {
            QName ename = mp.getXmlName();
            LocalElement e = compositor.element();
            this.elementFormDefault.writeForm(e, ename);
            if (mp.isCollectionNillable()) {
                e.nillable(true);
            }
            ComplexType p = e.name(ename.getLocalPart()).complexType();
            e = p.sequence().element();
            e.name("entry").minOccurs(0).maxOccurs("unbounded");
            ExplicitGroup seq = e.complexType().sequence();
            this.writeKeyOrValue(seq, "key", mp.getKeyType());
            this.writeKeyOrValue(seq, "value", mp.getValueType());
        }

        private void writeKeyOrValue(ExplicitGroup seq, String tagName, NonElement<T, C> typeRef) {
            LocalElement key = seq.element().name(tagName);
            key.minOccurs(0);
            this.writeTypeRef((TypeHost)key, typeRef, "type");
        }

        public void addGlobalAttribute(AttributePropertyInfo<T, C> ap) {
            this.attributeDecls.put(ap.getXmlName().getLocalPart(), ap.getTarget());
            this.addDependencyTo(ap.getTarget().getTypeName());
        }

        public void addGlobalElement(TypeRef<T, C> tref) {
            this.elementDecls.put(tref.getTagName().getLocalPart(), (com.sun.xml.bind.v2.schemagen.XmlSchemaGenerator$Namespace.ElementDeclaration)new ElementWithType(false, tref.getTarget()));
            this.addDependencyTo(tref.getTarget().getTypeName());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ElementWithType
        extends ElementDeclaration {
            private final boolean nillable;
            private final NonElement<T, C> type;

            public ElementWithType(boolean nillable, NonElement<T, C> type) {
                this.type = type;
                this.nillable = nillable;
            }

            @Override
            public void writeTo(String localName, Schema schema) {
                TopLevelElement e = schema.element().name(localName);
                if (this.nillable) {
                    e.nillable(true);
                }
                if (this.type != null) {
                    Namespace.this.writeTypeRef(e, this.type, "type");
                } else {
                    e.complexType();
                }
                e.commit();
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ElementWithType that = (ElementWithType)o;
                return this.type.equals(that.type);
            }

            @Override
            public int hashCode() {
                return this.type.hashCode();
            }
        }

        abstract class ElementDeclaration {
            ElementDeclaration() {
            }

            public abstract boolean equals(Object var1);

            public abstract int hashCode();

            public abstract void writeTo(String var1, Schema var2);
        }
    }
}

