/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.utils;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.openactions.IWorkbenchRunnable;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IViewActionDelegate,
IEditorActionDelegate,
IWorkbenchRunnable,
INewWizard {
    private IWorkbenchPart part;
    private ISelection selection;
    private IWorkbenchWindow window;
    private IWorkbench workbench;
    private IAction action;
    private UIContext context;
    private Runnable realmRunnable = new Runnable(){

        public void run() {
            UIContext context = AbstractActionDelegate.this.getContext();
            AbstractActionDelegate.this.run(context.getShell(), context.getPage(), AbstractActionDelegate.this.getStructuredSelection());
        }
    };

    protected IStructuredSelection getStructuredSelection() {
        IEditorPart editorPart;
        Object o;
        if (this.selection instanceof IStructuredSelection) {
            return (IStructuredSelection)this.selection;
        }
        if (this.part != null && this.part instanceof IEditorPart && (o = this.adaptEditorInput((editorPart = (IEditorPart)this.part).getEditorInput())) != null) {
            return new StructuredSelection(o);
        }
        return StructuredSelection.EMPTY;
    }

    protected Object adaptEditorInput(IEditorInput input) {
        return null;
    }

    public final void init(IWorkbenchWindow window) {
        this.window = window;
        this.part = null;
    }

    public final void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.context = null;
        this.action = action;
        this.part = targetPart;
        this.window = null;
    }

    public final void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setActivePart(action, (IWorkbenchPart)targetEditor);
    }

    public final void run(IAction action) {
        this.action = action;
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)Display.getCurrent()), (Runnable)this.realmRunnable);
    }

    protected final IOperationRunner getOperationRunner() {
        return this.getContext().getUserOperationRunner();
    }

    protected final UIContext getContext() {
        if (this.context == null) {
            if (this.part != null) {
                this.context = UIContext.createPartContext(this.part, this.getName());
            } else {
                IWorkbenchPage activePage;
                if (this.window == null) {
                    IWorkbenchWindow[] windows;
                    this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (this.window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                        this.window = windows[0];
                    }
                }
                if (this.window != null && (activePage = this.window.getActivePage()) != null) {
                    this.context = UIContext.createPageContext(this.window.getShell(), activePage, this.computeActionName());
                }
            }
        }
        if (this.context != null) {
            return this.context;
        }
        throw new IllegalStateException("This action was not initialized properly");
    }

    private String computeActionName() {
        if (this.action != null && this.action.getText() != null) {
            return SWTUtil.filterMnemonics(this.action.getText());
        }
        return Messages.AbstractActionDelegate_1;
    }

    public abstract void run(Shell var1, IWorkbenchPage var2, IStructuredSelection var3);

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        this.action = action;
    }

    public final void dispose() {
    }

    public void init(IViewPart view) {
        this.part = view;
        this.window = null;
        this.context = null;
    }

    public static void execute(Class actionDelegate, UIContext context, IStructuredSelection selection) {
        try {
            AbstractActionDelegate oad;
            Object newObject = actionDelegate.newInstance();
            if (newObject instanceof AbstractActionDelegate) {
                oad = (AbstractActionDelegate)newObject;
                Action tempAction = new Action(){};
                oad.selectionChanged((IAction)tempAction, (ISelection)selection);
                if (!tempAction.isEnabled()) {
                    MessageDialogFactory.showMessage(context.getShell(), 4, Messages.AbstractActionDelegate_2, Messages.AbstractActionDelegate_3);
                    return;
                }
            } else {
                throw new IllegalArgumentException(NLS.bind((String)"The given class must be an instance of {0}", (Object)AbstractActionDelegate.class.getName()));
            }
            oad.setContext(context);
            oad.run(context.getShell(), context.getPage(), selection);
        }
        catch (IllegalAccessException e) {
            StatusUtil.log(AbstractActionDelegate.class, (Throwable)e);
        }
        catch (InstantiationException e) {
            StatusUtil.log(AbstractActionDelegate.class, (Throwable)e);
        }
    }

    private void setContext(UIContext context) {
        this.context = context;
    }

    protected String getName() {
        return this.computeActionName();
    }

    public final void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public final boolean performFinish() {
        IWorkbenchPage page;
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            this.run(window.getShell(), page, this.getStructuredSelection());
            return true;
        }
        return false;
    }

    public final void addPages() {
    }

    public final boolean canFinish() {
        return true;
    }

    public final void createPageControls(Composite pageContainer) {
    }

    public final IWizardContainer getContainer() {
        return null;
    }

    public final Image getDefaultPageImage() {
        return JFaceResources.getImage((String)"org.eclipse.jface.wizard.Wizard.pageImage");
    }

    public final IDialogSettings getDialogSettings() {
        return null;
    }

    public final IWizardPage getNextPage(IWizardPage page) {
        return null;
    }

    public final IWizardPage getPage(String pageName) {
        return null;
    }

    public final int getPageCount() {
        return 0;
    }

    public final IWizardPage[] getPages() {
        return new IWizardPage[0];
    }

    public final IWizardPage getPreviousPage(IWizardPage page) {
        return null;
    }

    public final IWizardPage getStartingPage() {
        return null;
    }

    public final RGB getTitleBarColor() {
        return new RGB(0, 0, 0);
    }

    public final String getWindowTitle() {
        return "";
    }

    public final boolean isHelpAvailable() {
        return false;
    }

    public final boolean needsPreviousAndNextButtons() {
        return false;
    }

    public final boolean needsProgressMonitor() {
        return false;
    }

    public final boolean performCancel() {
        return false;
    }

    public final void setContainer(IWizardContainer wizardContainer) {
    }
}

