/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.operations;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class LoggedInRunner {
    private IOperationRunner runner;
    private Map<ITeamRepository, LinkedList<QueuedOperation>> queues = new HashMap<ITeamRepository, LinkedList<QueuedOperation>>();
    private boolean disposed = false;
    private IListener changeListener = new IListener(){

        public void handleEvents(List events) {
            for (IEvent event : events) {
                IEventSource source = event.getEventSource();
                if (!(source instanceof ITeamRepository)) continue;
                ITeamRepository repo = (ITeamRepository)source;
                LoggedInRunner.this.scheduleCheckFor(repo);
            }
        }
    };

    public LoggedInRunner(IOperationRunner runner) {
        this.runner = runner;
    }

    public void enqueue(ITeamRepository repository, String operationName, Operation operation) {
        QueuedOperation op = new QueuedOperation(repository, operationName, operation);
        if (repository.loggedIn()) {
            this.runner.enqueue(operationName, op);
        } else {
            this.doEnqueue(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnqueue(QueuedOperation op) {
        ITeamRepository repo = op.repo;
        boolean addedListener = false;
        Map<ITeamRepository, LinkedList<QueuedOperation>> map = this.queues;
        synchronized (map) {
            if (this.disposed) {
                return;
            }
            LinkedList<QueuedOperation> queue = this.queues.get(repo);
            if (queue == null) {
                addedListener = true;
                queue = new LinkedList();
                this.queues.put(repo, queue);
                repo.addGenericListener((Object)"state", this.changeListener);
            }
            queue.add(op);
        }
        if (addedListener) {
            this.scheduleCheckFor(repo);
        }
    }

    private void scheduleCheckFor(final ITeamRepository repo) {
        this.runner.enqueue(Messages.LoggedInRunner_0, new RepositoryOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                if (!repo.loggedIn()) {
                    return;
                }
                QueuedOperation op = null;
                Map map = LoggedInRunner.this.queues;
                synchronized (map) {
                    LinkedList queue = (LinkedList)LoggedInRunner.this.queues.get(repo);
                    if (queue.isEmpty()) {
                        LoggedInRunner.this.queues.remove(repo);
                        queue = null;
                    }
                    if (queue == null) {
                        repo.removeGenericListener((Object)"state", LoggedInRunner.this.changeListener);
                    } else {
                        op = (QueuedOperation)queue.removeFirst();
                    }
                }
                if (op != null) {
                    try {
                        op.run(monitor, problems);
                    }
                    finally {
                        LoggedInRunner.this.scheduleCheckFor(repo);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Map<ITeamRepository, LinkedList<QueuedOperation>> map = this.queues;
        synchronized (map) {
            for (ITeamRepository repo : this.queues.keySet()) {
                repo.removeGenericListener((Object)"state", this.changeListener);
            }
            this.queues.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<ITeamRepository, LinkedList<QueuedOperation>> map = this.queues;
        synchronized (map) {
            this.disposed = true;
            this.cancelAll();
        }
    }

    private final class QueuedOperation
    implements Operation {
        public ITeamRepository repo;
        public Operation op;
        public String operationName;

        public QueuedOperation(ITeamRepository repo, String name, Operation op) {
            this.repo = repo;
            this.op = op;
            this.operationName = name;
        }

        public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
            if (this.repo.loggedIn()) {
                try {
                    this.op.run(monitor, problems);
                }
                catch (OperationFailedException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof NotLoggedInException) {
                        LoggedInRunner.this.doEnqueue(this);
                    }
                    throw e;
                }
            } else {
                LoggedInRunner.this.doEnqueue(this);
            }
        }
    }
}

