/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WritableSetWithListeners<E>
extends AbstractSetWithListeners<E> {
    private HashSet<E> elements = new HashSet();

    public void clear() {
        HashSet<E> removed = new HashSet<E>(this.elements);
        this.elements.clear();
        this.fireCollectionRemoved(removed);
    }

    public boolean add(E toAdd) {
        if (this.elements.add(toAdd)) {
            this.fireAdded(toAdd);
            return true;
        }
        return false;
    }

    public boolean remove(E toRemove) {
        if (this.elements.remove(toRemove)) {
            this.fireRemoved(toRemove);
            return true;
        }
        return false;
    }

    public void setContents(Collection<E> newContents) {
        SetDiff diff = SetDiff.computeDiff(this.elements, newContents);
        this.elements.clear();
        this.elements.addAll(newContents);
        this.fireDiff(diff);
    }

    public void addAll(Collection<E> toAdd) {
        ArrayList<E> added = new ArrayList<E>();
        for (E item : toAdd) {
            if (!this.elements.add(item)) continue;
            added.add(item);
        }
        this.fireCollectionAdded(added);
    }

    public void removeAll(Collection<E> toRemove) {
        ArrayList<E> removed = new ArrayList<E>();
        for (E item : toRemove) {
            if (!this.elements.remove(item)) continue;
            removed.add(item);
        }
        this.fireCollectionRemoved(removed);
    }

    @Override
    protected Collection<E> computeElements() {
        return this.elements;
    }
}

