/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.tree.EmptyObservableSet;
import com.ibm.team.repository.rcp.ui.internal.tree.IObservableTree;
import com.ibm.team.repository.rcp.ui.internal.tree.ObservableSetToSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.tree.SetWithListenersToObservableSet;
import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ColumnData;
import com.ibm.team.repository.rcp.ui.internal.viewers.ComparatorSorter;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConcurrentStructuredContentProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ContextMenuHandler;
import com.ibm.team.repository.rcp.ui.internal.viewers.DeferredSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.EarlySelectionProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.EmptySetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.FilteredSelectionProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LeafNodesSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.MixedTypeComparator;
import com.ibm.team.repository.rcp.ui.internal.viewers.MultiComparator;
import com.ibm.team.repository.rcp.ui.internal.viewers.PendingNodeFilter;
import com.ibm.team.repository.rcp.ui.internal.viewers.PendingNodeSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewerColumnSorter;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewerLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewerTooltipSupport;
import com.ibm.team.repository.rcp.ui.internal.viewers.TableViewerColumn;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IContextMenuHandler;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTableViewer<R> {
    private static final int DEFAULT_STYLE = 84738;
    private static final String COLUMN_ACTIONS = "column_actions";
    TableViewer tableViewer;
    private MenuManager popupMenu;
    private EarlySelectionProvider selectionProvider;
    private ConcurrentStructuredContentProvider contentProvider;
    List<ColumnData<R>> columnData = new ArrayList<ColumnData<R>>();
    private Map mapTableViewerColumnOntoColumnData = new HashMap();
    IViewerLabelProvider rowDecorator = null;
    private SimpleTableViewerLabelProvider<R> labelProvider;
    private ISetWithListeners<R> knownElements;
    private ILabelProviderListener columnLabelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            SimpleTableViewer.this.labelProvider.fireChangeEvent(event.getElements());
        }
    };
    private SimpleTableViewerColumnSorter<R> currentSorter = new SimpleTableViewerColumnSorter(null, true);
    private SelectionListener headerSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            boolean forward;
            ColumnData data = SimpleTableViewer.this.getColumnData((TableColumn)e.widget);
            TableViewerColumn column = data.getColumn();
            for (IPartResult next : SimpleTableViewer.this.tableHeaderListeners) {
                next.setResult(column);
            }
            boolean bl = forward = !data.getColumn().isDefaultSortOrderInverted();
            if (data == ((SimpleTableViewer)SimpleTableViewer.this).currentSorter.data) {
                forward = !((SimpleTableViewer)SimpleTableViewer.this).currentSorter.forwardSort;
            }
            SimpleTableViewer.this.doSetSortColumn(data, forward);
        }
    };
    private IRunnableWithSelection runnableWithSelection;
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection ssel;
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection && SimpleTableViewer.this.runnableWithSelection != null && (ssel = (IStructuredSelection)sel).size() == 1) {
                Object firstElement = ssel.getFirstElement();
                if (firstElement == PendingNodeSet.PENDING_NODE) {
                    return;
                }
                SimpleTableViewer.this.runnableWithSelection.run(firstElement, SimpleTableViewer.this.tableViewer.getControl().getShell());
            }
        }
    };
    private MenuManager columnsMenu;
    private IContributionItem currentSubmenu = null;
    private Preferences savedState;
    private int columnCounter;
    private IContextMenuHandler cmh;
    private Comparator<R> customSorter = null;
    private ILabelProviderListener rowDecoratorListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] elements = event.getElements();
            if (elements == null) {
                SimpleTableViewer.this.labelProvider.fireAllElementsChanged();
            } else {
                SimpleTableViewer.this.labelProvider.fireChangeEvent(elements);
            }
        }
    };
    private SimpleTableViewerTooltipSupport<R> tooltipSupport;
    private List<SimpleTableViewerColumnSorter<R>> sortHistory = new ArrayList<SimpleTableViewerColumnSorter<R>>();
    private DeferredSet deferredSet = new DeferredSet(EmptySetWithListeners.getInstance());
    private Listener eraseListener = new Listener(){

        public void handleEvent(Event event) {
            Table t = SimpleTableViewer.this.tableViewer.getTable();
            if (t.isDisposed()) {
                return;
            }
            if (t.getColumnCount() > event.index) {
                TableColumn tc = t.getColumn(event.index);
                if (tc.isDisposed()) {
                    return;
                }
                ColumnData data = SimpleTableViewer.this.getColumnData(tc);
                if (data == null) {
                    return;
                }
                Listener el = data.getColumn().getEraseListener();
                if (el != null) {
                    el.handleEvent(event);
                }
            }
        }
    };
    private Listener paintListener = new Listener(){

        public void handleEvent(Event event) {
            Table t = SimpleTableViewer.this.tableViewer.getTable();
            if (t.isDisposed()) {
                return;
            }
            if (t.getColumnCount() > event.index) {
                TableColumn tc = t.getColumn(event.index);
                if (tc.isDisposed()) {
                    return;
                }
                ColumnData data = SimpleTableViewer.this.getColumnData(tc);
                if (data == null) {
                    return;
                }
                Listener el = data.getColumn().getPaintListener();
                if (el != null) {
                    el.handleEvent(event);
                }
            }
        }
    };
    private List<IPartResult<TableViewerColumn<R>>> tableHeaderListeners = new ArrayList<IPartResult<TableViewerColumn<R>>>();
    private ISetWithListeners<R> savedInput = EmptySetWithListeners.getInstance();

    public SimpleTableViewer(Composite parent) {
        this(parent, null, null);
    }

    public SimpleTableViewer(Composite parent, Preferences savedState, IContextMenuHandler cmh) {
        this(parent, 84738, savedState, cmh);
    }

    public SimpleTableViewer(Composite parent, int style, Preferences savedState, IContextMenuHandler cmh) {
        this(new Table(parent, style), savedState, cmh);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    public SimpleTableViewer(Table theTable) {
        this(theTable, null, null);
    }

    public SimpleTableViewer(Table theTable, Preferences savedState, IContextMenuHandler cmh) {
        this.tableViewer = new TableViewer(theTable);
        this.tableViewer.setUseHashlookup(true);
        theTable.addListener(40, this.eraseListener);
        theTable.addListener(42, this.paintListener);
        this.savedState = savedState;
        this.contentProvider = new ConcurrentStructuredContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.popupMenu = new MenuManager();
        this.columnsMenu = new MenuManager(Messages.SimpleTableViewer_1);
        this.columnsMenu.add((IContributionItem)new CompoundContributionItem(){

            protected IContributionItem[] getContributionItems() {
                ArrayList<ActionContributionItem> result = new ArrayList<ActionContributionItem>();
                for (final ColumnData nextColumn : SimpleTableViewer.this.columnData) {
                    Action nextAction = new Action(nextColumn.getColumn().getHeaderText()){

                        public void run() {
                            nextColumn.setVisible(!nextColumn.isVisible());
                            super.run();
                        }
                    };
                    nextAction.setChecked(nextColumn.isVisible());
                    nextAction.setImageDescriptor(nextColumn.getColumn().getHeaderImage());
                    result.add(new ActionContributionItem((IAction)nextAction));
                }
                return result.toArray(new IContributionItem[result.size()]);
            }
        });
        this.columnsMenu.setVisible(false);
        ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)this.popupMenu);
        this.popupMenu.insertAfter("jazz.refactoring.group", (IContributionItem)new Separator(COLUMN_ACTIONS));
        this.popupMenu.add((IContributionItem)this.columnsMenu);
        this.popupMenu.createContextMenu(this.tableViewer.getControl());
        this.labelProvider = new SimpleTableViewerLabelProvider(this);
        this.tableViewer.setLabelProvider(this.labelProvider);
        this.tableViewer.addDoubleClickListener(this.doubleClickListener);
        this.tableViewer.getControl().addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Table t = SimpleTableViewer.this.tableViewer.getTable();
                Point displayCoordinates = new Point(event.x, event.y);
                SWTUtil.ColumnPosition position = SWTUtil.mapColumn(t, displayCoordinates);
                IContributionItem columnMenuManager = null;
                if (position != null) {
                    TableColumn tc = t.getColumn(position.creationIndex);
                    ColumnData data = SimpleTableViewer.this.getColumnData(tc);
                    columnMenuManager = data.getColumn().getContextMenu();
                }
                if (columnMenuManager == null) {
                    SimpleTableViewer.this.showSubmenu(null);
                } else {
                    SimpleTableViewer.this.showSubmenu(columnMenuManager);
                }
                SimpleTableViewer.this.popupMenu.getMenu().setVisible(true);
                SimpleTableViewer.this.popupMenu.updateAll(true);
            }
        });
        this.tableViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SimpleTableViewer.this.disposed();
            }
        });
        this.cmh = cmh != null ? cmh : new ContextMenuHandler(null);
        this.tooltipSupport = new SimpleTableViewerTooltipSupport(this);
        LeafNodesSet newKnownElements = new LeafNodesSet(new IObservableTree(){

            public IObservableSet createChildSet(Object element) {
                if (element == PendingNodeSet.PENDING_NODE) {
                    return EmptyObservableSet.getInstance();
                }
                if (element instanceof ISetWithListeners) {
                    return new SetWithListenersToObservableSet((ISetWithListeners)element);
                }
                return null;
            }
        });
        newKnownElements.setInput(this.contentProvider.getKnownElements());
        this.knownElements = new ObservableSetToSetWithListeners(newKnownElements);
        this.selectionProvider = new EarlySelectionProvider((ISelectionProvider)this.tableViewer, this.getKnownElements()){

            protected void notifyViewer(IStructuredSelection newSelection) {
                if (!newSelection.isEmpty()) {
                    SimpleTableViewer.this.tableViewer.reveal(newSelection.getFirstElement());
                }
                super.notifyViewer(newSelection);
            }

            public ISelection getSelection() {
                return FilteredSelectionProvider.getFilteredSelection(super.getSelection(), PendingNodeFilter.getDefault());
            }

            protected void doFireSelectionChange(ISelection selection) {
                super.doFireSelectionChange(FilteredSelectionProvider.getFilteredSelection(selection, PendingNodeFilter.getDefault()));
            }
        };
    }

    public void setRowDecorator(IViewerLabelProvider provider) {
        if (this.rowDecorator != null) {
            this.rowDecorator.removeListener(this.rowDecoratorListener);
            this.rowDecorator.dispose();
        }
        this.rowDecorator = provider;
        if (provider != null) {
            provider.addListener(this.rowDecoratorListener);
        }
    }

    public void reveal(Object toReveal) {
        this.tableViewer.reveal(toReveal);
    }

    public void setDoubleClickHandler(IRunnableWithSelection runnable) {
        this.runnableWithSelection = runnable;
    }

    public void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
        this.tableViewer.addDragSupport(operations, transferTypes, listener);
    }

    public IContextMenuHandler getContextMenuHandler() {
        return this.cmh;
    }

    private void showSubmenu(IContributionItem object) {
        if (object == this.currentSubmenu) {
            return;
        }
        if (this.currentSubmenu != null) {
            this.popupMenu.remove(this.currentSubmenu);
            this.currentSubmenu = null;
        }
        if (object != null) {
            this.popupMenu.prependToGroup(COLUMN_ACTIONS, object);
            this.currentSubmenu = object;
        }
        this.popupMenu.markDirty();
    }

    protected Display getDisplay() {
        return this.tableViewer.getTable().getDisplay();
    }

    protected void disposed() {
        this.storePrefs();
        if (this.popupMenu != null) {
            this.popupMenu.dispose();
        }
        this.selectionProvider.dispose();
        if (this.rowDecorator != null) {
            this.rowDecorator.removeListener(this.rowDecoratorListener);
            this.rowDecorator.dispose();
            this.rowDecorator = null;
        }
        this.tableViewer.getTable().removeListener(40, this.eraseListener);
        this.tableViewer.getTable().removeListener(42, this.paintListener);
        for (ColumnData<R> next : this.columnData) {
            next.dispose();
        }
        for (ColumnData<R> next : this.columnData) {
            next.getColumn().dispose();
        }
        this.columnData.clear();
        this.mapTableViewerColumnOntoColumnData.clear();
        this.tableHeaderListeners.clear();
    }

    public void storePrefs() {
        if (this.savedState == null) {
            return;
        }
        for (ColumnData<R> next : this.columnData) {
            Preferences pref = this.savedState.node(next.getId());
            next.save(pref);
        }
        if (this.currentSorter != null) {
            this.savedState.put("sortColumn", this.currentSorter.data.getId());
            this.savedState.putBoolean("forwardSort", this.currentSorter.forwardSort);
        }
        try {
            this.savedState.flush();
        }
        catch (BackingStoreException e) {
            RepositoryUiPlugin.log(e);
        }
    }

    public MenuManager getContextMenu() {
        return this.popupMenu;
    }

    public void setSelectionCriteria(IFilter newSelection) {
        this.selectionProvider.setSelection(newSelection);
    }

    public void setInput(ISetWithListeners<R> _input) {
        ISetWithListeners input = _input == null ? EmptySetWithListeners.getInstance() : new PendingNodeSet(_input);
        this.savedInput = _input == null ? EmptySetWithListeners.getInstance() : _input;
        try {
            this.selectionProvider.disableEvents(true);
            boolean wasDeferred = this.deferredSet.isDeferred();
            this.deferredSet = new DeferredSet(input);
            this.deferredSet.setDeferred(wasDeferred);
            this.tableViewer.setInput((Object)this.deferredSet);
        }
        finally {
            this.selectionProvider.disableEvents(false);
        }
    }

    public void setSortColumn(TableViewerColumn column, boolean forward) {
        ColumnData data = (ColumnData)this.mapTableViewerColumnOntoColumnData.get(column);
        this.doSetSortColumn(data, forward);
    }

    public TableViewerColumn getSortColumn() {
        SimpleTableViewerColumnSorter<R> currentSorter = null;
        currentSorter = this.getCurrentColumnSorter();
        if (currentSorter == null) {
            return null;
        }
        return currentSorter.getData().getColumn();
    }

    public boolean isForwardSort() {
        SimpleTableViewerColumnSorter<R> currentSorter = this.getCurrentColumnSorter();
        if (currentSorter == null) {
            return true;
        }
        return currentSorter.isForwardSort();
    }

    private SimpleTableViewerColumnSorter<R> getCurrentColumnSorter() {
        if (this.customSorter == null && !this.sortHistory.isEmpty()) {
            this.currentSorter = this.sortHistory.iterator().next();
        }
        return this.currentSorter;
    }

    private void doSetSortColumn(ColumnData column, boolean forward) {
        Table table = this.tableViewer.getTable();
        if (this.customSorter != null) {
            table.setSortColumn(null);
            table.setSortDirection(0);
            return;
        }
        SimpleTableViewerColumnSorter newSorter = new SimpleTableViewerColumnSorter(column, forward);
        if (column == null || column.getSwtWidget() == null) {
            table.setSortColumn(null);
            table.setSortDirection(0);
        } else {
            table.setSortColumn(column.getSwtWidget());
            table.setSortDirection(forward ? 128 : 1024);
        }
        this.removeFromSortHistory(column);
        ArrayList<SimpleTableViewerColumnSorter<R>> newSortHistory = new ArrayList<SimpleTableViewerColumnSorter<R>>();
        newSortHistory.add(newSorter);
        newSortHistory.addAll(this.sortHistory);
        this.sortHistory = newSortHistory;
        this.setSortOrder(newSorter);
    }

    private void removeFromSortHistory(ColumnData column) {
        SimpleTableViewerColumnSorter<R> found = null;
        for (SimpleTableViewerColumnSorter<R> next : this.sortHistory) {
            if (next.data != column) continue;
            found = next;
            break;
        }
        if (found != null) {
            this.sortHistory.remove(found);
        }
    }

    private void setSortOrder(SimpleTableViewerColumnSorter<R> order) {
        this.currentSorter = order;
        this.tableViewer.setSorter((ViewerSorter)new ComparatorSorter(new MultiComparator<R>(this.sortHistory)));
    }

    public void setLimit(int limit) {
    }

    public void setFilter(IFilter filter) {
        this.contentProvider.setFilter(filter);
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void setVisible(TableViewerColumn<R> theColumn, boolean visible) {
        ColumnData columnData = (ColumnData)this.mapTableViewerColumnOntoColumnData.get(theColumn);
        if (columnData != null) {
            columnData.setVisible(visible);
        }
    }

    public void addColumn(TableViewerColumn<R> theColumn) {
        ++this.columnCounter;
        String key = "" + this.columnCounter;
        Preferences columnState = null;
        if (this.savedState != null) {
            columnState = this.savedState.node(key);
        }
        ColumnData data = new ColumnData(theColumn, this.tableViewer.getTable(), columnState, key, this.columnCounter, this.headerSelectionListener);
        this.columnData.add(data);
        this.mapTableViewerColumnOntoColumnData.put(theColumn, data);
        data.labelProvider.addListener(this.columnLabelProviderListener);
        if (this.columnData.size() == 1) {
            this.doSetSortColumn(data, !theColumn.isDefaultSortOrderInverted());
        }
        if (this.savedState != null) {
            String sortCol = this.savedState.get("sortColumn", "");
            if (data.getId().equals(sortCol)) {
                this.doSetSortColumn(data, this.savedState.getBoolean("forwardSort", true));
            }
        }
        this.columnsMenu.setVisible(this.columnCounter > 1);
    }

    public void removeColumn(TableViewerColumn theColumn) {
        ColumnData data = (ColumnData)this.mapTableViewerColumnOntoColumnData.remove(theColumn);
        if (data != null) {
            this.removeFromSortHistory(data);
            this.columnData.remove(data);
            data.labelProvider.removeListener(this.columnLabelProviderListener);
            data.dispose();
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getSelectionProvider().getSelection();
    }

    public SimpleTableViewer setProgressService(IBusyHandler progress) {
        this.contentProvider.setProgressService(progress);
        return this;
    }

    public ISetWithListeners<R> getKnownElements() {
        return this.knownElements;
    }

    public void setSorter(Comparator<R> comparator) {
        this.customSorter = comparator;
        this.doSetSortColumn(null, true);
        MixedTypeComparator pendingNodeFilter = new MixedTypeComparator().put(String.class, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        }).put(Object.class, comparator);
        this.tableViewer.setSorter((ViewerSorter)new ComparatorSorter((Comparator)((Object)pendingNodeFilter)));
    }

    public void deferUpdates(boolean isDeferred) {
        this.deferredSet.setDeferred(isDeferred);
    }

    public void addHeaderListener(IPartResult<TableViewerColumn<R>> toAdd) {
        this.tableHeaderListeners.add(toAdd);
    }

    public void removeHeaderListener(IPartResult<TableViewerColumn<R>> toRemove) {
        this.tableHeaderListeners.remove(toRemove);
    }

    private ColumnData<R> getColumnData(TableColumn tc) {
        return (ColumnData)tc.getData(ColumnData.class.getName());
    }

    public ISetWithListeners<R> getInput() {
        return this.savedInput;
    }
}

