/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSelectionProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public final class FilteredSelectionProvider
extends AbstractSelectionProvider {
    private ISelectionProvider toFilter;
    private IFilter theFilter;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            FilteredSelectionProvider.this.fireSelectionChangedEvent(FilteredSelectionProvider.getFilteredSelection(event.getSelection(), FilteredSelectionProvider.this.theFilter));
        }
    };

    public FilteredSelectionProvider(ISelectionProvider theSelectionProvider, IFilter theFilter) {
        this.toFilter = theSelectionProvider;
        this.theFilter = theFilter;
    }

    protected void allocate() {
        this.toFilter.addSelectionChangedListener(this.selectionChangedListener);
        super.allocate();
    }

    protected void deallocate() {
        this.toFilter.removeSelectionChangedListener(this.selectionChangedListener);
        super.deallocate();
    }

    public static ISelection getFilteredSelection(ISelection selection, IFilter toApply) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection toFilter = (IStructuredSelection)selection;
            boolean hasFilteredNodes = false;
            for (Object next : toFilter) {
                if (toApply.select(next)) continue;
                hasFilteredNodes = true;
                break;
            }
            if (hasFilteredNodes) {
                ArrayList<Object> resultCollection = new ArrayList<Object>();
                Object[] resultArray = toFilter.toArray();
                int i = 0;
                while (i < resultArray.length) {
                    Object object = resultArray[i];
                    if (toApply.select(object)) {
                        resultCollection.add(object);
                    }
                    ++i;
                }
                return new StructuredSelection(resultCollection);
            }
        }
        return selection;
    }

    public ISelection getSelection() {
        return FilteredSelectionProvider.getFilteredSelection(this.toFilter.getSelection(), this.theFilter);
    }
}

