/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.NullSelectionTester;
import com.ibm.team.repository.rcp.ui.internal.viewers.RowSelectionTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class EarlySelectionProvider
implements ISelectionProvider {
    List listeners = new ArrayList();
    ISelectionProvider originalSelection;
    ISetWithListeners visibleElements;
    int firingSelectionChange = 0;
    IFilter requestedSelection = NullSelectionTester.getDefault();
    private ISelection savedSelection;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (EarlySelectionProvider.this.firingSelectionChange == 0) {
                EarlySelectionProvider.this.requestedSelection = NullSelectionTester.getDefault();
            }
            EarlySelectionProvider.this.doFireSelectionChange(event.getSelection());
        }
    };
    private ISetListener elementListener = new ISetListener(){

        public void changed(SetDiff diff) {
            if (!diff.getAdditions().isEmpty()) {
                EarlySelectionProvider.this.processAdds(diff.getAdditions().toArray());
            }
        }
    };

    public EarlySelectionProvider(ISelectionProvider provider, ISetWithListeners knownElements) {
        this.originalSelection = provider;
        this.visibleElements = knownElements;
        if (this.originalSelection != null) {
            this.originalSelection.addSelectionChangedListener(this.listener);
            this.visibleElements.addListener(this.elementListener);
        }
    }

    protected void updateSelection() {
        IStructuredSelection result = this.computeSelection();
        this.doFireSelectionChange((ISelection)result);
    }

    private IStructuredSelection computeSelection() {
        return (IStructuredSelection)this.originalSelection.getSelection();
    }

    public void dispose() {
        this.originalSelection.removeSelectionChangedListener(this.listener);
        this.visibleElements.removeListener(this.elementListener);
        this.requestedSelection = NullSelectionTester.getDefault();
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.originalSelection.getSelection();
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void doFireSelectionChange(ISelection selection) {
        if (this.firingSelectionChange != 0) {
            return;
        }
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listenersArray = this.listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            ISelectionChangedListener l = (ISelectionChangedListener)listenersArray[i];
            try {
                l.selectionChanged(e);
            }
            catch (RuntimeException ex) {
                StatusUtil.log(this.getClass(), (Throwable)ex);
            }
            ++i;
        }
    }

    private void addToSelection(Set toAdd) {
        ISelection current;
        if (this.originalSelection != null && (current = this.originalSelection.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)current;
            ArrayList elements = new ArrayList();
            elements.addAll(ss.toList());
            elements.addAll(toAdd);
            this.doSetSelection(elements);
        }
    }

    protected void notifyViewer(IStructuredSelection newSelection) {
        this.originalSelection.setSelection((ISelection)newSelection);
        this.originalSelection.getSelection();
    }

    protected boolean inSelection(Object entry) {
        return this.requestedSelection.select(entry);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            List selectedEntries = ss.toList();
            HashSet selectionSet = new HashSet();
            selectionSet.addAll(selectedEntries);
            this.setSelection(new RowSelectionTester(selectionSet));
        }
    }

    public void setSelection(IFilter selectionTester) {
        try {
            this.disableEvents(true);
            if (selectionTester == null) {
                selectionTester = NullSelectionTester.getDefault();
            }
            this.requestedSelection = selectionTester;
            ArrayList newSelection = new ArrayList();
            if (this.visibleElements != null) {
                for (Object next : this.visibleElements.toCollection()) {
                    if (!selectionTester.select(next)) continue;
                    newSelection.add(next);
                }
            }
            this.doSetSelection(newSelection);
        }
        finally {
            this.disableEvents(false);
        }
    }

    private void doSetSelection(Collection newSelection) {
        try {
            this.disableEvents(true);
            HashSet oldSelectedElements = new HashSet();
            ISelection oldSel = this.getSelection();
            if (oldSel instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)oldSel;
                oldSelectedElements.addAll(ss.toList());
            }
            HashSet newSelectedElements = new HashSet();
            newSelectedElements.addAll(newSelection);
            boolean foundDifference = false;
            if (oldSelectedElements.size() != newSelectedElements.size()) {
                foundDifference = true;
            }
            Iterator iterator = newSelection.iterator();
            while (!foundDifference && iterator.hasNext()) {
                Object next = iterator.next();
                if (oldSelectedElements.contains(next)) continue;
                foundDifference = true;
            }
            if (foundDifference) {
                this.notifyViewer((IStructuredSelection)new StructuredSelection(newSelection.toArray()));
            }
        }
        finally {
            this.disableEvents(false);
        }
    }

    private void processAdds(Object[] added) {
        HashSet<Object> toAdd = null;
        int i = 0;
        while (i < added.length) {
            Object object = added[i];
            if (this.inSelection(object)) {
                if (toAdd == null) {
                    toAdd = new HashSet<Object>();
                }
                toAdd.add(object);
            }
            ++i;
        }
        if (toAdd != null) {
            this.addToSelection(toAdd);
        }
    }

    public void disableEvents(boolean b) {
        if (b) {
            if (this.firingSelectionChange == 0) {
                this.savedSelection = this.getSelection();
            }
            ++this.firingSelectionChange;
        } else {
            --this.firingSelectionChange;
            if (this.firingSelectionChange == 0) {
                ISelection newSelection = this.getSelection();
                if (this.savedSelection != null && !this.savedSelection.equals(newSelection)) {
                    this.doFireSelectionChange(newSelection);
                }
                this.savedSelection = null;
            }
        }
    }
}

