/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.tree.IParentProvider;
import com.ibm.team.repository.rcp.ui.internal.tree.ObservableSetToSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.tree.ObservableTreeContentProvider;
import com.ibm.team.repository.rcp.ui.internal.tree.SetWithListenersToObservableSet;
import com.ibm.team.repository.rcp.ui.internal.tree.TreeProviderToObservableTree;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class ConcurrentTreeContentProvider
implements ITreeContentProvider,
ITreePathContentProvider {
    public static final Object PROP_DIRTY = new Object();
    public static final Object PROP_CLEAN = new Object();
    private ChangeListenerList dirtyListener = new ChangeListenerList();
    private int dirtyCount;
    private ObservableTreeContentProvider nested;
    private ISetWithListeners knownElements;

    public ConcurrentTreeContentProvider(ITreeProvider provider) {
        this(provider, Messages.ConcurrentTreeContentProvider_0, true);
    }

    public void setMaxPrefetches(int max) {
        this.nested.setMaxPrefetches(max);
    }

    public ConcurrentTreeContentProvider(ITreeProvider provider, Object pendingNode, boolean useRefresh) {
        this.nested = new ObservableTreeContentProvider(new TreeProviderToObservableTree(provider), pendingNode, useRefresh);
        this.knownElements = new ObservableSetToSetWithListeners(this.nested.getKnownElements());
    }

    public void useTreePaths(boolean usePaths) {
        this.nested.useTreePaths(usePaths);
    }

    public void setRootPath(IParentProvider path) {
        this.nested.setRootPath(path);
    }

    public int getDirtyCount() {
        return this.dirtyCount;
    }

    public void addDirtyListener(IChangeListener toAdd) {
        this.dirtyListener.add(toAdd);
    }

    public void removeDirtyListener(IChangeListener toRemove) {
        this.dirtyListener.remove(toRemove);
    }

    public Object[] getChildren(Object parentElement) {
        return this.nested.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.nested.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.nested.hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.nested.getElements(inputElement);
    }

    public ISetWithListeners getChildrenSet(Object parent) {
        IObservableSet children = this.nested.getChildrenSet(parent);
        if (children instanceof SetWithListenersToObservableSet) {
            SetWithListenersToObservableSet adapter = (SetWithListenersToObservableSet)children;
            return adapter.getWrapped();
        }
        return new ObservableSetToSetWithListeners(children);
    }

    public void dispose() {
        this.dirtyListener.removeAll();
        this.nested.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.nested.inputChanged(viewer, oldInput, newInput);
    }

    public ISetWithListeners getKnownElements() {
        return this.knownElements;
    }

    public boolean isDirty(Object element) {
        return this.nested.isDirty(element);
    }

    public TreeViewer getViewer() {
        return this.nested.getViewer();
    }

    public Object[] getChildren(TreePath parentPath) {
        return this.nested.getChildren(parentPath);
    }

    public TreePath[] getParents(Object element) {
        return this.nested.getParents(element);
    }

    public boolean hasChildren(TreePath path) {
        return this.nested.hasChildren(path);
    }

    public Object getPendingNode() {
        return this.nested.getPendingNode();
    }

    public int getMaxPrefetches() {
        return this.nested.getMaxPrefetches();
    }
}

