/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.viewers;

import com.ibm.team.repository.rcp.core.utils.CategoryComparator;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuExt;
import com.ibm.team.repository.rcp.ui.internal.viewers.DelegatingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.DelegatingSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.EmptySetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.FilteredSelectionProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleComboViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.UnionSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import java.util.Comparator;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboWithActions<T, S> {
    private SimpleComboViewer combo;
    private IMenuExt menu;
    protected Comparator comparator = null;
    private UnionSet elements = new UnionSet();
    private ISetWithListeners<T> userElements = EmptySetWithListeners.getInstance();
    private WritableSetWithListeners<T> customSelection = new WritableSetWithListeners();
    private WritableSetWithListeners<S> specialValues = new WritableSetWithListeners();
    private DelegatingSetWithListeners<T> knownElements = new DelegatingSetWithListeners();
    private CategoryComparator sorter = new CategoryComparator(){

        protected int category(Object e1) {
            if (e1 instanceof IActionExt) {
                return 2;
            }
            if (ComboWithActions.this.specialValues.toCollection().contains(e1)) {
                return 1;
            }
            return 0;
        }

        protected int compareSameCategory(int category, Object e1, Object e2) {
            if (category == 2) {
                return ComboWithActions.this.menu.getOrder().compare(e1, e2);
            }
            if (category == 0 && ComboWithActions.this.comparator != null) {
                return ComboWithActions.this.comparator.compare(e1, e2);
            }
            String l1 = ComboWithActions.this.labelProvider.getText(e1);
            String l2 = ComboWithActions.this.labelProvider.getText(e2);
            return l1.compareToIgnoreCase(l2);
        }
    };
    private DelegatingLabelProvider labelProvider = new DelegatingLabelProvider(){

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof IActionExt) {
                IActionExt action = (IActionExt)element;
                label.setText(action.getText());
                return;
            }
            super.updateLabel(label, element);
        }
    };
    private ISelectionProvider selectionProvider;
    private Object oldSelection;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection) {
                Object selection = ((IStructuredSelection)sel).getFirstElement();
                if (selection instanceof IActionExt) {
                    final IActionExt action = (IActionExt)selection;
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            ComboWithActions.this.combo.setSelectedElement(ComboWithActions.this.oldSelection);
                            action.run();
                        }
                    });
                } else {
                    ComboWithActions.this.oldSelection = selection;
                }
            }
        }
    };
    private T customSelectedElement;
    private IStaleListener staleListener = new IStaleListener(){

        public void setStale(Object staleObject, boolean isStale) {
            ComboWithActions.this.updateStale();
        }
    };
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            ComboWithActions.this.dispose();
        }
    };
    private boolean enabledState = true;
    private boolean computingInitialState = false;

    public ComboWithActions(Composite parent) {
        this(parent, 2060);
    }

    public ComboWithActions(Composite parent, int flags) {
        this.combo = new SimpleComboViewer(parent, flags);
        this.combo.getControl().addDisposeListener(this.disposeListener);
        this.combo.setSorter((Comparator)this.sorter);
        this.menu = new MenuExt();
        this.elements.add(this.userElements);
        this.elements.add(this.menu.getEntries());
        this.elements.add(this.customSelection);
        this.elements.add(this.specialValues);
        this.combo.setInput(this.elements);
        this.combo.setLabelProvider(this.labelProvider);
        this.selectionProvider = new FilteredSelectionProvider(this.combo.getSelectionProvider(), new IFilter(){

            public boolean select(Object toTest) {
                return !(toTest instanceof IActionExt);
            }
        });
        this.combo.getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
        this.labelProvider.setLabelProvider(LabelProviders.create(this.combo.getKnownElements()));
    }

    public void setLabelProvider(IViewerLabelProvider labelProvider) {
        this.labelProvider.setLabelProvider(labelProvider);
    }

    public void setMenu(IMenuExt menu) {
        this.elements.remove(menu.getEntries());
        this.menu = menu;
        this.elements.add(menu.getEntries());
    }

    public void setInput(ISetWithListeners<T> newElements) {
        this.userElements.removeStaleListener(this.staleListener);
        this.elements.remove(this.userElements);
        this.userElements = newElements;
        this.knownElements.setTarget(this.userElements);
        this.elements.add(newElements);
        this.userElements.addStaleListener(this.staleListener);
        if (this.userElements.isStale()) {
            this.computingInitialState = true;
        }
        this.updateEnablement();
    }

    private void updateStale() {
        if (!this.userElements.isStale()) {
            this.computingInitialState = false;
        }
        this.updateEnablement();
    }

    private void updateEnablement() {
        boolean enabledState = !this.computingInitialState && this.enabledState;
        this.combo.setEnabled(enabledState);
    }

    public void setSorter(Comparator<T> sorter) {
        this.comparator = sorter;
    }

    public Control getControl() {
        return this.combo.getControl();
    }

    public void selectSpecialValue(Object specialValue) {
        if (this.specialValues.toCollection().contains(specialValue)) {
            this.combo.setSelectedElement(specialValue);
        }
    }

    public void setSelectedElement(T r) {
        if (this.customSelectedElement != null) {
            this.customSelection.remove(this.customSelectedElement);
        }
        this.combo.setSelectedElement(r);
        this.customSelectedElement = r;
        if (this.customSelectedElement != null) {
            this.customSelection.add(this.customSelectedElement);
        }
    }

    public void addSpecialValue(S specialValueToAdd) {
        this.specialValues.add(specialValueToAdd);
    }

    public void removeSpecialValue(S specialValueToRemove) {
        this.specialValues.remove(specialValueToRemove);
    }

    public T getSelectedElement() {
        Object result = ((IStructuredSelection)this.selectionProvider.getSelection()).getFirstElement();
        if (this.userElements.toCollection().contains(result) || this.customSelection.toCollection().contains(result)) {
            return (T)result;
        }
        return null;
    }

    public S getSelectedSpecialValue() {
        Object result = ((IStructuredSelection)this.selectionProvider.getSelection()).getFirstElement();
        if (this.specialValues.toCollection().contains(result)) {
            return (S)result;
        }
        return null;
    }

    public final ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public final ISetWithListeners<T> getKnownElements() {
        return this.knownElements;
    }

    protected void dispose() {
        this.userElements.removeStaleListener(this.staleListener);
    }

    public void setEnabled(boolean b) {
        this.enabledState = b;
        this.updateEnablement();
    }

    public boolean getEnabled() {
        return this.enabledState;
    }
}

