/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuViewer;
import com.ibm.team.repository.rcp.ui.internal.menus.RadioAction;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import com.ibm.team.repository.rcp.ui.parts.IMnemonicGenerationAlgorithm;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.util.Collections;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class ToolkitUtil {
    private static final String IMAGE_DESCRIPTOR = "image_descriptor";

    public static Control createRadio(WidgetToolkit toolkit, MnemonicGenerator generator, Composite parent, String name, Object value, WritableValue currentState) {
        return ToolkitUtil.createButton(toolkit, generator, parent, new RadioAction(name, value, currentState));
    }

    public static Control createRadio(WidgetToolkit toolkit, Composite parent, String name, Object value, WritableValue currentState) {
        return ToolkitUtil.createButton(toolkit, parent, (IActionExt)new RadioAction(name, value, currentState));
    }

    public static Control createRadio(WidgetFactoryContext context, Composite parent, String name, Object value, WritableValue currentState) {
        return ToolkitUtil.createButton(context.getToolkit(), parent, (IActionExt)new RadioAction(name, value, currentState));
    }

    public static Control createButton(WidgetFactoryContext context, Composite parent, IActionExt action) {
        return ToolkitUtil.createButton(context.getToolkit(), context.getMnemonics(), parent, action);
    }

    public static Control createButton(WidgetToolkit toolkit, Composite parent, IActionExt next) {
        return ToolkitUtil.createButton(toolkit, new MnemonicGenerator(false), parent, next);
    }

    public static Control createButton(WidgetToolkit toolkit, MnemonicGenerator mnemonics, Composite parent, IActionExt next) {
        int style = next.getStyle();
        if (style == 64 || style == 4) {
            style = 8;
        }
        Button theButton = toolkit.createButton(parent, mnemonics.generateLabel(Collections.EMPTY_SET, next.getText()), style);
        new ActionButtonListener(theButton, next, mnemonics);
        return theButton;
    }

    static void updateAction(Button item, ResourceManager resources, IMnemonicGenerationAlgorithm mnemonics, IActionExt next) {
        if (next == null) {
            ToolkitUtil.setImage(item, resources, null);
            return;
        }
        String text = mnemonics.generateLabel(Collections.EMPTY_SET, next.getText());
        if (!Util.equals((Object)text, (Object)item.getText())) {
            item.setText(text);
        }
        if ((text = next.getTooltipText()).equals("")) {
            text = null;
        }
        if (!Util.equals((Object)text, (Object)item.getToolTipText())) {
            item.setToolTipText(text);
        }
        if (item.getEnabled() != next.isEnabled()) {
            item.setEnabled(next.isEnabled());
        }
        if (item.getSelection() != next.getSelection()) {
            item.setSelection(next.getSelection());
        }
    }

    private static void setImage(Button item, ResourceManager resources, ImageDescriptor newImage) {
        ImageDescriptor oldImage = (ImageDescriptor)item.getData(IMAGE_DESCRIPTOR);
        if (Util.equals((Object)newImage, (Object)oldImage)) {
            return;
        }
        if (newImage != null) {
            item.setImage(resources.createImageWithDefault(newImage));
        } else {
            item.setImage(null);
        }
        if (oldImage != null) {
            resources.destroy((DeviceResourceDescriptor)oldImage);
        }
        item.setData(IMAGE_DESCRIPTOR, (Object)newImage);
    }

    public static Control createRadio(Composite parent, WidgetFactoryContext context, String name, Object value, WritableValue sourceType) {
        return ToolkitUtil.createRadio(context.getToolkit(), context.getMnemonics(), parent, name, value, sourceType);
    }

    private static final class ActionButtonListener
    extends SelectionAdapter
    implements IChangeListener,
    DisposeListener,
    Listener {
        Button theButton;
        IActionExt theAction;
        private Menu submenu;
        private LocalResourceManager resources;
        private MnemonicGenerator mnemonics;
        private char mnemonic = '\u0000';

        public ActionButtonListener(Button theButton, IActionExt theAction, MnemonicGenerator mnemonics) {
            this.theButton = theButton;
            this.theAction = theAction;
            this.mnemonics = mnemonics;
            this.resources = new LocalResourceManager(JFaceResources.getResources());
            theButton.addDisposeListener((DisposeListener)this);
            theAction.addChangeListener(this);
            if (theAction.getStyle() == 64) {
                theButton.addListener(3, (Listener)this);
            } else {
                theButton.addSelectionListener((SelectionListener)this);
            }
            IMenuExt children = theAction.getSubmenu();
            this.submenu = null;
            if (children != null) {
                this.submenu = new Menu((Control)theButton);
                new MenuViewer(this.submenu, children);
                theButton.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        ActionButtonListener.this.submenu.dispose();
                    }
                });
            }
            ToolkitUtil.updateAction(theButton, (ResourceManager)this.resources, mnemonics, theAction);
            this.reserveMnemonic();
        }

        private void reserveMnemonic() {
            this.mnemonic = LegacyActionTools.extractMnemonic((String)this.theButton.getText());
            this.mnemonics.reserve(this.mnemonic);
        }

        public void changed(Object source, Object property) {
            this.releaseMnemonic();
            ToolkitUtil.updateAction(this.theButton, (ResourceManager)this.resources, this.mnemonics, this.theAction);
            this.reserveMnemonic();
        }

        private void releaseMnemonic() {
            if (this.mnemonic != '\u0000') {
                this.mnemonics.unreserve(this.mnemonic);
                this.mnemonic = '\u0000';
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            this.releaseMnemonic();
            this.theAction.removeChangeListener(this);
            this.resources.dispose();
        }

        public void handleEvent(Event e) {
            if (this.submenu != null) {
                Point p = new Point(e.x, e.y);
                p = Display.getCurrent().map((Control)this.theButton.getParent(), null, p);
                this.submenu.setLocation(p);
                this.submenu.setVisible(true);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.detail == 4) {
                if (this.submenu != null) {
                    Point p = new Point(e.x, e.y);
                    p = Display.getCurrent().map((Control)this.theButton.getParent(), null, p);
                    this.submenu.setLocation(p);
                    this.submenu.setVisible(true);
                }
            } else {
                this.theAction.run();
            }
        }
    }
}

