/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.repository.rcp.core.utils.ClassIdentifier;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.AbstractElementFactory;
import com.ibm.team.repository.rcp.ui.internal.utils.MementoUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistableFactory
extends AbstractElementFactory<Object>
implements IExecutableExtension {
    private IConfigurationElement element;
    private ClassIdentifier implementation;
    private boolean initialized = false;
    private Method loadMethod;
    private Object id;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object create(IMemento memento) throws CoreException {
        if (!this.initialized) {
            try {
                Method theMethod;
                Class clazz;
                try {
                    clazz = this.implementation.loadClass();
                }
                catch (ClassNotFoundException e) {
                    StatusUtil.log((Object)this, (Throwable)e);
                    return null;
                }
                try {
                    theMethod = clazz.getMethod("loadState", IMemento.class, String.class);
                }
                catch (NoSuchMethodException e) {
                    StatusUtil.log((Object)this, (Throwable)e);
                    return null;
                }
                catch (SecurityException e) {
                    StatusUtil.log((Object)this, (Throwable)e);
                    return null;
                }
                if (!Modifier.isStatic(theMethod.getModifiers())) {
                    this.log("The loadState method must be static");
                    return null;
                }
                this.loadMethod = theMethod;
            }
            finally {
                this.initialized = true;
            }
        }
        try {
            return this.loadMethod.invoke(null, memento, this.id);
        }
        catch (Exception e) {
            throw new CoreException(StatusUtil.newStatus((Object)this, (Throwable)e));
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.element = config;
        if (!(data instanceof String) || ((String)data).length() == 0) {
            this.throwException(config, NLS.bind((String)"PersistableFactory needs to specify the name of the adapter. Correct usage: '{0}:com.ibm.NameOfAnAdapterImplementation", (Object)this.getClass().getName()));
        }
        this.id = MementoUtil.getString(config, "id");
        this.implementation = new ClassIdentifier(config.getNamespace(), (String)data);
    }

    private void throwException(IConfigurationElement config, String string) throws CoreException {
        throw new CoreException(StatusUtil.newStatus((Object)this, (String)this.formatError(string), null));
    }

    private String formatError(String string) {
        return NLS.bind((String)"Error in the {0} adapter declared in plugin {0}: {1}", (Object[])new String[]{this.getClass().getName(), this.element.getNamespace(), string});
    }

    private void log(String formatError) {
        StatusUtil.log((Object)this, (String)formatError);
    }
}

