/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.utils;

import com.ibm.team.foundation.common.util.Adapters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class AdapterCache {
    private Collection input = Collections.EMPTY_LIST;
    private Map cache = new HashMap();
    private Map knownResults = new HashMap();
    private Map knownCounts = new HashMap();

    AdapterCache() {
    }

    public void flush() {
        this.cache.clear();
        this.knownResults.clear();
        this.knownCounts.clear();
    }

    public Collection getInput() {
        return this.input;
    }

    public void setInput(Collection newInput) {
        if (this.cache.isEmpty()) {
            this.input = newInput;
        }
        if (!newInput.equals(this.input)) {
            this.input = newInput;
            this.flush();
        }
    }

    public int adapterCount(String type) {
        return this.getAdapters(type).size();
    }

    public boolean hasAdapter(String type) {
        Boolean result = (Boolean)this.knownResults.get(type);
        if (result != null) {
            return result;
        }
        Collection cachedResult = (Collection)this.cache.get(type);
        if (cachedResult != null) {
            return !cachedResult.isEmpty();
        }
        boolean foundAdapter = false;
        Iterator iter = this.input.iterator();
        while (iter.hasNext() && !foundAdapter) {
            Object next = iter.next();
            Object adapter = Adapters.getAdapter(next, (String)type);
            if (adapter == null) continue;
            foundAdapter = true;
        }
        result = new Boolean(foundAdapter);
        this.knownResults.put(type, result);
        return result;
    }

    public Collection getAdapters(String type) {
        Collection cachedResult = (Collection)this.cache.get(type);
        if (cachedResult != null) {
            return cachedResult;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object next : this.input) {
            Object adapter = Adapters.getAdapter(next, (String)type);
            if (adapter == null) continue;
            result.add(adapter);
        }
        this.cache.put(type, result);
        return result;
    }
}

