/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.tree;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.tree.AbstractObservableSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;

public class SetWithListenersToObservableSet
extends AbstractObservableSet
implements IRefreshable {
    private ISetWithListeners setWithListeners;
    private ISetListener wrappedListener = new ISetListener(){

        public void changed(SetDiff diff) {
            SetWithListenersToObservableSet.this.setStale(SetWithListenersToObservableSet.this.setWithListeners.isStale());
            SetWithListenersToObservableSet.this.fireSetChange(Diffs.createSetDiff((Set)diff.getAdditions(), (Set)diff.getRemovals()));
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        public void setStale(Object staleObject, boolean isStale) {
            boolean wasStale = SetWithListenersToObservableSet.this.isStale();
            SetWithListenersToObservableSet.this.setStale(SetWithListenersToObservableSet.this.setWithListeners.isStale());
            if (wasStale && !isStale) {
                SetWithListenersToObservableSet.this.fireSetChange(Diffs.createSetDiff((Set)Collections.EMPTY_SET, (Set)Collections.EMPTY_SET));
            }
        }
    };

    public SetWithListenersToObservableSet(ISetWithListeners set) {
        this.setWithListeners = set;
        this.setWithListeners.addStaleListener(this.staleListener);
        this.setStale(this.setWithListeners.isStale());
    }

    public ISetWithListeners getWrapped() {
        return this.setWithListeners;
    }

    public void refresh() {
        if (this.setWithListeners instanceof IRefreshable) {
            IRefreshable r = (IRefreshable)((Object)this.setWithListeners);
            r.refresh();
        }
    }

    public boolean canRefresh() {
        if (this.setWithListeners instanceof IRefreshable) {
            IRefreshable r = (IRefreshable)((Object)this.setWithListeners);
            return r.canRefresh();
        }
        return false;
    }

    protected void firstListenerAdded() {
        this.setWithListeners.addListener(this.wrappedListener);
        super.firstListenerAdded();
    }

    protected void lastListenerRemoved() {
        this.setWithListeners.removeListener(this.wrappedListener);
        super.lastListenerRemoved();
    }

    protected Set getWrappedSet() {
        HashSet result = new HashSet();
        result.addAll(this.setWithListeners.toCollection());
        return result;
    }

    public Object getElementType() {
        return Object.class;
    }

    public void dispose() {
        this.setWithListeners.removeStaleListener(this.staleListener);
        if (this.hasListeners()) {
            this.setWithListeners.removeListener(this.wrappedListener);
        }
        super.dispose();
    }
}

