/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.query;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.ui.internal.query.IPageable;
import com.ibm.team.repository.rcp.ui.internal.query.Pager;
import com.ibm.team.repository.rcp.ui.internal.query.PopupLayout;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.parts.IContextMenuHandler;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedTable<T> {
    SimpleTableViewer<T> stv;
    Pager pager;
    private Composite popupParent;
    private IPageable pageable;
    private IChangeListener pageableListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            if (PagedTable.this.stv.getTable().isDisposed()) {
                return;
            }
            PagedTable.this.updatePagerVisibility();
        }
    };
    public boolean pagerVisible = false;

    public PagedTable(Composite parent, WidgetFactoryContext context, int style, Preferences savedState, IContextMenuHandler cmh) {
        WidgetToolkit toolkit = context.getToolkit();
        this.popupParent = toolkit.createComposite(parent);
        Table tbl = toolkit.createTable(this.popupParent, style);
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        this.stv = new SimpleTableViewer(tbl, savedState, cmh);
        this.pager = new Pager(this.popupParent, context);
        this.pager.getControl().setVisible(false);
        PopupLayout layout = new PopupLayout();
        this.popupParent.setLayout((Layout)layout);
        layout.setMainControl((Control)this.stv.getTable());
    }

    public SimpleTableViewer<T> getViewer() {
        return this.stv;
    }

    public void setInput(ISetWithListeners<T> newInput) {
        IPageable pageable = (IPageable)Adapters.getAdapter(newInput, IPageable.class);
        this.setPageable(pageable);
        this.stv.setInput(newInput);
    }

    private void setPageable(IPageable pageable) {
        if (this.pageable == pageable) {
            return;
        }
        if (this.pageable != null) {
            this.pageable.hasMore().removeChangeListener(this.pageableListener);
        }
        this.pageable = pageable;
        this.pager.setInput(pageable);
        if (this.pageable != null) {
            this.pageable.hasMore().addChangeListener(this.pageableListener);
        }
        this.updatePagerVisibility();
    }

    private void updatePagerVisibility() {
        boolean visible = false;
        if (this.pageable != null) {
            visible = this.pageable.hasMore().getValue().equals(true);
        }
        if (visible == this.pagerVisible) {
            return;
        }
        this.pagerVisible = visible;
        this.pager.getControl().setVisible(visible);
        this.popupParent.changed(new Control[]{this.pager.getControl()});
        this.popupParent.layout(false);
    }

    public Control getControl() {
        return this.popupParent;
    }
}

