/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.query;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.query.IPageable;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PagedQuery<T>
extends RepositoryQuery<T>
implements IPageable {
    private static final int PAGE_SIZE = 20;
    private int pageSize = 20;
    private boolean nextPageRequested;
    private int pagesFetched = 0;
    private IObservableValue hasMore;
    private IObservableValue fetchedSize;
    private IObservableValue totalSize;
    private QueryResult<T> result;

    public PagedQuery(ITeamRepository repository, IOperationRunner runner) {
        this(Realm.getDefault(), repository, runner);
    }

    public PagedQuery(Realm realm, ITeamRepository repository, IOperationRunner runner) {
        super(realm, repository, runner);
        this.hasMore = new WritableValue(realm);
        this.hasMore.setValue((Object)false);
        this.fetchedSize = new WritableValue(realm);
        this.fetchedSize.setValue((Object)new Long(0L));
        this.totalSize = new WritableValue(realm);
        this.totalSize.setValue((Object)new Long(0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final List<T> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean fetchNextPageCopy;
        int pageSizeCopy;
        PagedQuery pagedQuery = this;
        synchronized (pagedQuery) {
            pageSizeCopy = this.pageSize;
            fetchNextPageCopy = this.nextPageRequested;
            this.nextPageRequested = false;
        }
        if (fetchNextPageCopy || needsRefresh || this.result == null) {
            this.result = this.fetchNextPage(pageSizeCopy, monitor);
            pagedQuery = this;
            synchronized (pagedQuery) {
                ++this.pagesFetched;
            }
            this.getRealm().asyncExec(new Runnable(){

                public void run() {
                    PagedQuery.this.totalSize.setValue((Object)PagedQuery.this.result.resultSize());
                    PagedQuery.this.hasMore.setValue((Object)PagedQuery.this.result.hasMore());
                    PagedQuery.this.fetchedSize.setValue((Object)PagedQuery.this.result.getResult().size());
                }
            });
        }
        return this.result.getResult();
    }

    protected abstract QueryResult<T> fetchNextPage(int var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected final boolean internalHasMore() {
        return (Boolean)this.hasMore().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void goMore() {
        int pagesFetched;
        if (!this.internalHasMore()) {
            return;
        }
        PagedQuery pagedQuery = this;
        synchronized (pagedQuery) {
            this.nextPageRequested = true;
            pagesFetched = this.pagesFetched;
        }
        if (pagesFetched == 1) {
            this.setPageSize(this.pageSize + 20);
        } else if (pagesFetched == 4) {
            this.setPageSize(this.pageSize + 20);
        } else if (pagesFetched == 9) {
            this.setPageSize(this.pageSize + 20);
        } else {
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFlushCache(IProgressMonitor monitor) throws TeamRepositoryException {
        super.doFlushCache(monitor);
        PagedQuery pagedQuery = this;
        synchronized (pagedQuery) {
            this.pagesFetched = 0;
        }
    }

    @Override
    public IObservableValue fetchedSize() {
        return this.fetchedSize;
    }

    @Override
    public IObservableValue totalSize() {
        return this.totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageSize(int pageSize) {
        PagedQuery pagedQuery = this;
        synchronized (pagedQuery) {
            if (pageSize == this.pageSize) {
                return;
            }
            this.pageSize = pageSize;
        }
        this.update();
    }

    @Override
    public IObservableValue hasMore() {
        return this.hasMore;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class QueryResult<T> {
        private List<T> result;
        private boolean hasMore;
        private long resultSize;

        public QueryResult(List<T> result, long resultSize, boolean hasMore) {
            this.result = result;
            this.resultSize = resultSize;
            this.hasMore = hasMore;
        }

        public List<T> getResult() {
            return this.result;
        }

        public boolean hasMore() {
            return this.hasMore;
        }

        public long resultSize() {
            return this.resultSize;
        }

        public static <T> QueryResult<T> emptyResult() {
            return new QueryResult(Collections.emptyList(), 0L, false);
        }

        private void merge(QueryResult otherResult) {
            this.hasMore = otherResult.hasMore();
            this.resultSize += otherResult.resultSize();
            ArrayList<T> newResult = new ArrayList<T>((int)this.resultSize);
            newResult.addAll((Collection)otherResult.getResult());
            newResult.addAll(this.result);
            this.result = newResult;
        }
    }
}

