/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.query;

import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayIcon
extends CompositeImageDescriptor {
    private ImageDescriptor fBaseImageDescriptor;
    private ImageDescriptor[] fOverlays;
    private Point fSize;
    private int fStyle = -1;
    private int[] fStyles = null;

    public OverlayIcon(ImageDescriptor baseImageDescriptor, ImageDescriptor[] overlaysArray, Point sizeValue, int style) {
        this.fBaseImageDescriptor = baseImageDescriptor;
        this.fOverlays = overlaysArray;
        this.fSize = sizeValue;
        this.fStyle = style;
    }

    public OverlayIcon(ImageDescriptor baseImageDescriptor, ImageDescriptor[] overlaysArray, int style) {
        this.fBaseImageDescriptor = baseImageDescriptor;
        this.fOverlays = overlaysArray;
        this.fStyle = style;
        ImageData baseImageData = this.fBaseImageDescriptor.getImageData();
        this.fSize = baseImageData != null ? new Point(baseImageData.width, baseImageData.height) : new Point(0, 0);
    }

    protected void drawCompositeImage(int width, int height) {
        ImageDescriptor underlay = this.fOverlays[0];
        if (underlay != null) {
            this.drawImage(underlay.getImageData(), 0, 0);
        }
        if (this.fBaseImageDescriptor != null) {
            this.drawImage(this.fBaseImageDescriptor.getImageData(), 0, 0);
        }
        this.drawOverlays(this.fOverlays);
    }

    protected void drawOverlays(ImageDescriptor[] overlaysArray) {
        int i = 0;
        while (i < overlaysArray.length) {
            ImageDescriptor overlay = overlaysArray[i];
            if (overlay != null) {
                ImageData overlayData = overlay.getImageData();
                int styleToUse = this.fStyle == -1 ? this.fStyles[i] : this.fStyle;
                if (overlayData == null) {
                    overlayData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                if ((styleToUse & 0x80) != 0 && (styleToUse & 0x4000) != 0) {
                    this.drawImage(overlayData, 0, 0);
                } else if ((styleToUse & 0x80) != 0 && (styleToUse & 0x20000) != 0) {
                    this.drawImage(overlayData, this.fSize.x - overlayData.width, 0);
                } else if ((styleToUse & 0x400) != 0 && (styleToUse & 0x4000) != 0) {
                    this.drawImage(overlayData, 0, this.fSize.y - overlayData.height);
                } else if ((styleToUse & 0x400) != 0 && (styleToUse & 0x20000) != 0) {
                    this.drawImage(overlayData, this.fSize.x - overlayData.width, this.fSize.y - overlayData.height);
                }
            }
            ++i;
        }
    }

    protected Point getSize() {
        return this.fSize;
    }

    public int hashCode() {
        if (this.fBaseImageDescriptor != null) {
            int result = 1;
            result = 31 * result + this.fBaseImageDescriptor.hashCode();
            result = 31 * result + OverlayIcon.hashCode(this.fOverlays);
            result = 31 * result + (this.fSize == null ? 0 : this.fSize.hashCode());
            result = 31 * result + this.fStyle;
            result = 31 * result + OverlayIcon.hashCode(this.fStyles);
            return result;
        }
        return super.hashCode();
    }

    private static int hashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = 31 * result + array[index];
            ++index;
        }
        return result;
    }

    private static int hashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        OverlayIcon other = (OverlayIcon)((Object)obj);
        if (this.fBaseImageDescriptor == null) {
            return super.equals(obj);
        }
        if (!this.fBaseImageDescriptor.equals(other.fBaseImageDescriptor)) {
            return false;
        }
        if (!Arrays.equals(this.fOverlays, other.fOverlays)) {
            return false;
        }
        if (this.fSize == null ? other.fSize != null : !this.fSize.equals((Object)other.fSize)) {
            return false;
        }
        if (this.fStyle != other.fStyle) {
            return false;
        }
        return Arrays.equals(this.fStyles, other.fStyles);
    }
}

