/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.query;

import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.query.OverlayIcon;
import com.ibm.team.repository.rcp.ui.parts.INameable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.progress.UIJob;

public class DirtyBlinker {
    private static final long BLINK_INTERVAL = 500L;
    private static final int INTERVAL_COUNT = 10;
    private boolean fAlertIsShowing = false;
    private int fRemainingIterations = 10;
    private INameable nameable;
    private OverlayIcon alertImageDescriptor;
    private ImageDescriptor normalImageDescriptor;
    private boolean isDirty = false;
    private AlertJob blinkerJob = new AlertJob();

    public DirtyBlinker(INameable nameable, ImageDescriptor baseImage) {
        this.nameable = nameable;
        this.updateImage(baseImage);
    }

    private void updateImage(ImageDescriptor baseImage) {
        this.normalImageDescriptor = baseImage;
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.NEWINFO_OVRL;
        this.alertImageDescriptor = new OverlayIcon(baseImage, imageDescriptorArray, new Point(16, 16), 131200);
        this.updateIcon();
    }

    private void updateIcon() {
        if (this.fAlertIsShowing) {
            this.nameable.setImage((ImageDescriptor)this.alertImageDescriptor);
        } else {
            this.nameable.setImage(this.normalImageDescriptor);
        }
    }

    public void setImage(ImageDescriptor newImage) {
        this.updateImage(newImage);
    }

    public void setDirty(boolean dirtyState) {
        if (dirtyState == this.isDirty) {
            return;
        }
        if (dirtyState) {
            this.fRemainingIterations = 10;
            this.blinkerJob.schedule();
        } else {
            this.blinkerJob.cancel();
            this.fAlertIsShowing = false;
            this.updateIcon();
        }
    }

    public void dispose() {
        this.blinkerJob.cancel();
    }

    private class AlertJob
    extends UIJob {
        public AlertJob() {
            super(Messages.DirtyBlinker_0);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            DirtyBlinker.this.fAlertIsShowing = !DirtyBlinker.this.fAlertIsShowing;
            if (DirtyBlinker.this.fRemainingIterations != 0 || DirtyBlinker.this.fAlertIsShowing) {
                this.schedule(500L);
            }
            if (DirtyBlinker.this.fRemainingIterations > 0) {
                DirtyBlinker dirtyBlinker = DirtyBlinker.this;
                dirtyBlinker.fRemainingIterations = dirtyBlinker.fRemainingIterations - 1;
            }
            DirtyBlinker.this.updateIcon();
            return Status.OK_STATUS;
        }
    }
}

