/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.parts.IMnemonicGenerationAlgorithm;
import java.util.Set;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardMnemonicGenerator
implements IMnemonicGenerationAlgorithm {
    private final String possibleMnemonics = Messages.StandardMnemonicGenerator_0;
    private final String mnemonicFormat = Messages.StandardMnemonicGenerator_1;

    private static boolean hasCharacter(Set<Character> mnemonics, char toTest) {
        return mnemonics.contains(Character.valueOf(Character.toUpperCase(toTest))) || mnemonics.contains(Character.valueOf(Character.toLowerCase(toTest)));
    }

    @Override
    public String generateLabel(Set<Character> mnemonicsInUse, String preferredString) {
        char currentMnemonic = LegacyActionTools.extractMnemonic((String)preferredString);
        if (currentMnemonic != '\u0000' && !StandardMnemonicGenerator.hasCharacter(mnemonicsInUse, currentMnemonic)) {
            return preferredString;
        }
        String strippedString = LegacyActionTools.removeMnemonics((String)preferredString);
        int firstNonConflicting = -1;
        int firstAfterWhitespace = -1;
        boolean afterWhitespace = true;
        int idx = 0;
        while (idx < strippedString.length() && firstAfterWhitespace == -1) {
            char next = strippedString.charAt(idx);
            if (Character.isWhitespace(next)) {
                afterWhitespace = true;
            } else {
                if (!StandardMnemonicGenerator.hasCharacter(mnemonicsInUse, next)) {
                    if (afterWhitespace && firstAfterWhitespace == -1) {
                        firstAfterWhitespace = idx;
                    }
                    if (firstNonConflicting == -1) {
                        firstNonConflicting = idx;
                    }
                }
                afterWhitespace = false;
            }
            ++idx;
        }
        int mnemonicIdx = firstNonConflicting;
        if (firstAfterWhitespace != -1) {
            mnemonicIdx = firstAfterWhitespace;
        }
        if (mnemonicIdx != -1) {
            return String.valueOf(strippedString.substring(0, mnemonicIdx)) + "&" + strippedString.substring(mnemonicIdx, strippedString.length());
        }
        int idx2 = 0;
        while (idx2 < this.possibleMnemonics.length()) {
            char next = this.possibleMnemonics.charAt(idx2);
            if (!StandardMnemonicGenerator.hasCharacter(mnemonicsInUse, next)) {
                return NLS.bind((String)this.mnemonicFormat, (Object)strippedString, (Object)("&" + next));
            }
            ++idx2;
        }
        if (currentMnemonic == '\u0000') {
            return "&" + preferredString;
        }
        return preferredString;
    }
}

