/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StackLayoutExt
extends Layout {
    private Rectangle margins = new Rectangle(0, 0, 0, 0);
    private Control current;

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point result = new Point(0, 0);
        if (flushCache) {
            this.flushCache(composite);
        }
        if (this.current != null && !this.current.isDisposed()) {
            result = this.current.computeSize(wHint, hHint, false);
        }
        return Geometry.add((Point)result, (Point)new Point(this.margins.width, this.margins.height));
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (flushCache) {
            this.flushCache(composite);
        }
        Control[] children = composite.getChildren();
        Rectangle clientArea = composite.getClientArea();
        clientArea = Geometry.subtract((Rectangle)clientArea, (Rectangle)this.margins);
        int i = 0;
        while (i < children.length) {
            Control next = children[i];
            if (next == this.current) {
                if (!next.getVisible()) {
                    next.setVisible(true);
                }
                next.setBounds(clientArea);
            } else if (next.getVisible()) {
                next.setVisible(false);
            }
            ++i;
        }
    }

    public void setCurrent(Control control) {
        if (this.current != control) {
            if (this.current != null && !this.current.isDisposed()) {
                this.current.setVisible(false);
            }
            this.current = control;
            if (this.current != null) {
                this.current.setVisible(true);
            }
        }
    }

    private void flushCache(Composite composite) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            control.computeSize(-1, -1, true);
            ++i;
        }
    }

    public void setMargins(Rectangle newMargins) {
        this.margins = newMargins;
    }
}

