/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.repository.rcp.ui.internal.parts.InputManager;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.INameable;
import com.ibm.team.repository.rcp.ui.parts.IPartSite;
import com.ibm.team.repository.rcp.ui.parts.PartSiteDecorator;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import com.ibm.team.repository.rcp.ui.workingcopy.WorkingCopies;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.WorkbenchPart;

public abstract class PartHost
extends WorkbenchPart
implements ISaveablesSource {
    private Composite control;
    private AbstractPart part;
    private ISaveablesLifecycleListener saveablesListener;
    private InputManager manager = new InputManager();
    private ISaveablesLifecycleListener managerListener = new ISaveablesLifecycleListener(){

        public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
            PartHost.this.recomputeDirtyState();
            if (PartHost.this.saveablesListener != null && PartHost.this.part != null) {
                SaveablesLifecycleEvent saveablesLifecycleEvent = new SaveablesLifecycleEvent((Object)PartHost.this, event.getEventType(), event.getSaveables(), event.isForce());
                PartHost.this.saveablesListener.handleLifecycleEvent(saveablesLifecycleEvent);
                if (saveablesLifecycleEvent.isVeto()) {
                    event.setVeto(true);
                }
            }
        }
    };
    private boolean cachedDirtyState;

    private static String stripNewlines(String original) {
        return PartHost.replaceLineEnding(original, " ");
    }

    private static String replaceLineEnding(String original, String lineEnding) {
        return original.replace("\r\n", lineEnding).replace("\r", lineEnding).replace("\n", lineEnding);
    }

    protected PartHost() {
        this.manager.addListener(this.managerListener);
    }

    protected IMemento getSavedState() {
        return XMLMemento.createWriteRoot((String)"empty");
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        this.saveablesListener = (ISaveablesLifecycleListener)site.getService(ISaveablesLifecycleListener.class);
    }

    public IEditorSite getEditorSite() {
        return (IEditorSite)this.getSite();
    }

    public void doSave(IProgressMonitor monitor) {
        WorkingCopies.performSave(this.getSite().getShell(), this.manager.getInputs(), monitor);
    }

    protected void recomputeDirtyState() {
        boolean newDirtyState = false;
        Saveable[] saveables = this.getSaveables();
        int i = 0;
        while (i < saveables.length) {
            Saveable saveable = saveables[i];
            if (saveable.isDirty()) {
                newDirtyState = true;
            }
            ++i;
        }
        if (newDirtyState != this.cachedDirtyState) {
            this.cachedDirtyState = newDirtyState;
            this.dirtyStateChanged();
        }
    }

    protected void dirtyStateChanged() {
    }

    public boolean isDirty() {
        return this.cachedDirtyState;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public final void createPartControl(Composite parent) {
        this.control = parent;
        PartSite site = new PartSite(parent);
        this.part = this.createPart(site, parent);
    }

    protected abstract AbstractPart createPart(IPartSite var1, Composite var2);

    public void setFocus() {
        this.control.setFocus();
    }

    public Saveable[] getActiveSaveables() {
        return this.manager.getActiveSaveables();
    }

    public Saveable[] getSaveables() {
        return this.manager.getSaveables();
    }

    public void dispose() {
        this.manager.removeListener(this.managerListener);
        this.manager.dispose();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        Object result = Adapters.getAdapter((Object)this.part, (Class)adapter);
        if (result != null) {
            return result;
        }
        return super.getAdapter(adapter);
    }

    private class PartSite
    extends PartSiteDecorator
    implements INameable {
        private ImageDescriptor lastImage;

        public PartSite(Composite parent) {
            super(Parts.createSite(parent, (IWorkbenchPart)PartHost.this));
        }

        public void setName(String newName) {
            newName = PartHost.stripNewlines(newName);
            PartHost.this.setPartName(newName);
            this.getOriginal().getNameable().setName(newName);
        }

        public void setContentDescription(String contentDescription) {
            contentDescription = PartHost.stripNewlines(contentDescription);
            PartHost.this.setContentDescription(contentDescription);
            this.getOriginal().getNameable().setContentDescription(contentDescription);
        }

        public void setImage(ImageDescriptor theImage) {
            Image img = this.getResources().createImageWithDefault(theImage);
            PartHost.this.setTitleImage(img);
            if (this.lastImage != null) {
                this.getResources().destroyImage(this.lastImage);
            }
            this.lastImage = theImage;
            this.getOriginal().getNameable().setImage(theImage);
        }

        public void setTooltip(String toolTip) {
            PartHost.this.setTitleToolTip(toolTip);
            this.getOriginal().getNameable().setTooltip(toolTip);
        }

        public void addInput(IWorkingCopy newInput) {
            PartHost.this.manager.addInput(newInput);
        }

        public boolean removeInput(IWorkingCopy toRemove, boolean force) {
            return PartHost.this.manager.removeInput(toRemove, force);
        }

        public INameable getNameable() {
            return this;
        }

        public IMemento getMemento() {
            return PartHost.this.getSavedState();
        }
    }
}

