/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.parts.InputWrapper;
import com.ibm.team.repository.rcp.ui.workingcopy.IWorkingCopy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InputManager
implements ISaveablesSource {
    public static final Object PROP_DIRTY = new Object();
    private HashMap mapPartInputToSaveable = new HashMap();
    private boolean cachedDirtyState = false;
    private ISaveablesSource eventSource;
    private IChangeListener partListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property == IWorkingCopy.PROP_DIRTY) {
                Saveable saveable = (Saveable)InputManager.this.mapPartInputToSaveable.get(source);
                InputManager.this.fireEvent(new SaveablesLifecycleEvent((Object)InputManager.this.eventSource, 4, new Saveable[]{saveable}, true));
            }
        }
    };
    private List listeners = new ArrayList();

    public InputManager() {
        this.eventSource = this;
    }

    protected void fireEvent(SaveablesLifecycleEvent event) {
        for (ISaveablesLifecycleListener next : this.listeners) {
            next.handleLifecycleEvent(event);
        }
    }

    public boolean setInputs(IWorkingCopy[] newInputs, boolean force) {
        HashSet toRemove = new HashSet();
        HashSet<IWorkingCopy> toAdd = new HashSet<IWorkingCopy>();
        toRemove.addAll(this.mapPartInputToSaveable.keySet());
        int i = 0;
        while (i < newInputs.length) {
            IWorkingCopy input = newInputs[i];
            toRemove.remove(input);
            if (!this.mapPartInputToSaveable.containsKey(input)) {
                toAdd.add(input);
            }
            ++i;
        }
        boolean removeSuccess = this.removeInputs(toRemove, force);
        if (!removeSuccess) {
            return false;
        }
        this.addInputs(toAdd);
        return true;
    }

    private void addInputs(Collection toAdd) {
        Saveable[] saveables = new Saveable[toAdd.size()];
        int idx = 0;
        for (IWorkingCopy next : toAdd) {
            InputWrapper saveable = new InputWrapper(next);
            saveables[idx++] = saveable;
            next.addListener(this.partListener);
            this.mapPartInputToSaveable.put(next, saveable);
        }
        this.fireEvent(new SaveablesLifecycleEvent((Object)this.eventSource, 1, saveables, true));
    }

    public void addListener(ISaveablesLifecycleListener toAdd) {
        this.listeners.add(toAdd);
    }

    public boolean isDirty() {
        return this.cachedDirtyState;
    }

    public void removeListener(ISaveablesLifecycleListener toRemove) {
        this.listeners.remove(toRemove);
    }

    private boolean removeInputs(Collection ofIWorkingCopy, boolean force) {
        Saveable[] saveables = new Saveable[ofIWorkingCopy.size()];
        int idx = 0;
        for (IWorkingCopy next : ofIWorkingCopy) {
            saveables[idx++] = (Saveable)this.mapPartInputToSaveable.get(next);
        }
        SaveablesLifecycleEvent event = new SaveablesLifecycleEvent((Object)this.eventSource, 2, saveables, force);
        this.fireEvent(event);
        if (event.isVeto()) {
            return false;
        }
        for (IWorkingCopy next : ofIWorkingCopy) {
            next.removeListener(this.partListener);
            this.mapPartInputToSaveable.remove(next);
        }
        event = new SaveablesLifecycleEvent((Object)this.eventSource, 3, saveables, true);
        this.fireEvent(event);
        return true;
    }

    public Collection<IWorkingCopy> getInputs() {
        return this.mapPartInputToSaveable.keySet();
    }

    public Saveable[] getActiveSaveables() {
        Collection values = this.mapPartInputToSaveable.values();
        return values.toArray(new Saveable[values.size()]);
    }

    public Saveable[] getSaveables() {
        Collection values = this.mapPartInputToSaveable.values();
        return values.toArray(new Saveable[values.size()]);
    }

    public void dispose() {
        for (IWorkingCopy next : this.mapPartInputToSaveable.keySet()) {
            next.removeListener(this.partListener);
        }
    }

    public boolean removeInput(IWorkingCopy toRemove, boolean force) {
        if (this.mapPartInputToSaveable.get(toRemove) != null) {
            return this.removeInputs(Collections.singleton(toRemove), force);
        }
        return true;
    }

    public void addInput(IWorkingCopy newInput) {
        if (this.mapPartInputToSaveable.get(newInput) == null) {
            this.addInputs(Collections.singleton(newInput));
        }
    }
}

