/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.parts;

import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.ImagePool;
import com.ibm.team.repository.rcp.ui.internal.Messages;
import com.ibm.team.repository.rcp.ui.internal.menus.AbstractActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.parts.UndoStack;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class BackButton
extends AbstractActionExt {
    private IViewerLabelProvider labelProvider;
    private IChangeListener changeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (property == UndoStack.PROP_CHANGED) {
                BackButton.this.refresh();
            }
        }
    };
    private ILabelProviderListener labelChangeListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            BackButton.this.refresh();
        }
    };
    private UndoStack undoStack;
    private MenuExt menu = new MenuExt();
    private ChangeListenerList listeners = new ChangeListenerList();

    public BackButton(UndoStack undoStack, IViewerLabelProvider labelProvider) {
        super(ImagePool.BACK, Messages.BackButton_0);
        this.undoStack = undoStack;
        this.labelProvider = labelProvider;
        undoStack.addListener(this.changeListener);
        labelProvider.addListener(this.labelChangeListener);
        this.refresh();
    }

    public void addListener(IChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IChangeListener listener) {
        this.listeners.remove(listener);
    }

    public int getStyle() {
        return 4;
    }

    private void refresh() {
        this.setEnabled(this.undoStack.hasBackEntries());
        this.menu.clear();
        ArrayList backEntries = new ArrayList();
        backEntries.addAll(this.undoStack.getBackEntries());
        Collections.reverse(backEntries);
        for (final Object next : backEntries) {
            ViewerLabel label = new ViewerLabel("", null);
            this.labelProvider.updateLabel(label, next);
            PushAction nextAction = new PushAction(label.getImage() == null ? null : ImageDescriptor.createFromImage((Image)label.getImage(), (Device)Display.getCurrent()), label.getText(), new Runnable(){

                public void run() {
                    BackButton.this.listeners.notifyListeners(next, null);
                }
            });
            this.menu.add(nextAction);
        }
    }

    public void run() {
        this.listeners.notifyListeners(this.undoStack.getEntryAt(-1), null);
    }

    public IMenuExt getSubmenu() {
        return this.menu;
    }

    public void dispose() {
        this.undoStack.removeListener(this.changeListener);
        this.labelProvider.removeListener(this.labelChangeListener);
    }
}

