/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.menus;

import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.menus.AbstractActionExt;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Util;

public class RadioAction
extends AbstractActionExt {
    private Object value;
    private WritableValue model;
    private IChangeListener modelListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            RadioAction.this.updateSelection();
        }
    };
    private boolean wasSelected = false;

    public RadioAction(ImageDescriptor image, ImageDescriptor hoverImage, String text, String tooltip, Object value, WritableValue model) {
        super(image, hoverImage, text, tooltip);
        this.value = value;
        this.model = model;
    }

    public RadioAction(ImageDescriptor image, String text, Object value, WritableValue model) {
        super(image, text);
        this.value = value;
        this.model = model;
    }

    public RadioAction(String text, Object value, WritableValue model) {
        super(text);
        this.value = value;
        this.model = model;
    }

    private void updateSelection() {
        boolean isSelected = this.getSelection();
        if (this.wasSelected != isSelected) {
            this.wasSelected = isSelected;
            this.fireChangeEvent(PROP_SELECTED);
        }
    }

    protected void allocate() {
        this.wasSelected = this.getSelection();
        this.model.addListener(this.modelListener);
        super.allocate();
    }

    protected void deallocate() {
        this.model.removeListener(this.modelListener);
        super.deallocate();
    }

    public boolean getSelection() {
        return Util.equals((Object)this.value, this.model.getValue());
    }

    public void run() {
        this.model.setValue(this.value);
    }

    public int getStyle() {
        return 16;
    }

    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    public void setHoverImage(ImageDescriptor img) {
        super.setHoverImage(img);
    }

    public void setImage(ImageDescriptor img) {
        super.setImage(img);
    }

    public void setText(String text) {
        super.setText(text);
    }

    public void setTooltip(String text) {
        super.setTooltip(text);
    }

    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
    }
}

