/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.menus;

import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

final class ActionToActionExtAdapter
implements IActionExt {
    private IAction toWrap;
    private boolean isVisible = true;
    private ChangeListenerList listeners = new ChangeListenerList();
    private IPropertyChangeListener changeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("checked")) {
                this.fire(IActionExt.PROP_SELECTED);
            } else if (property.equals("image") || property.equals("text") || property.equals("toolTipText")) {
                this.fire(IActionExt.PROP_APPEARANCE);
            } else if (property.equals("enabled")) {
                this.fire(IActionExt.PROP_ENABLEMENT);
            }
        }

        public void fire(Object property) {
            ActionToActionExtAdapter.this.listeners.notifyListeners((Object)ActionToActionExtAdapter.this, property);
        }
    };

    public ActionToActionExtAdapter(IAction toConvert) {
        this.toWrap = toConvert;
        if (toConvert.getStyle() == 4 || toConvert.getStyle() == 0 || toConvert.getMenuCreator() != null) {
            throw new IllegalArgumentException("IActions with IMenuCreators cannot be converted into IActionExt");
        }
    }

    public String getId() {
        return this.toWrap.getId();
    }

    public ImageDescriptor getHoverImage() {
        return this.toWrap.getHoverImageDescriptor();
    }

    public ImageDescriptor getImage() {
        return this.toWrap.getImageDescriptor();
    }

    public ImageDescriptor getDisabledImage() {
        return this.toWrap.getDisabledImageDescriptor();
    }

    public boolean getSelection() {
        if (this.toWrap.getStyle() == 2) {
            return this.toWrap.isChecked();
        }
        return false;
    }

    public void addChangeListener(IChangeListener listener) {
        if (this.listeners.isEmpty()) {
            this.toWrap.addPropertyChangeListener(this.changeListener);
        }
        this.listeners.add(listener);
    }

    public void removeChangeListener(IChangeListener listener) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.toWrap.removePropertyChangeListener(this.changeListener);
        }
    }

    public void run() {
        this.toWrap.run();
    }

    public int getStyle() {
        switch (this.toWrap.getStyle()) {
            case 2: {
                return 32;
            }
            case 1: {
                return 8;
            }
            case 8: {
                return 16;
            }
        }
        return 0;
    }

    public IMenuExt getSubmenu() {
        return null;
    }

    public String getText() {
        return this.toWrap.getText();
    }

    public String getTooltipText() {
        String result = this.toWrap.getToolTipText();
        if (result == null) {
            return "";
        }
        return result;
    }

    public boolean isEnabled() {
        return this.toWrap.isEnabled();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        if (visible != this.isVisible) {
            this.isVisible = visible;
            this.listeners.notifyListeners((Object)this, IActionExt.PROP_VISIBILITY);
        }
    }
}

