/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.databinding;

import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IStaleListener;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabindingUtil {
    private DatabindingUtil() {
    }

    public static IStatus createNoIconMessage(int severity, String message) {
        return new Status(severity, RepositoryUiPlugin.PLUGIN_ID, -1163014131, message, null);
    }

    public static void setMessage(DialogPage page, IStatus status, boolean forceNone) {
        if (status == null) {
            page.setMessage(null);
            return;
        }
        int severity = status.getSeverity();
        if (severity <= 0) {
            page.setMessage(null);
        } else if (severity <= 1) {
            page.setMessage(status.getMessage(), forceNone ? 0 : 1);
        } else if (severity <= 2) {
            page.setMessage(status.getMessage(), forceNone ? 0 : 2);
        } else {
            page.setMessage(status.getMessage(), forceNone ? 0 : 3);
        }
    }

    public static void bindMessage(DialogPage page, IObservableValue status) {
        new PageBindingSupport(page, status);
    }

    public static void bindMessage(IControlSite site, IObservableValue validationStatus) {
        final SiteBindingSupport bindingSupport = new SiteBindingSupport(site, validationStatus);
        site.getParent().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                bindingSupport.dispose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Collection<T> syncGetResult(final ISetWithListeners<T> set, IProgressMonitor monitor) {
        if (set.getRealm().isCurrent()) {
            throw new IllegalStateException("This method cannot be called from the realm's messaging thread - doing so would cause a deadlock");
        }
        final ISetListener addRemoveListener = new ISetListener<T>(){

            @Override
            public void changed(SetDiff<T> diff) {
            }
        };
        final Collection[] result = new Collection[1];
        final IStaleListener staleListener = new IStaleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setStale(Object staleObject, boolean isStale) {
                if (!isStale) {
                    set.removeStaleListener(this);
                    3 var3_3 = this;
                    synchronized (var3_3) {
                        ArrayList resultList = new ArrayList();
                        resultList.addAll(set.toCollection());
                        result[0] = resultList;
                        this.notifyAll();
                    }
                    set.removeListener(addRemoveListener);
                }
            }
        };
        set.getRealm().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                set.addListener(addRemoveListener);
                if (set.isStale()) {
                    set.addStaleListener(staleListener);
                } else {
                    IStaleListener iStaleListener = staleListener;
                    synchronized (iStaleListener) {
                        ArrayList resultList = new ArrayList();
                        resultList.addAll(set.toCollection());
                        result[0] = resultList;
                        staleListener.notifyAll();
                    }
                    set.removeListener(addRemoveListener);
                }
            }
        });
        IStaleListener iStaleListener = staleListener;
        synchronized (iStaleListener) {
            while (true) {
                if (result[0] != null) {
                    return result[0];
                }
                try {
                    staleListener.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static final class PageBindingSupport {
        boolean initialStatus = true;
        IObservableValue status;
        DialogPage page;
        IChangeListener changeListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                PageBindingSupport.this.updateMessage();
            }
        };

        public PageBindingSupport(DialogPage page, IObservableValue _status) {
            this.status = _status;
            this.page = page;
            this.status.addChangeListener(this.changeListener);
            page.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    PageBindingSupport.this.status.removeChangeListener(PageBindingSupport.this.changeListener);
                }
            });
            this.updateMessage();
        }

        private void updateMessage() {
            IStatus statusValue = (IStatus)this.status.getValue();
            DatabindingUtil.setMessage(this.page, statusValue, this.initialStatus || statusValue.getCode() == -1163014131);
            if (this.page instanceof WizardPage) {
                WizardPage wp = (WizardPage)this.page;
                wp.setPageComplete(statusValue.getSeverity() < 4);
            } else if (this.page instanceof PreferencePage) {
                PreferencePage pp = (PreferencePage)this.page;
                pp.setValid(statusValue.getSeverity() < 4);
            }
            this.initialStatus = false;
        }
    }

    private static final class SiteBindingSupport {
        boolean initialStatus = true;
        IObservableValue status;
        IChangeListener changeListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                SiteBindingSupport.this.updateMessage();
            }
        };
        private IControlSite site;

        public SiteBindingSupport(IControlSite site, IObservableValue _status) {
            this.site = site;
            this.status = _status;
            this.status.addChangeListener(this.changeListener);
            this.updateMessage();
        }

        public void updateMessage() {
            this.site.setStatus((IStatus)this.status.getValue());
        }

        public void dispose() {
            this.status.removeChangeListener(this.changeListener);
        }
    }
}

