/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.ui.internal.databinding;

import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.databinding.observable.Realm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousResultCollector<T> {
    private List<T> synchronousResult = new ArrayList<T>();
    private Map<Realm, List<Callable<Collection<T>>>> stuffToRun = new HashMap<Realm, List<Callable<Collection<T>>>>();

    public void addAsync(Realm realm, Callable<Collection<T>> toInvoke) {
        AsynchronousResultCollector.addToMapOfLists(this.stuffToRun, realm, toInvoke);
    }

    public void addSync(Collection<T> toAdd) {
        this.synchronousResult.addAll(toAdd);
    }

    public void collectResults(final Realm realmToSendResultIn, final IPartResult<Collection<T>> callback) {
        if (this.stuffToRun.isEmpty()) {
            realmToSendResultIn.asyncExec(new Runnable(){

                public void run() {
                    callback.setResult(AsynchronousResultCollector.this.synchronousResult);
                }
            });
            return;
        }
        final int[] remainToRun = new int[1];
        final Collection[] result = new List[]{new ArrayList()};
        remainToRun[0] = this.stuffToRun.size();
        for (Realm next : this.stuffToRun.keySet()) {
            final List<Callable<Collection<T>>> toInvoke = this.stuffToRun.get(next);
            next.asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList resultFromThisRealm = new ArrayList();
                    try {
                        for (Callable next : toInvoke) {
                            resultFromThisRealm.addAll((Collection)next.call());
                        }
                    }
                    catch (Exception e) {
                        StatusUtil.log((Object)this, (Throwable)e);
                    }
                    int[] nArray = remainToRun;
                    synchronized (remainToRun) {
                        remainToRun[0] = remainToRun[0] - 1;
                        result[0].addAll(resultFromThisRealm);
                        if (remainToRun[0] == 0) {
                            realmToSendResultIn.asyncExec(new Runnable(){

                                public void run() {
                                    result[0].addAll(AsynchronousResultCollector.this.synchronousResult);
                                    callback.setResult(result[0]);
                                }
                            });
                        }
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
    }

    private static <K, V> void addToMapOfLists(Map<K, List<V>> map, K key, V value) {
        List<V> currentList = map.get(key);
        if (currentList == null) {
            currentList = new ArrayList<V>();
            map.put(key, currentList);
        }
        currentList.add(value);
    }
}

