/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.setup.client;

import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;

public class ProcessDescription {
    public static final String DEFAULT_ENCODING = "UTF8";
    private Document fProcessSpecification;
    private Document fProcessState;

    public ProcessDescription(String processSpec, String processState) throws TeamRepositoryException {
        this.fProcessSpecification = this.createDOMFromString(processSpec);
        this.fProcessState = this.createDOMFromString(processState);
    }

    public Document getProcessSpecification() {
        return this.fProcessSpecification;
    }

    public Document getProcessState() {
        return this.fProcessState;
    }

    public IContent getSpecificationContent(ISetupContext projectSetupContext, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createXMLContentFromDOM(projectSetupContext, this.fProcessSpecification, monitor);
    }

    public IContent getSpecificationState(ISetupContext projectSetupContext, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createXMLContentFromDOM(projectSetupContext, this.fProcessState, monitor);
    }

    private Document createDOMFromString(String xmlText) throws TeamRepositoryException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return documentBuilder.parse(new ByteArrayInputStream(xmlText.getBytes(DEFAULT_ENCODING)));
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private IContent createXMLContentFromDOM(ISetupContext projectSetupContext, Document dom, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            IContentManager contentManager = projectSetupContext.getTeamRepository().contentManager();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(dom), new StreamResult(buffer));
            byte[] byteArray = buffer.toByteArray();
            return contentManager.storeContent("text/xml", DEFAULT_ENCODING, (InputStream)new ByteArrayInputStream(byteArray), (long)byteArray.length, null, monitor);
        }
        catch (TransformerException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }
}

