/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.VersionHistoryImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoRootVersion;
import com.ibm.team.connector.scm.client.JzRepoStream;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoVersionHistory
extends JzRepoResource {
    @Override
    public Class<?> get_proxyClass() {
        return VersionHistoryImpl.class;
    }

    public JzRepoVersionHistory(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    public JzRepoControllableResource createControllableResource(JzRepoWorkspace jzWS) throws WvcmException {
        List heritage;
        IVersionableHandle me;
        IConfiguration config;
        JzProvider provider;
        block4: {
            provider = this.getProvider();
            JzRepoComponent comp = this.getJzRepoComponent();
            config = jzWS.lookupConfiguration(comp.getLocation());
            if (config == null) {
                return null;
            }
            try {
                me = (IVersionableHandle)this.getItemHandle();
                IAncestorReport ancestorReport = (IAncestorReport)config.locateAncestors(Collections.singletonList(me), provider.getMonitor()).get(0);
                heritage = ancestorReport.getNameItemPairs();
                if (heritage.size() != 0) break block4;
                return null;
            }
            catch (TeamRepositoryException e) {
                throw new JzRepoException("createControllableResource", (JzRepoResource)this, (Exception)((Object)e));
            }
        }
        JzLocation bcfLoc = jzWS.computeBcfLoc(config.component());
        JzLocation crLoc = JzRepoVersionHistory.createCompoundLocation(bcfLoc, heritage);
        JzRepoControllableResource result = JzRepoControllableResource.createFromVersionable(provider, crLoc, me);
        return result;
    }

    public static JzLocation createCompoundLocation(JzLocation parent, List<INameItemPair> heritage) throws WvcmException {
        JzLocation result = parent;
        for (INameItemPair nameItemPair : heritage) {
            String bindingName = nameItemPair.getName();
            if (bindingName == null) continue;
            result = result.child(bindingName);
        }
        return result;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getVersionHistoryResourceIdentifier();
        }
        if (propertyName.equals((Object)VersionHistory.ROOT_VERSION)) {
            return this.getRootVersion();
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public String getVersionHistoryResourceIdentifier() throws WvcmException {
        JzLocation verLoc = JzRepoVersionHistory.getVersionHistoryLocation(this.getJzRepoComponent().getLocation(), (IVersionableHandle)this.getItemHandle());
        return verLoc.string();
    }

    public JzRepoVersion getRootVersion() throws WvcmException {
        JzLocation verLoc = this.getLocation().createRootVersionLocation();
        JzRepoRootVersion result = new JzRepoRootVersion(this.getProvider(), verLoc);
        return result;
    }

    private JzLocation createVersionLocation(String rootVersLocDN) throws WvcmException {
        JzLocation componentLocation = this.getJzRepoComponent().getLocation();
        JzLocation verLoc = componentLocation.createVersionLocation(rootVersLocDN);
        return verLoc;
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropStream.PN_CLONE)) {
            HashMap<JzRepoResource, String> sources2Values = new HashMap<JzRepoResource, String>(1);
            sources2Values.put(this, (String)value);
            JzRepoResource.storeInteropCloneValues(this.getProvider(), sources2Values, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    @Override
    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)InteropStream.PN_CLONE)) {
            this.removeInteropCloneValue(feedback);
        } else {
            super.removePropertyFromClient(propertyName, feedback);
        }
    }

    public void recordComponent(SrvcFeedback feedback) throws WvcmException {
        IComponentHandle compH = this.getJzRepoComponent().getComponentItemHandle();
        JzProvider provider = this.getProvider();
        if (provider.isDebugLogEnabled()) {
            provider.logDebug(String.format("diag: recording component for VH %s, component %s", JzRepoVersionHistory.getCurrentStateDisplayName(this.getItemHandle()), JzRepoVersionHistory.getCurrentStateDisplayName((IItemHandle)compH)));
        }
        JzRepoVersionHistory.storeCustomProperty(provider, this.getLocation(), this.getItemHandle(), JzRepoVersionHistory.getVHInitialComponentPropertyName(), JzRepoVersionHistory.getCurrentStateLocationUriString((IItemHandle)compH), false, feedback);
    }

    private static JzRepoComponent lookupJzRepoComponent(JzProvider provider, JzLocation myLoc, IVersionableHandle vH) throws WvcmException {
        JzLocation compLoc = myLoc.lookupContextLocation(JzLocation.Kind.Component);
        if (compLoc != null) {
            return JzRepoComponent.lookup(provider, compLoc);
        }
        return JzRepoVersionHistory.lookupJzRepoComponent(provider, vH);
    }

    public static JzRepoComponent lookupJzRepoComponent(JzProvider provider, IVersionableHandle vH) throws WvcmException {
        IComponentHandle cH = null;
        SrvcFeedback feedback = null;
        String componentCurrentStateDisplayName = (String)JzRepoVersionHistory.getCustomProperty(provider, (IItemHandle)vH, JzRepoVersionHistory.getVHInitialComponentPropertyName(), feedback);
        if (componentCurrentStateDisplayName == null) {
            JzLocation compLoc;
            JzRepoComponent comp;
            String defaultComponentRI = provider.getDefaultComponentRI();
            if (defaultComponentRI != null && (comp = JzRepoComponent.lookup(provider, compLoc = new JzLocation(defaultComponentRI))) != null) {
                cH = comp.getComponentItemHandle();
            }
        } else {
            JzLocation compLoc = new JzLocation(componentCurrentStateDisplayName);
            cH = (IComponentHandle)JzRepoVersionHistory.lookupItemHandle(provider, compLoc);
        }
        return cH == null ? null : JzRepoComponent.create(cH, provider);
    }

    public JzRepoComponent getJzRepoComponent() throws WvcmException {
        return this.getJzRepoComponent(this.getProvider(), this.getLocation(), (IVersionableHandle)this.getItemHandle());
    }

    private JzRepoComponent getJzRepoComponent(JzProvider provider, JzLocation location, IVersionableHandle vH) throws WvcmException {
        JzRepoComponent result = JzRepoVersionHistory.lookupJzRepoComponent(provider, location, vH);
        if (result == null) {
            throw new WvcmException("could not look up default component.", WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    private static JzRepoComponent getJzRepoComponent(JzProvider provider, IVersionableHandle vH) throws WvcmException {
        JzRepoComponent result = JzRepoVersionHistory.lookupJzRepoComponent(provider, vH);
        if (result == null) {
            throw new WvcmException("could not look up default component.", WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    public static JzRepoVersionHistory create(JzProvider provider, IVersionableHandle versionableHandle, SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent comp = JzRepoVersionHistory.getJzRepoComponent(provider, versionableHandle);
        JzLocation compLoc = comp.getLocation();
        JzLocation resultLoc = compLoc.createVersionHistoryLocation(JzRepoVersionHistory.getCurrentStateDisplayName((IItemHandle)versionableHandle));
        JzRepoVersionHistory result = (JzRepoVersionHistory)provider.lookup(resultLoc, feedback);
        return result;
    }

    public static JzLocation getPathnameLocation(JzProvider provider, JzLocation location) {
        return null;
    }

    public JzRepoResource getLastVersionInStream(JzRepoStream stream) throws WvcmException {
        SrvcFeedback feedback = null;
        String versLocDN = this.getStringCustomProperty(JzRepoVersionHistory.getVHStreamVersionPropertyName(), feedback);
        JzLocation verLoc = this.createVersionLocation(versLocDN);
        JzRepoResource result = this.getProvider().resolveVersion(verLoc);
        return result;
    }

    public static JzRepoVersionHistory create(JzProvider provider, JzLocation compLoc, IVersionableHandle h) throws WvcmException {
        JzLocation resultLoc = compLoc.createVersionHistoryLocation(JzRepoVersionHistory.getCurrentStateDisplayName((IItemHandle)h));
        JzRepoVersionHistory result = new JzRepoVersionHistory(provider, resultLoc);
        result.setItemHandle((IItemHandle)h);
        return result;
    }

    public JzRepoVersion getVersion(IConfiguration config) throws WvcmException {
        JzRepoVersion result = this.lookupVersion(config);
        if (result == null) {
            throw new WvcmException("Version not found", WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public JzRepoVersion lookupVersion(IConfiguration config) throws WvcmException {
        JzRepoVersion result = null;
        JzProvider provider = this.getProvider();
        IVersionableHandle vH = (IVersionableHandle)this.getItemHandle();
        JzRepoComponent comp = JzRepoVersionHistory.lookupJzRepoComponent(provider, this.getLocation(), vH);
        IVersionable itemState = this.lookupItemState(vH, config);
        if (comp != null && itemState != null) {
            JzLocation compLoc = comp.getLocation();
            result = JzRepoVersion.createAppropriateProxy(provider, compLoc.createVersionLocation(JzRepoVersionHistory.getItemStateDisplayName((IVersionableHandle)itemState)), (IItemHandle)itemState);
        }
        return result;
    }

    public static JzRepoVersionHistory lookup(JzProvider provider, JzLocation loc) {
        JzRepoVersionHistory result = null;
        try {
            IVersionableHandle vh = (IVersionableHandle)JzRepoVersionHistory.getItemHandle(provider, loc);
            JzRepoComponent comp = JzRepoVersionHistory.lookupJzRepoComponent(provider, loc, vh);
            if (comp != null) {
                result = JzRepoVersionHistory.create(provider, comp.getLocation(), vh);
            }
        }
        catch (WvcmException e) {
            provider.logIgnoredException("JzRepoVersionHistory.lookup", (Exception)((Object)e));
        }
        return result;
    }

    public static List<JzRepoControllableResource> computeControllableResources(JzProvider provider, List<ControllableResource> queries, SrvcFeedback feedback) throws WvcmException {
        String lastWsLocString = null;
        JzRepoWorkspace jzWS = null;
        ArrayList<JzRepoVersionHistory> us = new ArrayList<JzRepoVersionHistory>(queries.size());
        for (ControllableResource query : queries) {
            VersionHistory vh = query.getVersionHistory();
            Location vhLoc = vh.getPathnameLocation();
            JzRepoVersionHistory jzRepoVersionHistory = (JzRepoVersionHistory)provider.lookup(vhLoc, feedback);
            us.add(jzRepoVersionHistory);
            Workspace ws = query.getWorkspace();
            Location wsLoc = ws.getPathnameLocation();
            String wsLocString = wsLoc.string();
            if (lastWsLocString == null) {
                lastWsLocString = wsLocString;
                jzWS = (JzRepoWorkspace)provider.lookup(wsLoc, feedback);
                continue;
            }
            if (lastWsLocString.equals(wsLocString)) continue;
            throw new IllegalArgumentException(String.format("only one workspace location string is allowed for all queries, but we've seen %s and %s", lastWsLocString, wsLocString));
        }
        HashMap components2VHList = new HashMap(queries.size());
        for (JzRepoVersionHistory vH : us) {
            JzRepoComponent key = vH.getJzRepoComponent();
            if (!components2VHList.containsKey((Object)key)) {
                components2VHList.put(key, new ArrayList());
            }
            IVersionableHandle versionableHandle = (IVersionableHandle)vH.getItemHandle();
            ((List)components2VHList.get((Object)key)).add(versionableHandle);
        }
        ArrayList<JzRepoControllableResource> results = new ArrayList<JzRepoControllableResource>(queries.size());
        for (JzRepoComponent jzRepoComponent : components2VHList.keySet()) {
            IConfiguration config = jzWS.lookupConfiguration(jzRepoComponent.getLocation());
            if (config == null) continue;
            List versionableHandles = (List)components2VHList.get((Object)jzRepoComponent);
            Iterator versionableHandlesIterator = versionableHandles.listIterator();
            try {
                List ancestorReports = config.locateAncestors(versionableHandles, provider.getMonitor());
                JzLocation bcfLoc = jzWS.computeBcfLoc(config.component());
                for (IAncestorReport ancestorReport : ancestorReports) {
                    List heritage = ancestorReport.getNameItemPairs();
                    if (heritage.size() > 0) {
                        JzRepoControllableResource result = JzRepoControllableResource.createFromVersionable(provider, JzRepoVersionHistory.createCompoundLocation(bcfLoc, heritage), (IVersionableHandle)versionableHandlesIterator.next());
                        results.add(result);
                        continue;
                    }
                    results.add(null);
                }
            }
            catch (TeamRepositoryException e) {
                throw new WvcmException("createControllableResource", null, JzRepoException.exceptionToReasonCode((Exception)((Object)e)), (Throwable)e);
            }
        }
        return results;
    }
}

