/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoFileItem;
import com.ibm.team.connector.scm.client.JzRepoFolderItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLinkVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JzRepoVersion
extends JzRepoResource {
    public JzRepoVersion(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getLocation().string();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            JzRepoVersionHistory vh = JzRepoVersionHistory.create(this.getProvider(), this.getLocation().getComponentLocation(), (IVersionableHandle)this.getItemHandle());
            return vh;
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return new JzLocation(this.getBindingName());
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    protected JzRepoVersionHistory getParentVersionHistory() throws WvcmException {
        IFolderHandle parentHandle = this.fetchCompleteState().getParent();
        JzLocation compLoc = this.getLocation().getComponentLocation();
        JzLocation resultLoc = compLoc.createVersionHistoryLocation(JzRepoVersion.getCurrentStateDisplayName((IItemHandle)parentHandle));
        JzRepoVersionHistory result = new JzRepoVersionHistory(this.getProvider(), resultLoc);
        result.setItemHandle((IItemHandle)parentHandle);
        return result;
    }

    public IVersionable fetchCompleteState() throws WvcmException {
        IVersionableHandle versionableHandle = (IVersionableHandle)this.getItemHandle();
        return JzRepoVersion.fetchCompleteState(versionableHandle, this.getProvider());
    }

    protected static IVersionable fetchCompleteState(IVersionableHandle versionableHandle, JzProvider provider) throws WvcmException {
        ITeamRepository repo = provider.getRepo();
        try {
            IVersionable result = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState(versionableHandle, provider.getMonitor());
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException("could not fetchCompleteState", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    protected String getBindingName() throws WvcmException {
        IVersionable me = this.fetchCompleteState();
        String result = me.getName();
        return result;
    }

    public static boolean isSymbolicLink(IVersionableHandle versionableHandle, JzProvider provider) {
        try {
            IContent contentHandle = ((IFileItem)JzRepoVersion.fetchCompleteState(versionableHandle, provider)).getContent();
            return contentHandle.getContentType().equals("text/symblink");
        }
        catch (WvcmException e) {
            throw new RuntimeException("Could not get content of versionable", e);
        }
    }

    public static JzRepoVersion createAppropriateProxy(JzProvider provider, JzLocation resultLoc, IItemHandle myItemHandle) throws WvcmException {
        JzRepoVersion result = null;
        result = myItemHandle.getItemType().equals(IFileItem.ITEM_TYPE) ? (JzRepoVersion.isSymbolicLink((IVersionableHandle)myItemHandle, provider) ? new JzRepoSymbolicLinkVersion(provider, resultLoc) : new JzRepoFileItem(provider, resultLoc)) : new JzRepoFolderItem(provider, resultLoc);
        result.setItemHandle(myItemHandle);
        return result;
    }

    public IFolderHandle getParentFolderHandle() throws WvcmException {
        return this.fetchCompleteState().getParent();
    }

    public JzRepoComponent getJzRepoComponent() throws WvcmException {
        JzRepoComponent result = JzRepoComponent.lookup(this.getProvider(), this.getLocation().getComponentLocation());
        return result;
    }

    public IVersionable getWorkingCopy() throws WvcmException {
        return (IVersionable)this.fetchCompleteState().getWorkingCopy();
    }
}

