/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.ControllableSymbolicLinkImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IVersionable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoSymbolicLink
extends JzRepoControllableFolder {
    private static final String SLASH = String.valueOf('/');
    public static final String SymbolicLinkPrefix = "<Symbolic Link>";
    public static final String CONTENT_TYPE_SYMLINK = "text/symblink";

    public JzRepoSymbolicLink(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableSymbolicLinkImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)ControllableSymbolicLink.LINK_TARGET)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.doReadContent(out, feedback);
            return JzRepoSymbolicLink.readSymbolicLinkTarget((WorkspaceProvider)this.getProvider(), this.getLocation(), out, feedback);
        }
        if (propertyName.equals((Object)ControllableSymbolicLink.CHILD_MAP)) {
            HashMap result = new HashMap();
            return result;
        }
        if (propertyName.equals((Object)ControllableSymbolicLink.CHILD_LIST)) {
            ArrayList result = new ArrayList();
            return result;
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public static Location readSymbolicLinkTarget(WorkspaceProvider provider, JzLocation loc, OutputStream out, SrvcFeedback feedback) throws WvcmException {
        String content = out.toString();
        String path = null;
        if (!content.startsWith(SymbolicLinkPrefix)) {
            int end = content.length();
            if (end > 100) {
                content = String.valueOf(content.substring(0, 100)) + "...";
            }
            feedback.notifyWarning(NLS.bind((String)"Bad symlink at location: {0}, content: {1}", (Object[])new Object[]{loc.string(), content}));
            path = "bad_symlink_target_value";
        } else {
            path = content.substring(SymbolicLinkPrefix.length());
        }
        return JzRepoSymbolicLink.relativePathToLocation(path, provider);
    }

    public static String relativeLocationToString(Location loc) throws WvcmException {
        Location parent = loc.parent();
        if (parent == null) {
            return loc.lastSegment();
        }
        return String.valueOf(JzRepoSymbolicLink.relativeLocationToString(loc.parent())) + SLASH + loc.lastSegment();
    }

    public static Location relativePathToLocation(String path, WorkspaceProvider provider) throws WvcmException {
        String[] segments;
        Location loc = provider.relativeRootLocation();
        String[] stringArray = segments = path.split(SLASH, -1);
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            loc = loc.child(segment);
            ++n2;
        }
        return loc;
    }

    public static JzRepoResource doCreateSymbolicLink(JzProvider provider, JzLocation location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        PropValue propVal = updates.get(ControllableSymbolicLink.LINK_TARGET);
        if (propVal == null) {
            throw new WvcmException("LINK_TARGET must be set when creating a symbolic link", WvcmException.ReasonCode.FORBIDDEN);
        }
        String target = JzRepoSymbolicLink.relativeLocationToString((Location)propVal.get_value());
        IFileItem addMe = (IFileItem)IFileItem.ITEM_TYPE.createItem();
        String contentString = SymbolicLinkPrefix + target;
        byte[] contentByteArray = contentString.getBytes();
        try {
            IContent content = provider.getRepo().contentManager().storeContent(CONTENT_TYPE_SYMLINK, "us-ascii", LineDelimiter.LINE_DELIMITER_NONE, (InputStream)new ByteArrayInputStream(contentByteArray), null, provider.getMonitor());
            addMe.setContent(content);
            addMe.setFileTimestamp(new Date(System.currentTimeMillis()));
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("doCreateSymbolicLink", location, (Exception)((Object)e));
        }
        JzLocation actualAddedItemLocation = JzRepoControllableResource.doAddItemToParent(provider, location, (IVersionable)addMe, updates, updated, feedback);
        JzRepoSymbolicLink result = new JzRepoSymbolicLink(provider, actualAddedItemLocation);
        updated.add(ControllableSymbolicLink.LINK_TARGET);
        return result;
    }
}

