/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoFileItem
extends JzRepoVersion {
    private static final String IO_ERROR_WHILE_DOWNLOADING_WITH_NAME = Messages.JzRepoFileItem_ERROR_WHILE_DOWNLOADING_WITH_NAME;
    static final List<PropertyNameList.PropertyName<?>> CONTENT_PROPERTIES = new ArrayList((Collection)Arrays.asList(Resource.CONTENT_TYPE, Resource.CONTENT_CHARACTER_SET, Resource.CONTENT_LENGTH, InteropStream.PN_LINE_SEPARATOR));
    static final Map<LineDelimiter, InteropStream.LineSeparator> delimsToSeps = new HashMap<LineDelimiter, InteropStream.LineSeparator>();

    static {
        delimsToSeps.put(LineDelimiter.LINE_DELIMITER_CR, InteropStream.LineSeparator.CR);
        delimsToSeps.put(LineDelimiter.LINE_DELIMITER_CRLF, InteropStream.LineSeparator.CRLF);
        delimsToSeps.put(LineDelimiter.LINE_DELIMITER_LF, InteropStream.LineSeparator.LF);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (CONTENT_PROPERTIES.contains(propertyName)) {
            IContent content = this.getContent();
            if (propertyName.equals((Object)Resource.CONTENT_TYPE)) {
                return content.getContentType();
            }
            if (propertyName.equals((Object)Resource.CONTENT_CHARACTER_SET)) {
                return content.getCharacterEncoding();
            }
            if (propertyName.equals((Object)InteropStream.PN_LINE_SEPARATOR)) {
                LineDelimiter ld = content.getLineDelimiter();
                if (delimsToSeps.containsKey(ld)) {
                    return delimsToSeps.get(ld).name();
                }
                return InteropStream.LineSeparator.UNSPECIFIED.name();
            }
            if (propertyName.equals((Object)Resource.CONTENT_LENGTH)) {
                return content.getRawLength();
            }
        } else if (propertyName.equals((Object)Resource.IS_EXECUTABLE)) {
            return new Boolean(((IFileItem)this.fetchCompleteState()).isExecutable());
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private IContent getContent() throws WvcmException {
        this.getProvider().applyDeferredContentCommits();
        return ((IFileItem)this.fetchCompleteState()).getContent();
    }

    public JzRepoFileItem(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionImpl.class;
    }

    public void doReadContent(OutputStream result, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.getProvider();
        try {
            IContent storedContent = this.getContent();
            if (storedContent != null) {
                this.writeContentToOutputStream(provider.getRepo().contentManager(), storedContent, provider.getLineDelimiter(), result, provider.getMonitor());
            }
        }
        catch (TeamRepositoryException e) {
            throw this.wrapException(NLS.bind((String)Messages.JzRepoFileItem_ERROR_READ_CONTENT_FAILED_WITH_LOCSTRING, (Object[])new Object[]{this.getBindingName()}), (Exception)((Object)e));
        }
    }

    protected boolean hasSameContent(SrvcResource otherVersion) throws WvcmException {
        JzRepoFileItem otherFileItem = (JzRepoFileItem)otherVersion;
        UUID myContentId = this.getContent().getContentId();
        UUID otherContentId = ((IFileItem)otherFileItem.fetchCompleteState()).getContent().getContentId();
        return myContentId.equals((Object)otherContentId);
    }

    private void writeContentToOutputStream(IContentManager contentManager, IContent storedContent, LineDelimiter requestedDelimiter, OutputStream output, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean useStoredDelimiter;
        LineDelimiter storedDelimiter;
        if (requestedDelimiter.equals((Object)LineDelimiter.LINE_DELIMITER_PLATFORM)) {
            requestedDelimiter = LineDelimiter.getPlatformDelimiter();
        }
        if ((storedDelimiter = storedContent.getLineDelimiter()).equals((Object)LineDelimiter.LINE_DELIMITER_PLATFORM)) {
            storedDelimiter = LineDelimiter.getPlatformDelimiter();
        }
        boolean bl = useStoredDelimiter = storedDelimiter.equals((Object)requestedDelimiter) || LineDelimiter.LINE_DELIMITER_NONE.equals((Object)storedDelimiter);
        if (useStoredDelimiter) {
            contentManager.retrieveContent(storedContent, output, monitor);
        } else {
            try {
                InputStream input = contentManager.retrieveContentStream(storedContent, storedContent.getCharacterEncoding(), requestedDelimiter, monitor);
                ContentManager.read((InputStream)input, (OutputStream)output);
            }
            catch (IOException e) {
                throw new TeamRepositoryException(NLS.bind((String)IO_ERROR_WHILE_DOWNLOADING_WITH_NAME, (Object[])new Object[]{storedContent}), (Throwable)e);
            }
        }
    }
}

