/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.ControllableResourceImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaselineControlledFolder;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoConfiguration;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.client.JzRepoFileItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.LineDelimiterUtil;
import com.ibm.team.repository.common.utils.LineDelimiterVerifier;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoControllableResource
extends JzRepoResource {
    private static final String TEXT = "text";
    public static final List<PropertyNameList.PropertyName<?>> LATEST_VERSION_PROPERTIES = new ArrayList((Collection)Arrays.asList(Resource.CONTENT_TYPE, Resource.CONTENT_CHARACTER_SET, Resource.CONTENT_LENGTH, Resource.IS_EXECUTABLE, InteropStream.PN_LINE_SEPARATOR));
    private static final byte[] emptyContentByteArray = new byte[0];

    public JzRepoControllableResource(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getResourceIdentifier(feedback);
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            return this.getVersionHistory(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.CHECKED_IN)) {
            return this.latestVersion(false, feedback);
        }
        if (propertyName.equals((Object)ControllableResource.WORKSPACE)) {
            return this.getWvcmWorkspace();
        }
        if (propertyName.equals((Object)ControllableResource.CONFIGURATION)) {
            return this.getWvcmConfiguration();
        }
        if (propertyName.equals((Object)ControllableResource.IS_VERSION_CONTROLLED)) {
            return true;
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return this.getPathnameLocation(feedback);
        }
        if (LATEST_VERSION_PROPERTIES.contains(propertyName)) {
            return this.latestVersion(true, feedback).getThisProperty(propertyName, configuration, feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    protected String getResourceIdentifier(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getWvcmWorkspace();
        JzRepoComponent comp = ws.getJzRepoComponent(this.getLocation().getComponentLocation(), null);
        JzLocation riLoc = JzLocation.createCrLoc(JzRepoControllableResource.getCurrentStateDisplayName(this.getItemHandle()), ws.getLocation(), comp.getLocation());
        return riLoc.string();
    }

    private JzLocation getVersionHistoryLocation(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getWvcmWorkspace();
        JzLocation compLoc = ws.getUriComponentLocation(this.getLocation().getComponentLocation(), feedback);
        JzLocation result = compLoc.createVersionHistoryLocation(JzRepoControllableResource.getCurrentStateDisplayName(this.getItemHandle()));
        return result;
    }

    public static JzLocation doAddItemToParent(JzProvider provider, JzLocation location, IVersionable addMe, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzRepoControllableFolder parent = JzRepoControllableResource.getParent(provider, location, feedback);
        JzLocation result = parent.doAddItem(location.lastSegment(), addMe, updates, updated, feedback);
        return result;
    }

    private static JzRepoControllableFolder getParent(JzProvider provider, JzLocation location, SrvcFeedback feedback) throws JzRepoException {
        SrvcResource possibleParent = provider.lookup(location.parent(), feedback);
        if (!(possibleParent instanceof JzRepoControllableFolder)) {
            throw new JzRepoException("doAddItemToParent", location, Messages.JzRepoControllableResource_ERROR_PARENT_LOCATION_NOT_CF);
        }
        JzRepoControllableFolder parent = (JzRepoControllableFolder)possibleParent;
        return parent;
    }

    public static JzRepoControllableResource doCreateControllableResource(JzProvider provider, JzLocation pnLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IFileItem addMe = (IFileItem)IFileItem.ITEM_TYPE.createItem();
        addMe.setContent(JzRepoControllableResource.createEmptyContent(provider));
        addMe.setFileTimestamp(new Date(System.currentTimeMillis()));
        JzRepoControllableResource.doAddItemToParent(provider, pnLoc, (IVersionable)addMe, updates, updated, feedback);
        JzRepoControllableResource result = new JzRepoControllableResource(provider, pnLoc);
        return result;
    }

    @Override
    public IItemHandle computeItemHandle() throws WvcmException {
        return JzRepoControllableResource.getItemHandleForControllableResource(this.getProvider(), this.getLocation());
    }

    public static IItemHandle getItemHandleForControllableResource(JzProvider provider, JzLocation myLoc) throws WvcmException {
        if (myLoc.hasComponentLocation() && !myLoc.kind().equals((Object)JzLocation.Kind.BaselineControlledFolder)) {
            JzRepoBaselineControlledFolder bcf = JzRepoControllableResource.getBCF(provider, myLoc);
            return bcf.getVersionableHandle(myLoc.getPath());
        }
        return JzRepoControllableResource.getItemHandle(provider, myLoc);
    }

    private static JzRepoBaselineControlledFolder getBCF(JzProvider provider, JzLocation myLoc) throws WvcmException {
        JzRepoBaselineControlledFolder result = (JzRepoBaselineControlledFolder)provider.lookup(myLoc.getBcfLocation(), null);
        if (result == null) {
            String msg = NLS.bind((String)Messages.JzRepoControllableResource_MSG_BCF_NOT_FOUND, (Object[])new Object[]{myLoc});
            throw new WvcmException(msg, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public static JzRepoControllableResource lookup(JzProvider provider, JzLocation loc, SrvcFeedback feedback) {
        JzRepoControllableResource result = null;
        JzLocation.Kind kind = loc.kind();
        switch (kind) {
            case BaselineControlledFolder: {
                result = new JzRepoBaselineControlledFolder(provider, loc);
                break;
            }
            case ControllableResource: {
                result = JzRepoControllableResource.lookupCR(provider, loc, feedback);
                break;
            }
            case FileSysPath: {
                result = JzRepoControllableResource.lookupFSP(provider, loc, feedback);
                break;
            }
            default: {
                try {
                    IVersionableHandle vH = (IVersionableHandle)JzRepoControllableResource.lookupItemHandle(provider, loc);
                    if (vH == null) break;
                    result = JzRepoControllableResource.createFromVersionable(provider, loc, vH);
                    break;
                }
                catch (Exception e) {
                    provider.logIgnoredException("lookup", e);
                }
            }
        }
        return result;
    }

    private static JzRepoControllableResource lookupCR(JzProvider provider, JzLocation loc, SrvcFeedback feedback) {
        IVersionableHandle vH;
        JzRepoWorkspace ws;
        JzRepoControllableResource result = null;
        JzLocation wsLoc = loc.lookupContextLocation(JzLocation.Kind.Workspace);
        JzLocation compLoc = loc.lookupContextLocation(JzLocation.Kind.Component);
        URI versionHistoryUri = loc.lookupURI();
        JzRepoWorkspace jzRepoWorkspace = ws = wsLoc == null ? null : JzRepoWorkspace.lookup(provider, wsLoc);
        if (ws != null && compLoc != null && versionHistoryUri != null && (vH = ws.lookupVersionableHandle(compLoc, versionHistoryUri, feedback)) != null) {
            result = new JzRepoControllableResource(provider, loc);
            result.setItemHandle((IItemHandle)vH);
        }
        return result;
    }

    private static JzRepoControllableResource lookupFSP(JzProvider provider, JzLocation loc, SrvcFeedback feedback) {
        JzRepoControllableResource result = null;
        JzRepoConfiguration config = JzRepoConfiguration.lookup(provider, loc);
        if (config != null) {
            try {
                provider.applyDeferredContentCommits(config, loc);
            }
            catch (WvcmException e) {
                provider.logIgnoredException("lookupFSP", (Exception)((Object)e));
            }
        }
        try {
            IVersionableHandle itemHandle = (IVersionableHandle)JzRepoControllableResource.getItemHandleForControllableResource(provider, loc);
            if (itemHandle != null) {
                result = JzRepoControllableResource.createFromVersionable(provider, loc, itemHandle);
            }
        }
        catch (WvcmException e) {
            provider.logIgnoredException("lookupFSP", (Exception)((Object)e));
        }
        return result;
    }

    public void doCheckout(ControllableResource.CheckoutFlag[] flags, SrvcFeedback feedback) throws WvcmException {
    }

    public void doCheckin(ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits();
    }

    public void doReadContent(OutputStream content, SrvcFeedback feedback) throws WvcmException {
        JzRepoFileItem fileItem = (JzRepoFileItem)this.latestVersion(true, null);
        fileItem.doReadContent(content, feedback);
    }

    public void doVersionControl(SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits();
    }

    protected void applyDeferredContentCommits() throws WvcmException {
        this.getProvider().applyDeferredContentCommits(this.getWvcmConfiguration());
    }

    private void doWriteIsExecutable(boolean newIsExecutable) throws WvcmException {
        JzRepoFileItem fileItem = (JzRepoFileItem)this.latestVersion(true, null);
        IWorkspaceConnection.IConfigurationOp saveOp = JzRepoControllableResource.createNewFileItem(this.getWvcmWorkspace(), (IFileItem)fileItem.fetchCompleteState(), null, newIsExecutable, null);
        this.commit(saveOp, this.getLocation());
    }

    public void doWriteContent(InputStream input, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        this.doWriteContentProperties(updates, updated, feedback);
        JzLocation myLoc = this.getLocation();
        JzRepoFileItem fileItem = (JzRepoFileItem)this.latestVersion(false, feedback);
        try {
            IWorkspaceConnection.IConfigurationOp saveOp = this.doWriteContent((IFileItem)fileItem.fetchCompleteState(), input, contentIdentifier, updates, updated, feedback);
            this.deferOrCommitOperation(saveOp);
        }
        catch (WvcmException e) {
            throw this.wrapExceptionGivenExternalizedMsg(NLS.bind((String)Messages.JzRepoControllableResource_ERROR_WRITE_CONTENT_FAILED_WITH_LOCATION, (Object[])new Object[]{myLoc.string()}), (Exception)((Object)e));
        }
    }

    private void deferOrCommitOperation(IWorkspaceConnection.IConfigurationOp saveOp) throws WvcmException {
        JzRepoControllableResource.deferOrCommitOperation(this.getProvider(), this.getLocation(), saveOp);
    }

    private static void deferOrCommitOperation(JzProvider provider, JzLocation myLoc, IWorkspaceConnection.IConfigurationOp operation) throws WvcmException {
        if (operation != null) {
            JzRepoConfiguration config = JzRepoControllableResource.getWvcmConfiguration(provider, myLoc);
            if (provider.areContentCommitsDeferred()) {
                provider.deferOrCommitContentOp(config, operation, myLoc);
            } else {
                JzRepoControllableResource.commit(config, operation, myLoc);
            }
        }
    }

    private void doWriteContentProperties(Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        Map<PropertyNameList.PropertyName<?>, PropValue> supportedUpdates = JzRepoControllableResource.computeLatestVersionSupportedProperties(updates);
        this.doWriteProperties(supportedUpdates, updated, feedback);
    }

    private static Map<PropertyNameList.PropertyName<?>, PropValue> computeLatestVersionSupportedProperties(Map<PropertyNameList.PropertyName<?>, PropValue> updates) {
        HashMap supportedUpdates = new HashMap(updates);
        for (PropertyNameList.PropertyName<?> propertyName : LATEST_VERSION_PROPERTIES) {
            if (!supportedUpdates.containsKey(propertyName)) continue;
            supportedUpdates.remove(propertyName);
        }
        return supportedUpdates;
    }

    protected void commit(IVersionable saveMe, JzLocation location) throws WvcmException {
        this.commit((IWorkspaceConnection.IConfigurationOp)this.getWvcmWorkspace().getConnection().configurationOpFactory().save(saveMe), location);
    }

    protected void commit(IWorkspaceConnection.IConfigurationOp configOp, JzLocation location) throws WvcmException {
        JzRepoControllableResource.commit(this.getWvcmConfiguration(), configOp, location);
    }

    static void commit(JzRepoConfiguration config, IWorkspaceConnection.IConfigurationOp configOp, JzLocation location) throws WvcmException {
        config.commit(configOp, location);
    }

    public IWorkspaceConnection.IConfigurationOp doWriteContent(IFileItem fileRepo, InputStream input, String contentIdentifierIgnored, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IWorkspaceConnection.IConfigurationOp result = null;
        try {
            boolean newPropertiesAreSame;
            boolean encodingsMatch;
            JzProvider provider = this.getProvider();
            Boolean newIsExecutable = JzRepoControllableResource.getIsExecutable(updates);
            boolean isExecutablesMatch = newIsExecutable == null || newIsExecutable.booleanValue() == fileRepo.isExecutable();
            IContent repoContent = fileRepo.getContent();
            IContent newContent = JzRepoControllableResource.createContent(this.getProvider(), input, updates, updated, repoContent);
            IContentManager contentManager = provider.getRepo().contentManager();
            String repoEncoding = repoContent.getCharacterEncoding();
            String newEncoding = newContent.getCharacterEncoding();
            long repoLength = repoContent.getRawLength();
            long newLength = newContent.getRawLength();
            HashCode repoHash = repoContent.getRawHashCode();
            HashCode newHash = newContent.getRawHashCode();
            boolean typesMatch = repoContent.getContentType().equals(newContent.getContentType());
            boolean bl = encodingsMatch = repoEncoding == null && newEncoding == null || repoEncoding != null && repoEncoding.equals(newEncoding);
            boolean ifNotTextLengthsMatch = repoEncoding == null && newEncoding == null ? repoLength == newLength : true;
            boolean bl2 = newPropertiesAreSame = isExecutablesMatch && typesMatch && encodingsMatch && ifNotTextLengthsMatch && repoHash.equals((Object)newHash) && contentManager.areContentBytesIdentical(repoContent, newContent, provider.getMonitor());
            if (newPropertiesAreSame) {
                System.out.println(Messages.JzRepoFileItem_WARNING_DUPLICATE_CONTENT_WRITTEN);
            } else {
                result = JzRepoControllableResource.createNewFileItem(this.getWvcmWorkspace(), fileRepo, newContent, newIsExecutable, updated);
            }
            return result;
        }
        catch (Exception e) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoConfiguration_ERROR_COMMIT_FAILED), null, JzRepoException.exceptionToReasonCode(e), (Throwable)e);
        }
    }

    private static IWorkspaceConnection.IConfigurationOp createNewFileItem(JzRepoWorkspace ws, IFileItem fileRepo, IContent newContent, Boolean newIsExecutable, List<PropertyNameList.PropertyName<?>> updated) throws WvcmException {
        IWorkspaceConnection.ISaveOp result = null;
        if (newContent != null || newIsExecutable != null) {
            IFileItem fileWorkingCopy = (IFileItem)fileRepo.getWorkingCopy();
            if (newContent != null) {
                fileWorkingCopy.setContent(newContent);
            }
            fileWorkingCopy.setFileTimestamp(new Date(System.currentTimeMillis()));
            if (newIsExecutable != null) {
                fileWorkingCopy.setExecutable(newIsExecutable.booleanValue());
            }
            result = ws.getConnection().configurationOpFactory().save((IVersionable)fileWorkingCopy);
            if (newIsExecutable != null && updated != null) {
                updated.add(Resource.IS_EXECUTABLE);
            }
        }
        return result;
    }

    protected void checkWhetherPropertyCanBeSet(PropertyNameList.PropertyName<?> propertyName, Object value) throws WvcmException {
        if (propertyName.equals((Object)Resource.IS_EXECUTABLE)) {
            return;
        }
        super.checkWhetherPropertyCanBeSet(propertyName, value);
    }

    private static Boolean getIsExecutable(Map<PropertyNameList.PropertyName<?>, PropValue> updates) {
        PropValue pv = updates.get(Resource.IS_EXECUTABLE);
        Boolean result = pv == null ? null : (Boolean)pv.get_value();
        return result;
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableResourceImpl.class;
    }

    public JzRepoVersionHistory getVersionHistory(SrvcFeedback feedback) throws WvcmException {
        JzRepoVersionHistory result = new JzRepoVersionHistory(this.getProvider(), this.getVersionHistoryLocation(feedback));
        result.setItemHandle(this.getItemHandle());
        return result;
    }

    private JzRepoVersion latestVersion(boolean applyDeferredContentCommits, SrvcFeedback feedback) throws WvcmException {
        JzRepoVersionHistory myVersionable = this.getVersionHistory(feedback);
        if (applyDeferredContentCommits) {
            this.applyDeferredContentCommits();
        }
        JzRepoVersion result = myVersionable.getVersion(this.getConfiguration());
        return result;
    }

    public JzRepoConfiguration getWvcmConfiguration() throws WvcmException {
        return JzRepoControllableResource.getWvcmConfiguration(this.getProvider(), this.getLocation());
    }

    private static JzRepoConfiguration getWvcmConfiguration(JzProvider provider, JzLocation myLoc) throws WvcmException {
        JzLocation bcfLoc = myLoc.getBcfLocation();
        JzLocation resultLoc = bcfLoc.createConfigurationLoc();
        return (JzRepoConfiguration)provider.lookup(resultLoc, null);
    }

    public JzLocation getComponentLocation() throws WvcmException {
        return this.getLocation().getComponentLocation();
    }

    @Override
    public Location getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        String[] segments;
        JzRepoComponent comp = this.getJzRepoComponent();
        JzLocation result = this.getWvcmWorkspace().getPathnameLocation(feedback);
        result = result.child(comp.getName());
        if (this.getLocation().kind().equals((Object)JzLocation.Kind.BaselineControlledFolder)) {
            return result;
        }
        String[] stringArray = segments = this.getLocation().getPath();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result = result.child(name);
            ++n2;
        }
        return result;
    }

    public JzRepoComponent getJzRepoComponent() throws WvcmException {
        JzRepoWorkspace ws = this.getWvcmWorkspace();
        JzRepoComponent result = ws.getJzRepoComponent(this.getLocation().getComponentLocation(), null);
        return result;
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.CONTENT_TYPE)) {
            return;
        }
        if (propertyName.equals((Object)Resource.CONTENT_CHARACTER_SET)) {
            return;
        }
        if (propertyName.equals((Object)Resource.IS_EXECUTABLE)) {
            Boolean xBit = (Boolean)value;
            this.doWriteIsExecutable(xBit);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    public static IContent createContent(JzProvider provider, InputStream input, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, IContent predContent) throws TeamRepositoryException, WvcmException, IOException {
        String contentTypeToUse;
        String requestedContentType = JzRepoControllableResource.computeContentType(updates);
        String requestedCharacterEncoding = JzRepoControllableResource.computeEncoding(updates);
        LineDelimiter requestedLineDelimiter = JzRepoControllableResource.computeLineDelimiter(provider, updates);
        if (requestedCharacterEncoding == null && requestedLineDelimiter != null && !LineDelimiter.LINE_DELIMITER_NONE.equals((Object)requestedLineDelimiter)) {
            throw new IllegalArgumentException("contentEncoding must not be null when lineDelimiter is not null: " + requestedLineDelimiter.toString());
        }
        if (predContent == null && (requestedContentType == null || requestedLineDelimiter == null)) {
            throw new IllegalArgumentException("updates must specify contentType, Encoding, LineDelimiter when predContent is null");
        }
        String string = contentTypeToUse = requestedContentType != null ? requestedContentType : predContent.getContentType();
        String contentEncodingToUse = requestedCharacterEncoding != null ? requestedCharacterEncoding : (predContent == null ? null : predContent.getCharacterEncoding());
        LineDelimiter lineDelimiterToUse = requestedLineDelimiter != null ? requestedLineDelimiter : predContent.getLineDelimiter();
        InputStream inputToUse = input;
        if (contentTypeToUse.trim().toLowerCase().startsWith(TEXT) && !LineDelimiter.LINE_DELIMITER_NONE.equals((Object)lineDelimiterToUse)) {
            LineDelimiterVerifier conversionStream = LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)input, (String)contentEncodingToUse, (LineDelimiter)lineDelimiterToUse);
            inputToUse = new ReaderToInputStream((InputStreamReader)conversionStream);
        }
        UUID predContentId = predContent == null ? null : predContent.getContentId();
        IContent newContent = provider.getRepo().contentManager().storeContent(contentTypeToUse, contentEncodingToUse, lineDelimiterToUse, inputToUse, predContentId, provider.getMonitor());
        if (requestedContentType != null) {
            updated.add(Resource.CONTENT_TYPE);
        }
        if (requestedCharacterEncoding != null) {
            updated.add(Resource.CONTENT_CHARACTER_SET);
        }
        if (requestedLineDelimiter != null) {
            updated.add(InteropStream.PN_LINE_SEPARATOR);
        }
        return newContent;
    }

    private static String computeContentType(Map<PropertyNameList.PropertyName<?>, PropValue> updates) {
        PropValue contentTypePVal = updates.get(Resource.CONTENT_TYPE);
        String contentType = contentTypePVal != null ? (String)contentTypePVal.get_value() : null;
        return contentType;
    }

    private static String computeEncoding(Map<PropertyNameList.PropertyName<?>, PropValue> updates) {
        PropValue contentEncodingPVal = updates.get(Resource.CONTENT_CHARACTER_SET);
        String contentEncoding = contentEncodingPVal != null ? (String)contentEncodingPVal.get_value() : null;
        return contentEncoding;
    }

    private static LineDelimiter computeLineDelimiter(JzProvider provider, Map<PropertyNameList.PropertyName<?>, PropValue> updates) {
        PropValue lineSeparatorPVal = updates.get(InteropStream.PN_LINE_SEPARATOR);
        LineDelimiter lineDelimiter = null;
        if (lineSeparatorPVal != null) {
            String lsName = (String)lineSeparatorPVal.get_value();
            InteropStream.LineSeparator ls = lsName != null ? InteropStream.LineSeparator.valueOf((String)lsName) : InteropStream.LineSeparator.UNSPECIFIED;
            lineDelimiter = InteropStream.LineSeparator.UNSPECIFIED.equals((Object)ls) ? LineDelimiter.LINE_DELIMITER_NONE : provider.getLineDelimiter();
        }
        return lineDelimiter;
    }

    protected static IContent createEmptyContent(JzProvider provider) throws WvcmException {
        try {
            IContent newContent = provider.getRepo().contentManager().storeContent("application/unknown", null, LineDelimiter.LINE_DELIMITER_NONE, (InputStream)new ByteArrayInputStream(emptyContentByteArray), null, provider.getMonitor());
            return newContent;
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException("Could not create empty content", null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static SrvcResource doCreateResourceWithContent(JzProvider provider, JzLocation myLoc, InputStream input, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        Map<PropertyNameList.PropertyName<?>, PropValue> supportedUpdates = JzRepoControllableResource.computeLatestVersionSupportedProperties(updates);
        if (supportedUpdates.keySet().size() > 0) {
            throw new IllegalArgumentException("cannot set non-content properties when writing to a new Versionable");
        }
        JzRepoControllableFolder parent = JzRepoControllableResource.getParent(provider, myLoc, feedback);
        String bindingName = myLoc.lastSegment();
        myLoc = parent.getLocation().child(bindingName);
        IFileItem addMe = (IFileItem)IFileItem.ITEM_TYPE.createItem();
        addMe.setName(bindingName);
        addMe.setParent((IFolderHandle)parent.getItemHandle());
        try {
            IContent newContent = JzRepoControllableResource.createContent(provider, input, updates, updated, null);
            IWorkspaceConnection.IConfigurationOp op = JzRepoControllableResource.createNewFileItem(JzRepoControllableResource.getWvcmWorkspace(provider, myLoc), addMe, newContent, JzRepoControllableResource.getIsExecutable(updates), updated);
            JzRepoControllableResource.deferOrCommitOperation(provider, myLoc, op);
            JzRepoControllableResource result = new JzRepoControllableResource(provider, myLoc);
            return result;
        }
        catch (Exception e) {
            throw new WvcmException(NLS.bind((String)Messages.JzProvider_ERROR_WRITE_CONTENT_FAILED_WITH_LOC_STRING, (Object[])new Object[]{myLoc.string()}), null, JzRepoException.exceptionToReasonCode(e), (Throwable)e);
        }
    }
}

