/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.ControllableFolderImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoBaselineControlledFolder;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoException;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoVersion;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableFolder;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JzRepoControllableFolder
extends JzRepoControllableResource {
    public static final String CHILD_LIST_SEPARATOR_STRING = String.valueOf(',');

    public JzRepoControllableFolder(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableFolderImpl.class;
    }

    public static JzRepoResource doCreateResource(JzProvider provider, JzLocation location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        boolean isBaselineControlledFolderLocation;
        boolean bl = isBaselineControlledFolderLocation = location.kind() == JzLocation.Kind.BaselineControlledFolder;
        if (isBaselineControlledFolderLocation) {
            JzRepoResource result = JzRepoBaselineControlledFolder.doCreateResource(provider, location, updates, updated, feedback);
            return result;
        }
        JzRepoResource result = JzRepoControllableFolder.doCreate(provider, location, updates, updated, feedback);
        return result;
    }

    public static JzRepoResource doCreate(JzProvider provider, JzLocation location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IVersionable resource = (IVersionable)IFolder.ITEM_TYPE.createItem();
        JzLocation actualAddedItemLocation = JzRepoControllableResource.doAddItemToParent(provider, location, resource, updates, updated, feedback);
        JzRepoControllableFolder result = new JzRepoControllableFolder(provider, actualAddedItemLocation);
        return result;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Folder.CHILD_MAP)) {
            return this.childMap(false, this.getConfiguration());
        }
        if (propertyName.equals((Object)Folder.CHILD_LIST)) {
            Map<String, SrvcResource> map = this.childMap(false, this.getConfiguration());
            ArrayList<SrvcResource> result = new ArrayList<SrvcResource>();
            result.addAll(map.values());
            return result;
        }
        if (propertyName.equals((Object)ControllableFolder.ROOT_FOLDER_OF)) {
            return null;
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public void doBindChild(String newBindingName, Location genericLocation, Folder.BindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits();
        JzLocation currentLoc = JzLocation.create(genericLocation);
        JzRepoControllableResource childCR = (JzRepoControllableResource)this.getProvider().lookup(currentLoc, feedback);
        if (childCR == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoControllableFolder_ERROR_NO_CHILD_AT_LOCATION, (Object[])new Object[]{currentLoc.string()}), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        this.rebindChildHelper((IVersionableHandle)childCR.getItemHandle(), newBindingName, feedback);
    }

    public void doRebindChild(String bindingName, Location currentParentLocation, String sourceBindingName, Folder.RebindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits();
        JzProvider provider = this.getProvider();
        JzRepoControllableFolder currentParent = (JzRepoControllableFolder)provider.lookup(currentParentLocation, feedback);
        IVersionableHandle childHandle = currentParent.getChild(sourceBindingName);
        this.rebindChildHelper(childHandle, bindingName, feedback);
    }

    public void doRebindAll(String bindingName, Location sourceLocation, Folder.RebindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits();
        JzProvider provider = this.getProvider();
        JzRepoControllableResource sourceCR = (JzRepoControllableResource)provider.lookup(sourceLocation, feedback);
        IVersionableHandle sourceHandle = (IVersionableHandle)sourceCR.getItemHandle();
        this.rebindChildHelper(sourceHandle, bindingName, feedback);
    }

    private void rebindChildHelper(IVersionableHandle childHandle, String newBindingName, SrvcFeedback feedback) throws WvcmException {
        IProgressMonitor monitor = this.getProvider().getMonitor();
        IConfiguration config = this.getConfiguration();
        try {
            IVersionable itemToRebind = (IVersionable)config.fetchCompleteItem(childHandle, monitor).getWorkingCopy();
            itemToRebind.setName(newBindingName);
            itemToRebind.setParent((IFolderHandle)this.getItemHandle());
            JzLocation reboundLocation = this.getLocation().child(newBindingName);
            this.commit(itemToRebind, reboundLocation);
        }
        catch (TeamRepositoryException e) {
            throw new WvcmException(e.getMessage(), null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public void doUnbindChild(String bindingName, SrvcFeedback feedback) throws WvcmException {
        this.applyDeferredContentCommits();
        IVersionableHandle deleteMe = this.getChild(bindingName);
        boolean itemToUnbindIsAFolder = deleteMe.getItemType().equals(IFolder.ITEM_TYPE);
        IWorkspaceConnection wsConn = this.getWvcmWorkspace().getConnection();
        IWorkspaceConnection.IDeleteOp configurationOp = itemToUnbindIsAFolder ? wsConn.configurationOpFactory().deleteSubtree((IFolderHandle)deleteMe) : wsConn.configurationOpFactory().delete(deleteMe);
        this.commit((IWorkspaceConnection.IConfigurationOp)configurationOp, this.getLocation().child(bindingName));
    }

    public IVersionableHandle getChild(String bindingName) throws WvcmException {
        try {
            IVersionableHandle result = this.getConfiguration().resolvePath((IFolderHandle)this.getItemHandle(), new String[]{bindingName}, this.getProvider().getMonitor());
            if (result == null) {
                throw new WvcmException(NLS.bind((String)Messages.JzRepoControllableFolder_ERROR_CHILD_NOT_FOUT_WITH_NAME, (Object[])new Object[]{bindingName}), null, WvcmException.ReasonCode.NOT_FOUND);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new JzRepoException("getChild", (JzRepoResource)this, (Exception)((Object)e));
        }
    }

    public static SrvcResource doCreateVersionControlledResource(JzProvider provider, Location genericLewLocation, Location genericVersionToRestoreLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzLocation versionToRestoreLoc;
        JzRepoVersion versionToRestore;
        JzRepoComponent versionToRestoreComponent;
        JzLocation newLocation = JzLocation.create(genericLewLocation);
        JzLocation parent = newLocation.parent();
        JzRepoControllableFolder restoreToThisFolder = (JzRepoControllableFolder)provider.lookup(parent, feedback);
        JzRepoComponent restoreToThisComponent = restoreToThisFolder.getJzRepoComponent();
        if (!restoreToThisComponent.isSameObject(versionToRestoreComponent = (versionToRestore = (JzRepoVersion)provider.lookup(versionToRestoreLoc = JzLocation.create(genericVersionToRestoreLoc), feedback)).getJzRepoComponent())) {
            IFolderHandle rootFolderHandle = versionToRestoreComponent.getRootFolderHandle();
            IFolderHandle parentFolderHandle = versionToRestore.getParentFolderHandle();
            if (!parentFolderHandle.sameItemId((IItemHandle)rootFolderHandle)) {
                throw new WvcmException(Messages.JzRepoControllableFolder_ERROR_NO_CROSS_COMPONENT_MOVES, WvcmException.ReasonCode.FORBIDDEN);
            }
            JzRepoWorkspace ws = JzRepoWorkspace.lookup(provider, newLocation.getWorkspaceLocation());
            ws.ensureComponentInConfiguration(versionToRestoreComponent);
            restoreToThisComponent = versionToRestoreComponent;
            JzLocation parentLoc = ws.computeBcfLoc(versionToRestoreComponent);
            restoreToThisFolder = (JzRepoControllableFolder)JzRepoControllableFolder.createFromVersionable(provider, parentLoc, (IVersionableHandle)rootFolderHandle);
        }
        return restoreToThisFolder.doCreateVersionControlledResource(newLocation, versionToRestore, updates, updated, feedback);
    }

    public static SrvcResource doCreateBaselineControlledFolder(JzProvider provider, Location genericLewLocation, Location genericBaselineToRestoreLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzLocation newLocation = JzLocation.create(genericLewLocation);
        JzLocation baselineToRestoreLoc = JzLocation.create(genericBaselineToRestoreLoc);
        JzLocation compLoc = baselineToRestoreLoc.getComponentLocation();
        JzRepoComponent comp = (JzRepoComponent)provider.lookup(compLoc, feedback);
        JzRepoWorkspace ws = JzRepoWorkspace.lookup(provider, newLocation.getWorkspaceLocation());
        ws.ensureComponentInConfiguration(comp);
        JzLocation resultLoc = ws.computeBcfLoc(comp);
        JzRepoControllableFolder result = (JzRepoControllableFolder)provider.lookup(resultLoc, feedback);
        return result;
    }

    public JzRepoControllableResource doCreateVersionControlledResource(JzLocation newLocationHint, JzRepoVersion item, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzProvider provider = this.getProvider();
        IFolderHandle newParentHandle = (IFolderHandle)this.getItemHandle();
        String bindingName = newLocationHint.lastSegment();
        JzLocation newLocation = this.getLocation().child(bindingName);
        if (provider.isDebugLogEnabled()) {
            this.logDebug(String.format("restoring URI: %s to location: %s", item.getLocation().string(), newLocation.string()));
        }
        IVersionable itemToCatalog = item.getWorkingCopy();
        itemToCatalog.setName(bindingName);
        itemToCatalog.setParent(newParentHandle);
        this.commit(itemToCatalog, newLocation);
        return JzRepoControllableFolder.createFromVersionable(provider, newLocation, (IVersionableHandle)itemToCatalog);
    }

    public JzLocation doAddItem(String bindingName, IVersionable addMe, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        IFolderHandle parentHandle = (IFolderHandle)this.getItemHandle();
        addMe.setName(bindingName);
        addMe.setParent(parentHandle);
        JzLocation resultLoc = this.getLocation().child(bindingName);
        this.commit(addMe, resultLoc);
        return resultLoc;
    }

    public IVersionableHandle getVersionableHandle(String[] path) throws WvcmException {
        IVersionableHandle result = this.lookupVersionableHandle(path);
        if (result == null) {
            throw new WvcmException("getVersionableHandle failed", null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    public IVersionableHandle lookupVersionableHandle(String[] path) throws WvcmException {
        JzLocation myLoc;
        JzLocation wsLoc;
        IVersionableHandle result = null;
        JzProvider provider = this.getProvider();
        JzRepoWorkspace ws = JzRepoWorkspace.lookup(provider, wsLoc = (myLoc = this.getLocation()).getWorkspaceLocation());
        if (ws == null) {
            throw new WvcmException("Could not find Workspace in: " + wsLoc.string(), null, WvcmException.ReasonCode.FORBIDDEN);
        }
        JzRepoComponent comp = ws.lookupJzRepoComponent(myLoc.getComponentLocation(), null);
        IConfiguration config = ws.ensureComponentInConfiguration(comp);
        try {
            IFolderHandle rootFolderHandle = config.rootFolderHandle(null);
            result = config.resolvePath(rootFolderHandle, path, provider.getMonitor());
            return result;
        }
        catch (TeamRepositoryException e) {
            this.logIgnoredException("lookupVersionableHandle", (Exception)((Object)e));
            return result;
        }
    }
}

