/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.team.connector.scm.client.JzRepoException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Location;
import javax.wvcm.WvcmException;

public class JzLocation
implements Location {
    public static final String PATHNAME_SEPERATOR_STRING = String.valueOf('/');
    public static String INFO_SEPARATOR_STRING = String.valueOf('|');
    public static String BACKSLASH = String.valueOf('\\');
    public static String INFO_SEPARATOR_REGEX = String.valueOf(BACKSLASH) + INFO_SEPARATOR_STRING;
    public static String PARTS_SEPARATOR_STRING = String.valueOf(INFO_SEPARATOR_STRING) + INFO_SEPARATOR_STRING;
    public static String PARTS_SEPARATOR_REGEX = String.valueOf(BACKSLASH) + INFO_SEPARATOR_STRING + BACKSLASH + INFO_SEPARATOR_STRING;
    private String _uninterpretedString;
    private Parts _parts;
    public static final String EMPTY_STRING;
    public static final String kindNullString;
    public static final String kindBaselineString;
    public static final String kindBaselineControlledFolderString;
    public static final String kindConfigurationString;
    public static final String kindChangeSetString;
    public static final String kindComponentString;
    public static final String kindControllableFolderString;
    public static final String kindControllableResourceString;
    public static final String kindFileSysPathString;
    public static final String kindPathnameString;
    public static final String kindRelativeRootString;
    public static final String kindRootString;
    public static final String kindRootVersionString;
    public static final String kindStreamString;
    public static final String kindVersionString;
    public static final String kindVersionHistoryString;
    public static final String kindWorkItemString;
    public static final String kindWorkspaceString;
    public static JzLocation _rootLoc;
    public static String SepThenNonSepChars;
    private static final String workspacePattern;
    private static final String streamPattern;
    public static final String URI_PREFIX = "URI:";
    public static final String NAME_PREFIX = "name:";

    static {
        kindNullString = EMPTY_STRING = new String();
        kindBaselineString = Kind.Baseline.toString();
        kindBaselineControlledFolderString = Kind.BaselineControlledFolder.toString();
        kindConfigurationString = Kind.Configuration.toString();
        kindChangeSetString = Kind.ChangeSet.toString();
        kindComponentString = Kind.Component.toString();
        kindControllableFolderString = Kind.ControllableFolder.toString();
        kindControllableResourceString = Kind.ControllableResource.toString();
        kindFileSysPathString = Kind.FileSysPath.toString();
        kindPathnameString = Kind.Pathname.toString();
        kindRelativeRootString = Kind.RelativePathname.toString();
        kindRootString = Kind.Root.toString();
        kindRootVersionString = Kind.RootVersion.toString();
        kindStreamString = Kind.Stream.toString();
        kindVersionString = Kind.Version.toString();
        kindVersionHistoryString = Kind.VersionHistory.toString();
        kindWorkItemString = Kind.WorkItem.toString();
        kindWorkspaceString = Kind.Workspace.toString();
        _rootLoc = new JzLocation(INFO_SEPARATOR_STRING);
        SepThenNonSepChars = String.valueOf(INFO_SEPARATOR_REGEX) + "[^" + INFO_SEPARATOR_STRING + "]+";
        workspacePattern = String.valueOf(Kind.Workspace.name()) + INFO_SEPARATOR_STRING;
        streamPattern = String.valueOf(Kind.Stream.name()) + INFO_SEPARATOR_STRING;
    }

    private static String childString(String parentString, String bindingName) {
        return String.valueOf(parentString) + PATHNAME_SEPERATOR_STRING + bindingName;
    }

    public static JzLocation createBCFLoc(JzLocation workspaceLocation, JzLocation componentLocation) {
        workspaceLocation.getParts().requireKind(Kind.Workspace);
        componentLocation.getParts().requireKind(Kind.Component);
        return JzLocation.createJoinedLocation(Kind.BaselineControlledFolder, null, workspaceLocation, componentLocation);
    }

    public JzLocation createConfigurationLoc() throws WvcmException {
        this.requireKind(Kind.BaselineControlledFolder);
        return JzLocation.createConfigurationLoc(this.getWorkspaceLocation(), this.getComponentLocation());
    }

    public static JzLocation createConfigurationLoc(JzLocation wsLoc, JzLocation compLoc) throws WvcmException {
        return JzLocation.createJoinedLocation(Kind.Configuration, null, wsLoc, compLoc);
    }

    public static JzLocation createJoinedLocation(Kind kind, String info, JzLocation workspaceLocation, JzLocation componentLocation) {
        Parts newParts = new Parts(kind, info);
        newParts.addContext(workspaceLocation);
        newParts.addContext(componentLocation);
        JzLocation result = new JzLocation(newParts);
        return result;
    }

    private static JzLocation createSimpleLocation(Kind kind, String displayName) {
        return new JzLocation(new Parts(kind, displayName));
    }

    public static JzLocation createStreamLoc(String displayName) {
        return JzLocation.createSimpleLocation(Kind.Stream, displayName);
    }

    public static JzLocation createWorkspaceStreamLoc(JzLocation wsLoc) {
        JzLocation streamLoc = new JzLocation(wsLoc._uninterpretedString.replace(workspacePattern, streamPattern));
        streamLoc._parts = new Parts(Kind.Stream, wsLoc._parts.get_myInfo(), wsLoc._parts.get_contextMap());
        return streamLoc;
    }

    public static JzLocation createStreamWorkspaceLoc(JzLocation streamLoc) {
        JzLocation wsLoc = new JzLocation(streamLoc._uninterpretedString.replace(streamPattern, workspacePattern));
        wsLoc._parts = new Parts(Kind.Workspace, streamLoc._parts.get_myInfo(), streamLoc._parts.get_contextMap());
        return wsLoc;
    }

    public static JzLocation createChangeSetLocation(String displayName) {
        return JzLocation.createSimpleLocation(Kind.ChangeSet, displayName);
    }

    public boolean isUriLocation() {
        return this.getDisplayName().startsWith(URI_PREFIX);
    }

    public static JzLocation createComponentNameLocation(String name) throws WvcmException {
        if (name.startsWith(URI_PREFIX)) {
            return JzLocation.createComponentUriLocation(name);
        }
        return JzLocation.createSimpleLocation(Kind.Component, NAME_PREFIX + name);
    }

    public static JzLocation createComponentUriLocation(String UriString) {
        return JzLocation.createSimpleLocation(Kind.Component, UriString);
    }

    public static JzLocation createWorkItemLoc(String displayName) {
        return JzLocation.createSimpleLocation(Kind.WorkItem, displayName);
    }

    public static JzLocation createWorkspaceLoc(String displayName) {
        return JzLocation.createSimpleLocation(Kind.Workspace, displayName);
    }

    public static String[] getParts(String string) {
        return string.split(PARTS_SEPARATOR_REGEX, 2);
    }

    protected static Kind parseKind(String kindString) {
        Kind result;
        try {
            if (kindString.equals("WorkspaceStream")) {
                return Kind.Stream;
            }
            result = Kind.valueOf(kindString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            result = null;
        }
        return result;
    }

    public static JzLocation root() {
        return new JzLocation(kindRootString);
    }

    public static JzLocation relativeRoot() {
        return new JzLocation(kindRootString);
    }

    public static Location workspaceFolderList() {
        return JzLocation.createWorkspaceLoc(EMPTY_STRING);
    }

    public JzLocation(JzLocation src) {
        this._uninterpretedString = src._uninterpretedString;
        this._parts = src._parts;
    }

    public JzLocation(Parts parts) {
        this._uninterpretedString = parts.string();
        this._parts = parts;
    }

    public JzLocation(String string) {
        this._uninterpretedString = string;
        this._parts = null;
    }

    public static JzLocation create(Location location) {
        JzLocation result = location instanceof JzLocation ? (JzLocation)location : new JzLocation(location.string());
        return result;
    }

    public JzLocation child(String bindingName) throws WvcmException {
        JzLocation result;
        if (bindingName == null) {
            throw new WvcmException("bindingName cannot be null", WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        if (bindingName.indexOf(INFO_SEPARATOR_STRING) != -1) {
            throw new WvcmException("Child cannot contain " + INFO_SEPARATOR_STRING + " as part of its name (in: " + bindingName + ").", WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        Parts myParts = this.getParts();
        Kind myKind = myParts.get_myKind();
        switch (myKind) {
            case BaselineControlledFolder: {
                result = this.createFileSysPathLocation(bindingName);
                break;
            }
            case ControllableFolder: 
            case FileSysPath: 
            case Pathname: {
                result = this.createPathChildLoc(bindingName);
                break;
            }
            case RelativePathname: {
                result = this.createPathChildLoc(bindingName);
                break;
            }
            case Root: {
                result = JzLocation.createSimpleLocation(Kind.Pathname, bindingName);
                break;
            }
            case Workspace: {
                result = JzLocation.createBCFLoc(this, JzLocation.createComponentNameLocation(bindingName));
                break;
            }
            default: {
                throw new JzRepoException("child", this, "unsupported location kind" + myKind.toString());
            }
        }
        return result;
    }

    private JzLocation createFileSysPathLocation(String bindingName) throws WvcmException {
        return JzLocation.createJoinedLocation(Kind.FileSysPath, bindingName, this.getWorkspaceLocation(), this.getComponentLocation());
    }

    public JzLocation createBaselineLoc(String displayName) throws WvcmException {
        JzLocation compLoc = this.getComponentLocation();
        return compLoc.createChildLocation(Kind.Baseline, displayName);
    }

    private JzLocation createChildLocation(Kind kind, String displayName) throws WvcmException {
        Parts resultParts = new Parts(kind, displayName, this);
        return new JzLocation(resultParts);
    }

    public JzLocation createPathChildLoc(String bindingName) {
        Parts parts = this.getParts();
        String newFileSysPath = JzLocation.childString(parts.get_myInfo(), bindingName);
        Parts newPnParts = new Parts(parts.get_myKind(), newFileSysPath, parts.get_contextMap());
        JzLocation pnLoc = new JzLocation(newPnParts);
        return pnLoc;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JzLocation)) {
            return false;
        }
        return this._uninterpretedString.equals(((JzLocation)o)._uninterpretedString);
    }

    public JzLocation getComponentLocation() throws WvcmException {
        return this.getContextLocation(Kind.Component);
    }

    JzLocation getBcfLocation() throws WvcmException {
        if (this.kind().equals((Object)Kind.BaselineControlledFolder)) {
            return this;
        }
        this.requireKind(Kind.FileSysPath);
        return this.createBcfLocation();
    }

    public String getDisplayName() {
        return this.getParts().get_myInfo();
    }

    public String[] getPath() throws WvcmException {
        Parts parts = this.getParts();
        Kind kind = parts.get_myKind();
        if (kind.equals((Object)Kind.FileSysPath) || kind.equals((Object)Kind.Pathname)) {
            String pathString = parts.get_myInfo();
            return pathString.split(PATHNAME_SEPERATOR_STRING);
        }
        throw new JzRepoException("getPath", this, "illegal kind: " + kind.toString());
    }

    public URI lookupURI() {
        URI result = null;
        try {
            String uriString = this.getUriString();
            result = new URI(uriString);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return result;
    }

    public URI getURI() throws WvcmException {
        try {
            String uriString = this.getUriString();
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new JzRepoException("getURI", this, (Exception)e);
        }
    }

    private String getUriString() {
        String displayName = this.getDisplayName();
        String uriString = displayName.startsWith(URI_PREFIX) ? displayName.substring(URI_PREFIX.length()) : displayName;
        return uriString;
    }

    public JzLocation lookupContextLocation(Kind kind) {
        Parts myParts = this.getParts();
        if (myParts == null) {
            return null;
        }
        if (myParts.get_myKind().equals((Object)kind)) {
            return this;
        }
        Map<Kind, JzLocation> c = myParts.get_contextMap();
        JzLocation result = c == null ? null : c.get((Object)kind);
        return result;
    }

    public JzLocation getContextLocation(Kind kind) throws WvcmException {
        JzLocation result = this.lookupContextLocation(kind);
        if (result == null) {
            throw new JzRepoException("getContextLocation", this, "Could not find Location with kind: " + kind.toString() + " in the context of the given location");
        }
        return result;
    }

    public JzLocation getWorkspaceLocation() throws WvcmException {
        return this.getContextLocation(Kind.Workspace);
    }

    public boolean hasLocationKind(Kind kind) {
        if (this.kind().equals((Object)kind)) {
            return false;
        }
        Parts myParts = this.getParts();
        if (myParts == null) {
            return false;
        }
        Map<Kind, JzLocation> c = myParts.get_contextMap();
        return c == null ? false : c.containsKey((Object)kind);
    }

    public boolean hasComponentLocation() {
        return this.hasLocationKind(Kind.Component) || this.kind().equals((Object)Kind.Component);
    }

    public int hashCode() {
        return this._uninterpretedString.hashCode();
    }

    public Kind kind() {
        return this.getParts().get_myKind();
    }

    public String lastSegment() {
        if (this.parent() == null) {
            return this.getDisplayName();
        }
        Parts parts = this.getParts();
        Kind kind = parts.get_myKind();
        String result = null;
        switch (kind) {
            case FileSysPath: 
            case Pathname: 
            case RelativePathname: {
                String pathname = parts.get_myInfo();
                int lastIndexOf = pathname.lastIndexOf(PATHNAME_SEPERATOR_STRING);
                if (lastIndexOf < 0) {
                    result = pathname;
                    break;
                }
                int startOfLastSegment = lastIndexOf + PATHNAME_SEPERATOR_STRING.length();
                if (startOfLastSegment >= pathname.length()) break;
                result = pathname.substring(startOfLastSegment);
            }
        }
        return result;
    }

    public String name() {
        Parts parts = this.getParts();
        return parts.get_myInfo();
    }

    public JzLocation parent() {
        Parts parts = this.getParts();
        Kind kind = parts.get_myKind();
        JzLocation result = null;
        try {
            switch (kind) {
                case Baseline: {
                    result = this.getComponentLocation();
                    break;
                }
                case BaselineControlledFolder: {
                    result = this.getWorkspaceLocation();
                    break;
                }
                case Component: {
                    break;
                }
                case Configuration: {
                    break;
                }
                case ControllableFolder: 
                case FileSysPath: 
                case Pathname: 
                case RelativePathname: {
                    result = this.pathnameParent(parts);
                    break;
                }
                case ControllableResource: {
                    break;
                }
                case Root: {
                    break;
                }
                case RootVersion: {
                    break;
                }
                case RootBaseline: {
                    break;
                }
                case Stream: {
                    break;
                }
                case Version: {
                    break;
                }
                case VersionHistory: {
                    break;
                }
            }
        }
        catch (WvcmException wvcmException) {}
        return result;
    }

    public JzLocation pathnameParent(Parts parts) throws WvcmException {
        String pathname = parts.get_myInfo();
        int lastIndexOf = pathname.lastIndexOf(PATHNAME_SEPERATOR_STRING);
        JzLocation result = null;
        if (lastIndexOf < 0) {
            result = this.createBcfLocation();
        } else {
            String parentPN = pathname.substring(0, lastIndexOf);
            Parts parentParts = new Parts(parts.get_myKind(), parentPN, parts.get_contextMap());
            result = new JzLocation(parentParts);
        }
        return result;
    }

    private JzLocation createBcfLocation() throws WvcmException {
        JzLocation wsLoc = this.getWorkspaceLocation();
        JzLocation compLoc = this.getComponentLocation();
        if (wsLoc == null || compLoc == null) {
            return null;
        }
        return JzLocation.createBCFLoc(wsLoc, compLoc);
    }

    private void requireKind(Kind expectedKind) {
        Kind kind = this.kind();
        if (!kind.equals((Object)expectedKind)) {
            throw new IllegalArgumentException("Expected kind: " + expectedKind.toString() + " actual kind: " + kind.toString());
        }
    }

    private synchronized Parts getParts() {
        if (this._parts == null) {
            this._parts = new Parts(this._uninterpretedString);
        }
        return this._parts;
    }

    public String string() {
        Parts parts = this.getParts();
        if (parts.get_myKind() == null) {
            throw new IllegalArgumentException("location has no kind");
        }
        return this._uninterpretedString;
    }

    public String toString() {
        return "(JzLocation: " + this._uninterpretedString + ")";
    }

    public JzLocation createVersionHistoryLocation(String VersionHistoryUri) throws WvcmException {
        this.getParts().requireKind(Kind.Component);
        return this.createChildLocation(Kind.VersionHistory, VersionHistoryUri);
    }

    public JzLocation createVersionLocation(String versionUri) throws WvcmException {
        this.getParts().requireKind(Kind.Component);
        return this.createChildLocation(Kind.Version, versionUri);
    }

    public JzLocation createRootVersionLocation() throws WvcmException {
        this.getParts().requireKind(Kind.VersionHistory);
        return this.createChildLocation(Kind.RootVersion, null);
    }

    public JzLocation createRootBaselineLocation() throws WvcmException {
        this.getParts().requireKind(Kind.Component);
        return this.createChildLocation(Kind.RootBaseline, null);
    }

    public static JzLocation createCrLoc(String versionableUri, JzLocation workspaceLocation, JzLocation componentLocation) {
        return JzLocation.createJoinedLocation(Kind.ControllableResource, versionableUri, workspaceLocation, componentLocation);
    }

    public JzLocation getVersionHistoryLocation() throws WvcmException {
        return this.getContextLocation(Kind.VersionHistory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        Null,
        Baseline,
        BaselineControlledFolder,
        ChangeSet,
        Component,
        Configuration,
        ControllableFolder,
        ControllableResource,
        FileSysPath,
        Pathname,
        RelativePathname,
        Root,
        RootVersion,
        RootBaseline,
        Stream,
        Version,
        VersionHistory,
        WorkItem,
        Workspace;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Parts {
        private Kind _myKind;
        private String _myInfo;
        private Map<Kind, JzLocation> _myContext;

        public Parts(Kind kind, String info) {
            this(kind, info, new HashMap<Kind, JzLocation>());
        }

        public Parts(Kind kind, String info, Map<Kind, JzLocation> context) {
            this._myKind = kind;
            this._myInfo = info;
            this._myContext = context != null ? context : new HashMap();
        }

        public Parts(Parts parts) {
            this(parts._myKind, parts._myInfo, parts._myContext);
        }

        public Parts(Kind kind, String info, JzLocation context) {
            this(kind, info);
            this.addContext(context);
        }

        public Parts(String locationString) {
            if (locationString == null) {
                throw new IllegalArgumentException("location string must not be null");
            }
            String[] segments = this.getSegments(locationString);
            String[] myInfo = this.getInfoStrings(segments[0]);
            String kindString = myInfo[0];
            Kind myKind = JzLocation.parseKind(kindString);
            if (myKind == null) {
                this._myKind = Kind.Null;
                this._myInfo = myInfo[0];
                this._myContext = null;
                return;
            }
            String details = myInfo.length > 1 ? myInfo[1] : EMPTY_STRING;
            this._myKind = myKind;
            this._myInfo = details;
            this._myContext = new HashMap<Kind, JzLocation>();
            int i = 1;
            while (i < segments.length) {
                String segment = segments[i];
                String[] infoSegments = this.getSegments(segment);
                String[] segmentInfo = this.getInfoStrings(infoSegments[0]);
                Kind segmentKind = JzLocation.parseKind(segmentInfo[0]);
                String info = segmentInfo.length > 1 ? segmentInfo[1] : EMPTY_STRING;
                Parts segmentParts = new Parts(segmentKind, info);
                JzLocation segmentLocation = new JzLocation(segmentParts);
                this.addContext(segmentLocation);
                ++i;
            }
        }

        public String[] getInfoStrings(String segment) throws IllegalArgumentException {
            String[] myInfo = segment.split(INFO_SEPARATOR_REGEX);
            if (myInfo.length < 1) {
                throw new IllegalArgumentException("Could not interpret location string (could not find kind): " + segment);
            }
            return myInfo;
        }

        public String[] getSegments(String locationString) throws IllegalArgumentException {
            String[] segments = locationString.split(PARTS_SEPARATOR_REGEX);
            if (segments.length < 1) {
                throw new IllegalArgumentException("Could not interpret location string: " + locationString);
            }
            return segments;
        }

        public Kind get_myKind() {
            return this._myKind;
        }

        public String get_myInfo() {
            return this._myInfo;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("(contextParts ");
            result.append("myKind: ");
            result.append(this._myKind.toString());
            result.append(".  myInfo: ");
            result.append(this._myInfo);
            result.append(".  ");
            if (this._myContext == null) {
                result.append("<null>");
            } else {
                result.append(this._myContext.toString());
            }
            result.append(")");
            return result.toString();
        }

        private String string() {
            StringBuffer result = new StringBuffer(this.get_myKind().toString());
            if (this.get_myInfo() != null) {
                result.append(INFO_SEPARATOR_STRING);
                result.append(this.get_myInfo());
            }
            if (this._myContext != null) {
                Set<Kind> keySet = this._myContext.keySet();
                ArrayList<Kind> keyList = new ArrayList<Kind>(keySet.size());
                keyList.addAll(keySet);
                Collections.sort(keyList);
                for (Kind contextKind : keyList) {
                    result.append(PARTS_SEPARATOR_STRING);
                    result.append(this._myContext.get((Object)contextKind).string());
                }
            }
            return result.toString();
        }

        public void requireContext() {
            if (this._myContext == null) {
                throw new IllegalArgumentException("Expected context parts.  actual contextParts is null");
            }
        }

        public void addContext(JzLocation context) {
            this._myContext.put(context.kind(), context);
        }

        public Map<Kind, JzLocation> get_contextMap() {
            return this._myContext;
        }

        public void requireKind(Kind expectedKind) {
            if (!this._myKind.equals((Object)expectedKind)) {
                throw new IllegalArgumentException("Expected kind: " + expectedKind.toString() + " actual kind: " + this._myKind.toString());
            }
        }
    }
}

