/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.Utils$$Cold;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Utils {
    private static final String PROP_ARCH = "osgi.arch";
    private static final String PROP_NL = "osgi.nl";
    private static final String PROP_OS = "osgi.os";
    private static final String PROP_WS = "osgi.ws";
    private static final String PI_OSGI = "org.eclipse.osgi";
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    public static boolean isWindows = System.getProperty("os.name").startsWith("Win");
    static FrameworkLog log;
    private static ServiceTracker bundleTracker;
    private static ServiceTracker instanceLocation;
    private static ServiceTracker configurationLocation;
    static Class class$0;
    static Class class$1;

    public static void debug(String string) {
        if (ConfigurationActivator.DEBUG) {
            System.out.println("PlatformConfig: " + string);
        }
    }

    public static void log(String string) {
        Utils.log(Utils.newStatus(string, null));
    }

    static synchronized void shutdown() {
        if (bundleTracker != null) {
            bundleTracker.close();
            bundleTracker = null;
        }
        if (instanceLocation != null) {
            instanceLocation.close();
            instanceLocation = null;
        }
        if (configurationLocation != null) {
            configurationLocation.close();
            configurationLocation = null;
        }
    }

    public static boolean isRunning() {
        Bundle bundle = Utils.getBundle(PI_OSGI);
        return bundle == null ? false : bundle.getState() == 32;
    }

    public static String getOS() {
        return Utils.getContext().getProperty(PROP_OS);
    }

    public static String getWS() {
        return Utils.getContext().getProperty(PROP_WS);
    }

    public static String getArch() {
        return Utils.getContext().getProperty(PROP_ARCH);
    }

    public static String getNL() {
        return Utils.getContext().getProperty(PROP_NL);
    }

    public static long getStateStamp() {
        ServiceReference serviceReference;
        BundleContext bundleContext = Utils.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        if ((serviceReference = bundleContext.getServiceReference(clazz.getName())) == null) {
            return -1L;
        }
        PlatformAdmin platformAdmin = (PlatformAdmin)Utils.getContext().getService(serviceReference);
        return platformAdmin == null ? -1L : platformAdmin.getState(false).getTimeStamp();
    }

    public static synchronized Bundle getBundle(String string) {
        PackageAdmin packageAdmin;
        if (bundleTracker == null) {
            BundleContext bundleContext = Utils.getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            bundleTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
            bundleTracker.open();
        }
        if ((packageAdmin = (PackageAdmin)bundleTracker.getService()) == null) {
            return null;
        }
        Bundle[] bundleArray = packageAdmin.getBundles(string, null);
        if (bundleArray == null) {
            return null;
        }
        int n = 0;
        while (n < bundleArray.length) {
            if ((bundleArray[n].getState() & 3) == 0) {
                return bundleArray[n];
            }
            ++n;
        }
        return null;
    }

    private static BundleContext getContext() {
        return ConfigurationActivator.getBundleContext();
    }

    public static synchronized Location getConfigurationLocation() {
        if (configurationLocation == null) {
            Filter filter = null;
            try {
                filter = Utils.getContext().createFilter(Location.CONFIGURATION_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            configurationLocation = new ServiceTracker(Utils.getContext(), filter, null);
            configurationLocation.open();
        }
        return (Location)configurationLocation.getService();
    }

    public static boolean isAutomaticallyStartedBundle(String string) {
        if (string.indexOf(PI_OSGI) != -1) {
            return true;
        }
        String string2 = ConfigurationActivator.getBundleContext().getProperty("osgi.bundles");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(64);
            if (n != -1) {
                string3 = string3.substring(0, n);
            }
            if (string3.startsWith("reference:file:") && string.indexOf((file = new File(string3.substring(15))).getName()) != -1) {
                return true;
            }
            if (string.indexOf(string3) == -1) continue;
            return true;
        }
        return false;
    }

    public static URL makeRelative(URL uRL, URL uRL2) {
        if (uRL == null) {
            return uRL2;
        }
        if (!"file".equals(uRL.getProtocol())) {
            return uRL2;
        }
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return uRL2;
        }
        Path path = new Path(uRL2.getPath());
        if (!path.isAbsolute()) {
            return uRL2;
        }
        IPath iPath = Utils.makeRelative((IPath)new Path(uRL.getPath()), (IPath)path);
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), iPath.toString());
        }
        catch (MalformedURLException malformedURLException) {
            String string = malformedURLException.getMessage();
            if (string == null) {
                string = "";
            }
            Utils.log(Utils.newStatus(string, malformedURLException));
            return uRL2;
        }
    }

    public static IPath makeRelative(IPath iPath, IPath iPath2) {
        if (iPath2.getDevice() != null && !iPath2.getDevice().equalsIgnoreCase(iPath.getDevice())) {
            return iPath2;
        }
        int n = iPath.segmentCount();
        int n2 = iPath.matchingFirstSegments(iPath2);
        String string = "";
        int n3 = 0;
        while (n3 < n - n2) {
            string = String.valueOf(string) + "../";
            ++n3;
        }
        return new Path(string).append(iPath2.removeFirstSegments(n2));
    }

    public static String canonicalizeURL(String string) {
        if (!isWindows || !string.startsWith("file:")) {
            return string;
        }
        try {
            String string2 = new URL(string).getPath();
            File file = new File(string2);
            string2 = file.toString().replace('\\', '/');
            if (Character.isUpperCase(string2.charAt(0))) {
                char[] cArray = string2.toCharArray();
                cArray[0] = Character.toLowerCase(cArray[0]);
                string2 = new String(cArray);
                return new File(string2).toURL().toExternalForm();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return string;
    }

    public static synchronized URL getInstallURL() {
        Location location;
        if (instanceLocation == null) {
            location = null;
            try {
                location = Utils.getContext().createFilter(Location.INSTALL_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            instanceLocation = new ServiceTracker(Utils.getContext(), (Filter)location, null);
            instanceLocation.open();
        }
        if ((location = (Location)instanceLocation.getService()) == null) {
            throw (Throwable)new IllegalStateException("The installation location must not be null");
        }
        return location.getURL();
    }

    public static CoreException newCoreException(String string, Throwable throwable) throws  {
        return Utils$$Cold.newCoreException(string, throwable);
    }

    public static IStatus newStatus(String string, Throwable throwable) throws  {
        return Utils$$Cold.newStatus(string, throwable);
    }

    public static void log(IStatus iStatus) throws  {
        Utils$$Cold.log(iStatus);
    }

    public static boolean isValidEnvironment(String string, String string2, String string3, String string4) {
        if (string != null && !Utils.isMatching(string, Utils.getOS())) {
            return false;
        }
        if (string2 != null && !Utils.isMatching(string2, Utils.getWS())) {
            return false;
        }
        if (string3 != null && !Utils.isMatching(string3, Utils.getArch())) {
            return false;
        }
        return string4 == null || Utils.isMatchingLocale(string4, Utils.getNL());
    }

    private static boolean isMatching(String string, String string2) throws  {
        return Utils$$Cold.isMatching(string, string2);
    }

    private static boolean isMatchingLocale(String string, String string2) throws  {
        return Utils$$Cold.isMatchingLocale(string, string2);
    }

    public static Locale getDefaultLocale() throws  {
        return Utils$$Cold.getDefaultLocale();
    }

    public static String getResourceString(ResourceBundle resourceBundle, String string) throws  {
        return Utils$$Cold.getResourceString(resourceBundle, string);
    }

    public static URL makeAbsolute(URL uRL, URL uRL2) throws  {
        return Utils$$Cold.makeAbsolute(uRL, uRL2);
    }

    public static String makeRelative(URL uRL, String string) throws  {
        return Utils$$Cold.makeRelative(uRL, string);
    }
}

