/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.Utils;

public class Utils$$Cold {
    public static Locale getDefaultLocale() {
        String string = Utils.getNL();
        if (string == null) {
            return Locale.getDefault();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        if (stringTokenizer.countTokens() == 1) {
            return new Locale(stringTokenizer.nextToken(), "");
        }
        if (stringTokenizer.countTokens() == 2) {
            return new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        if (stringTokenizer.countTokens() == 3) {
            return new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        return Locale.getDefault();
    }

    public static String getResourceString(ResourceBundle resourceBundle, String string) {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = string.trim();
        if (string3.equals("")) {
            return string;
        }
        if (!string3.startsWith("%")) {
            return string;
        }
        if (string3.startsWith("%%")) {
            return string3.substring(1);
        }
        int n = string3.indexOf(" ");
        String string4 = n == -1 ? string3 : string3.substring(0, n);
        String string5 = string2 = n == -1 ? string3 : string3.substring(n + 1);
        if (resourceBundle == null) {
            return string2;
        }
        try {
            return resourceBundle.getString(string4.substring(1));
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    public static boolean isMatching(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if ("*".equalsIgnoreCase(string)) {
            return true;
        }
        string2 = string2.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toUpperCase();
            if (string2.indexOf(string3) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatchingLocale(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if ("*".equalsIgnoreCase(string)) {
            return true;
        }
        string2 = string2.toUpperCase();
        string = string.toUpperCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string2.indexOf(string3) == 0) {
                return true;
            }
            if (string3.indexOf(string2) != 0) continue;
            return true;
        }
        return false;
    }

    public static void log(IStatus iStatus) {
        if (Utils.log != null) {
            Utils.log.log(new FrameworkLogEntry(ConfigurationActivator.PI_CONFIGURATOR, iStatus.getMessage(), 0, iStatus.getException(), null));
        } else {
            System.out.println(iStatus.getMessage());
            if (iStatus.getException() != null) {
                iStatus.getException().printStackTrace();
            }
        }
    }

    public static URL makeAbsolute(URL uRL, URL uRL2) {
        if (!"file".equals(uRL.getProtocol())) {
            return uRL2;
        }
        if (uRL2.getProtocol() != null && !uRL2.getProtocol().equals(uRL.getProtocol())) {
            return uRL2;
        }
        Path path = new Path(uRL2.getPath());
        if (path.isAbsolute()) {
            return uRL2;
        }
        try {
            IPath iPath = new Path(uRL.getPath()).append(uRL2.getPath());
            return iPath.toFile().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            Utils.log(malformedURLException.getLocalizedMessage());
            return uRL2;
        }
    }

    public static String makeRelative(URL uRL, String string) {
        try {
            return Utils.makeRelative(uRL, new URL(string)).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    public static CoreException newCoreException(String string, Throwable throwable) {
        MultiStatus multiStatus;
        if (throwable instanceof CoreException) {
            if (string == null) {
                string = "";
            }
            multiStatus = new MultiStatus("org.eclipse.update.configurator", 0, string, throwable);
            IStatus iStatus = ((CoreException)throwable).getStatus();
            multiStatus.add(iStatus);
            multiStatus.addAll(iStatus);
        } else {
            StringBuffer stringBuffer = new StringBuffer("");
            if (string != null) {
                stringBuffer.append(string);
            }
            if (throwable != null) {
                stringBuffer.append(" [");
                String string2 = throwable.getLocalizedMessage();
                stringBuffer.append(string2 != null ? string2 : throwable.toString());
                stringBuffer.append("]");
            }
            multiStatus = Utils.newStatus(stringBuffer.toString(), throwable);
        }
        return new CoreException((IStatus)multiStatus);
    }

    public static IStatus newStatus(String string, Throwable throwable) {
        return (IStatus)new Status(4, "org.eclipse.update.configurator", 0, string, throwable);
    }
}

