/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.configurator.IPlatformConfiguration$IFeatureEntry;
import org.eclipse.update.configurator.IPlatformConfiguration$ISiteEntry;
import org.eclipse.update.configurator.IPlatformConfiguration$ISitePolicy;
import org.eclipse.update.internal.configurator.Configuration;
import org.eclipse.update.internal.configurator.ConfigurationActivator;
import org.eclipse.update.internal.configurator.ConfigurationParser;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Locker;
import org.eclipse.update.internal.configurator.Locker_JavaIo;
import org.eclipse.update.internal.configurator.Locker_JavaNio;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration$$Cold;
import org.eclipse.update.internal.configurator.PlatformConfiguration$1;
import org.eclipse.update.internal.configurator.PluginEntry;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.configurator.SitePolicy;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.internal.configurator.Utils;
import org.eclipse.update.internal.configurator.XMLPrintHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlatformConfiguration
implements IPlatformConfiguration,
IConfigurationConstants {
    private static PlatformConfiguration currentPlatformConfiguration = null;
    private static final String XML_ENCODING = "UTF-8";
    private Configuration config;
    private URL configLocation;
    private HashMap externalLinkSites = new HashMap();
    private long changeStamp;
    private long featuresChangeStamp;
    private boolean featuresChangeStampIsValid;
    private long pluginsChangeStamp;
    private boolean pluginsChangeStampIsValid;
    private Locker lock = null;
    private static int defaultPolicy = 1;
    private static boolean checkNio = false;
    private static boolean useNio;
    private static final String ECLIPSE = "eclipse";
    private static final String CONFIG_HISTORY = "history";
    private static final String PLATFORM_XML = "platform.xml";
    private static final String CONFIG_NAME = "org.eclipse.update/platform.xml";
    private static final String CONFIG_INI = "config.ini";
    private static final String CONFIG_FILE_LOCK_SUFFIX = ".lock";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String LINKS = "links";
    private static final String[] BOOTSTRAP_PLUGINS;
    private static final String DEFAULT_FEATURE_APPLICATION = "org.eclipse.ui.ide.workbench";
    private static final String LINK_PATH = "path";
    private static final String LINK_READ = "r";
    private static final String LINK_READ_WRITE = "rw";
    private static URL installURL;

    static {
        BOOTSTRAP_PLUGINS = new String[0];
    }

    private PlatformConfiguration(Location location) throws CoreException, IOException {
        this.config = null;
        this.initializeCurrent(location);
        if (this.config != null) {
            this.setDefaultPolicy();
        }
        if (!this.isTransient()) {
            this.configureExternalLinks();
        }
        this.validateSites();
        if (this.isTransient()) {
            return;
        }
        boolean bl = "true".equals(ConfigurationActivator.getBundleContext().getProperty("osgi.clean"));
        boolean bl2 = "true".equals(ConfigurationActivator.getBundleContext().getProperty("osgi.checkConfiguration"));
        if (bl || bl2) {
            this.refresh();
            this.reconcile();
        } else {
            this.changeStamp = this.computeChangeStamp();
            if (this.changeStamp > this.config.getDate().getTime()) {
                this.reconcile();
            }
        }
    }

    private void setDefaultPolicy() {
        int n;
        IPlatformConfiguration$ISiteEntry[] iPlatformConfiguration$ISiteEntryArray = this.getConfiguredSites();
        if (iPlatformConfiguration$ISiteEntryArray != null && iPlatformConfiguration$ISiteEntryArray.length > 0 && (n = iPlatformConfiguration$ISiteEntryArray[0].getSitePolicy().getType()) == 2) {
            defaultPolicy = n;
        }
    }

    public static int getDefaultPolicy() {
        return defaultPolicy;
    }

    public IPlatformConfiguration$ISiteEntry createSiteEntry(URL uRL, IPlatformConfiguration$ISitePolicy iPlatformConfiguration$ISitePolicy) {
        return new SiteEntry(uRL, iPlatformConfiguration$ISitePolicy);
    }

    public IPlatformConfiguration$ISitePolicy createSitePolicy(int n, String[] stringArray) {
        return new SitePolicy(n, stringArray);
    }

    public void configureSite(IPlatformConfiguration$ISiteEntry iPlatformConfiguration$ISiteEntry) {
        this.configureSite(iPlatformConfiguration$ISiteEntry, false);
    }

    public synchronized void configureSite(IPlatformConfiguration$ISiteEntry iPlatformConfiguration$ISiteEntry, boolean bl) {
        if (iPlatformConfiguration$ISiteEntry == null) {
            return;
        }
        URL uRL = iPlatformConfiguration$ISiteEntry.getURL();
        if (uRL == null) {
            return;
        }
        String string = uRL.toExternalForm();
        if (this.config.getSiteEntry(string) != null && !bl) {
            return;
        }
        if (iPlatformConfiguration$ISiteEntry instanceof SiteEntry) {
            this.config.addSiteEntry(string, (SiteEntry)iPlatformConfiguration$ISiteEntry);
        }
    }

    public IPlatformConfiguration$ISiteEntry[] getConfiguredSites() {
        if (this.config == null) {
            return new IPlatformConfiguration$ISiteEntry[0];
        }
        SiteEntry[] siteEntryArray = this.config.getSites();
        ArrayList<SiteEntry> arrayList = new ArrayList<SiteEntry>(siteEntryArray.length);
        int n = 0;
        while (n < siteEntryArray.length) {
            if (siteEntryArray[n].isEnabled()) {
                arrayList.add(siteEntryArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IPlatformConfiguration$ISiteEntry[arrayList.size()]);
    }

    public IPlatformConfiguration$ISiteEntry findConfiguredSite(URL uRL) {
        return this.findConfiguredSite(uRL, true);
    }

    public URL getConfigurationLocation() {
        return this.configLocation;
    }

    public long getChangeStamp() {
        if (this.config.getLinkedConfig() == null) {
            return this.config.getDate().getTime();
        }
        return Math.max(this.config.getDate().getTime(), this.config.getLinkedConfig().getDate().getTime());
    }

    public long getFeaturesChangeStamp() {
        return 0L;
    }

    public long getPluginsChangeStamp() {
        return 0L;
    }

    public URL[] getPluginPath() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Utils.debug("computed plug-in path:");
        IPlatformConfiguration$ISiteEntry[] iPlatformConfiguration$ISiteEntryArray = this.getConfiguredSites();
        int n = 0;
        while (n < iPlatformConfiguration$ISiteEntryArray.length) {
            String[] stringArray = iPlatformConfiguration$ISiteEntryArray[n].getPlugins();
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    URL uRL = new URL(((SiteEntry)iPlatformConfiguration$ISiteEntryArray[n]).getResolvedURL(), stringArray[n2]);
                    arrayList.add(uRL);
                    Utils.debug("   " + uRL.toString());
                }
                catch (MalformedURLException malformedURLException) {
                    Utils.debug("   bad URL: " + malformedURLException);
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new URL[0]);
    }

    public String[] getBootstrapPluginIdentifiers() {
        return BOOTSTRAP_PLUGINS;
    }

    public void setBootstrapPluginLocation(String string, URL uRL) {
    }

    public boolean isUpdateable() {
        return true;
    }

    public boolean isTransient() {
        return this.config != null ? this.config.isTransient() : false;
    }

    public void save() throws IOException {
        if (this.isUpdateable()) {
            this.save(this.configLocation);
        }
    }

    public synchronized void save(URL uRL) throws IOException {
        block30: {
            boolean bl;
            File file;
            if (uRL == null) {
                throw (Throwable)new IOException(Messages.cfig_unableToSave_noURL);
            }
            OutputStream outputStream = null;
            if (!uRL.getProtocol().equals("file")) {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoOutput(true);
                outputStream = uRLConnection.getOutputStream();
                try {
                    try {
                        this.saveAsXML(outputStream);
                        this.config.setDirty(false);
                        break block30;
                    }
                    catch (CoreException coreException) {
                        Utils.log(coreException.getMessage());
                        Utils.log(coreException.getStatus());
                        throw (Throwable)new IOException(NLS.bind((String)Messages.cfig_unableToSave, (Object[])new String[]{uRL.toExternalForm()}));
                    }
                }
                finally {
                    outputStream.close();
                }
            }
            File file2 = new File(uRL.getFile().replace('/', File.separatorChar));
            if (!file2.getName().equals(PLATFORM_XML)) {
                if (file2.exists() && file2.isFile()) {
                    Utils.log(String.valueOf(Messages.PlatformConfiguration_expectingPlatformXMLorDirectory) + file2.getName());
                    file2 = file2.getParentFile();
                }
                file2 = new File(file2, CONFIG_NAME);
            }
            if ((file = file2.getParentFile()) != null && !file.exists()) {
                file.mkdirs();
            }
            File file3 = new File(file2.getAbsolutePath());
            File file4 = new File(String.valueOf(file2.getAbsolutePath()) + CONFIG_FILE_TEMP_SUFFIX);
            if (file2.exists()) {
                File file5 = new File(file, CONFIG_HISTORY);
                if (!file5.exists()) {
                    file5.mkdir();
                }
                long l = file2.lastModified();
                File file6 = new File(file5, String.valueOf(String.valueOf(l)) + ".xml");
                long l2 = 1L;
                while (file6.exists() && l2 < 100L) {
                    file6 = new File(file5, String.valueOf(String.valueOf(l + l2++)) + ".xml");
                }
                if (!file6.exists() && !file2.renameTo(file6)) {
                    Utils.log(Messages.PlatformConfiguration_cannotBackupConfig);
                }
            }
            outputStream = new FileOutputStream(file4);
            try {
                try {
                    this.saveAsXML(outputStream);
                    try {
                        outputStream.flush();
                        ((FileOutputStream)outputStream).getFD().sync();
                    }
                    catch (SyncFailedException syncFailedException) {
                        Utils.log(syncFailedException.getMessage());
                    }
                    catch (IOException iOException) {
                        Utils.log(iOException.getMessage());
                    }
                    try {
                        outputStream.close();
                        outputStream = null;
                    }
                    catch (IOException iOException) {
                        Utils.log(String.valueOf(Messages.PlatformConfiguration_cannotCloseStream) + file4);
                        Utils.log(iOException.getMessage());
                    }
                    file4.setLastModified(this.config.getDate().getTime());
                    this.config.setLastModified(file4.lastModified());
                    this.changeStamp = this.config.getDate().getTime();
                    this.config.setDirty(false);
                }
                catch (CoreException coreException) {
                    throw (Throwable)new IOException(NLS.bind((String)Messages.cfig_unableToSave, (Object[])new String[]{file4.getAbsolutePath()}));
                }
            }
            catch (Throwable throwable) {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        Utils.log(String.valueOf(Messages.PlatformConfiguration_cannotCloseTempFile) + file4);
                    }
                }
                throw throwable;
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    Utils.log(String.valueOf(Messages.PlatformConfiguration_cannotCloseTempFile) + file4);
                }
            }
            if (!(bl = file4.renameTo(file3))) {
                Utils.log(Messages.PlatformConfiguration_cannotRenameTempFile);
                throw (Throwable)new IOException(NLS.bind((String)Messages.cfig_unableToSave, (Object[])new String[]{file4.getAbsolutePath()}));
            }
        }
    }

    public static PlatformConfiguration getCurrent() {
        return currentPlatformConfiguration;
    }

    public static synchronized void startup(URL uRL, Location location) throws Exception {
        installURL = uRL;
        if (currentPlatformConfiguration == null) {
            currentPlatformConfiguration = new PlatformConfiguration(location);
            if (PlatformConfiguration.currentPlatformConfiguration.config == null) {
                throw (Throwable)new Exception(String.valueOf(Messages.PlatformConfiguration_cannotLoadConfig) + location.getURL());
            }
            if (PlatformConfiguration.currentPlatformConfiguration.config.isDirty() && !currentPlatformConfiguration.isTransient()) {
                currentPlatformConfiguration.save();
            }
        }
    }

    public static synchronized void shutdown() throws IOException {
        PlatformConfiguration platformConfiguration = PlatformConfiguration.getCurrent();
        if (platformConfiguration != null && platformConfiguration.config.isDirty() && !platformConfiguration.isTransient()) {
            try {
                platformConfiguration.save();
            }
            catch (IOException iOException) {
                Utils.debug("Unable to save configuration " + iOException.toString());
            }
        }
    }

    private synchronized void initializeCurrent(Location location) throws IOException {
        block16: {
            URL uRL;
            block18: {
                uRL = new URL(location.getURL(), CONFIG_NAME);
                this.getConfigurationLock(location.getURL());
                try {
                    try {
                        this.config = this.loadConfig(uRL);
                        Utils.debug("Using configuration " + uRL.toString());
                    }
                    catch (Exception exception) {
                        block14: {
                            block15: {
                                try {
                                    Location location2 = location.getParentLocation();
                                    if (location2 == null) {
                                        throw (Throwable)new IOException();
                                    }
                                    URL uRL2 = new URL(location2.getURL(), CONFIG_NAME);
                                    this.config = this.loadConfig(uRL2);
                                    if (!uRL2.equals(uRL)) {
                                        this.linkInitializedState(this.config, location2, location);
                                        Utils.debug("Configuration initialized from    " + uRL2.toString());
                                    }
                                    if (this.config == null) break block14;
                                    this.configLocation = uRL;
                                    if (this.config.getURL() != null) break block15;
                                    this.config.setURL(uRL);
                                }
                                catch (Exception exception2) {
                                    block17: {
                                        Utils.debug("Creating default configuration from " + uRL.toExternalForm());
                                        this.createDefaultConfiguration(uRL);
                                        if (this.config == null) break block16;
                                        this.configLocation = uRL;
                                        if (this.config.getURL() != null) break block17;
                                        this.config.setURL(uRL);
                                    }
                                    PlatformConfiguration.verifyPath(this.configLocation);
                                    Utils.debug("Creating configuration " + uRL.toString());
                                    break block16;
                                }
                            }
                            PlatformConfiguration.verifyPath(this.configLocation);
                            Utils.debug("Creating configuration " + uRL.toString());
                        }
                        this.clearConfigurationLock();
                        return;
                    }
                }
                finally {
                    if (this.config == null) break block16;
                }
                this.configLocation = uRL;
                if (this.config.getURL() != null) break block18;
                this.config.setURL(uRL);
            }
            PlatformConfiguration.verifyPath(this.configLocation);
            Utils.debug("Creating configuration " + uRL.toString());
            break block16;
            finally {
                this.clearConfigurationLock();
            }
        }
    }

    private void createDefaultConfiguration(URL uRL) throws IOException {
        this.config = new Configuration();
        this.config.setURL(uRL);
        SiteEntry siteEntry = (SiteEntry)this.getRootSite();
        this.configureSite(siteEntry);
        try {
            siteEntry.loadFromDisk(0L);
        }
        catch (CoreException coreException) {
            Utils.log(String.valueOf(Messages.PlatformConfiguration_cannotLoadDefaultSite) + siteEntry.getResolvedURL());
            return;
        }
    }

    private IPlatformConfiguration$ISiteEntry getRootSite() {
        IPlatformConfiguration$ISitePolicy iPlatformConfiguration$ISitePolicy = this.createSitePolicy(PlatformConfiguration.getDefaultPolicy(), DEFAULT_POLICY_LIST);
        URL uRL = null;
        try {
            uRL = new URL("platform:/base/");
        }
        catch (MalformedURLException malformedURLException) {
            uRL = PlatformConfiguration.getInstallURL();
        }
        IPlatformConfiguration$ISiteEntry iPlatformConfiguration$ISiteEntry = this.createSiteEntry(uRL, iPlatformConfiguration$ISitePolicy);
        return iPlatformConfiguration$ISiteEntry;
    }

    private void getConfigurationLock(URL uRL) {
        if (!uRL.getProtocol().equals("file")) {
            return;
        }
        File file = new File(uRL.getFile(), "org.eclipse.update" + File.separator + CONFIG_FILE_LOCK_SUFFIX);
        PlatformConfiguration.verifyPath(uRL);
        this.lock = PlatformConfiguration.createLocker(file);
        try {
            this.lock.lock();
        }
        catch (IOException iOException) {
            this.lock = null;
        }
    }

    private void clearConfigurationLock() {
        if (this.lock != null) {
            this.lock.release();
        }
    }

    private static Locker createLocker(File file) {
        if (!checkNio) {
            useNio = true;
            try {
                Class.forName("java.nio.channels.FileLock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                useNio = false;
            }
        }
        if (useNio) {
            return new Locker_JavaNio(file);
        }
        return new Locker_JavaIo(file);
    }

    private long computeChangeStamp() {
        this.featuresChangeStamp = this.computeFeaturesChangeStamp();
        this.pluginsChangeStamp = this.computePluginsChangeStamp();
        this.changeStamp = Math.max(this.featuresChangeStamp, this.pluginsChangeStamp);
        this.changeStamp = this.changeStamp / 1000L * 1000L;
        return this.changeStamp;
    }

    private long computeFeaturesChangeStamp() {
        if (this.featuresChangeStampIsValid) {
            return this.featuresChangeStamp;
        }
        long l = 0L;
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            l = Math.max(l, siteEntryArray[n].getFeaturesChangeStamp());
            ++n;
        }
        this.featuresChangeStamp = l;
        this.featuresChangeStampIsValid = true;
        return this.featuresChangeStamp;
    }

    private long computePluginsChangeStamp() {
        if (this.pluginsChangeStampIsValid) {
            return this.pluginsChangeStamp;
        }
        long l = 0L;
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            l = Math.max(l, siteEntryArray[n].getPluginsChangeStamp());
            ++n;
        }
        this.pluginsChangeStamp = l;
        this.pluginsChangeStampIsValid = true;
        return this.pluginsChangeStamp;
    }

    private void configureExternalLinks() {
        URL uRL = PlatformConfiguration.getInstallURL();
        if (!PlatformConfiguration.supportsDetection(uRL)) {
            return;
        }
        try {
            uRL = new URL(uRL, "links/");
        }
        catch (MalformedURLException malformedURLException) {
            Utils.debug("Unable to obtain link URL");
            return;
        }
        File file = new File(uRL.getFile());
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            Utils.debug("No links detected in " + uRL.toExternalForm());
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            block20: {
                if (!fileArray[n].isDirectory()) {
                    Utils.debug("Link file " + fileArray[n].getAbsolutePath());
                    Properties properties = new Properties();
                    FileInputStream fileInputStream = null;
                    try {
                        try {
                            fileInputStream = new FileInputStream(fileArray[n]);
                            properties.load(fileInputStream);
                            this.configureExternalLinkSite(fileArray[n], properties);
                        }
                        catch (IOException iOException) {
                            Utils.debug("   unable to load link file " + iOException);
                            if (fileInputStream != null) {
                                try {
                                    fileInputStream.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++n;
        }
    }

    private void validateSites() {
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            URL uRL = siteEntryArray[n].getResolvedURL();
            if (PlatformConfiguration.supportsDetection(uRL)) {
                File file;
                String string;
                File file2 = new File(uRL.getFile().replace('/', File.separatorChar));
                if (!file2.exists()) {
                    this.unconfigureSite(siteEntryArray[n]);
                    Utils.debug("Site " + uRL + " does not exist ... removing from configuration");
                }
                if ((string = siteEntryArray[n].getLinkFileName()) != null && !(file = new File(string)).exists()) {
                    this.unconfigureSite(siteEntryArray[n]);
                    this.config.setDirty(true);
                    Utils.debug("Site " + uRL + " is no longer linked ... removing from configuration");
                }
            }
            ++n;
        }
    }

    private Configuration loadConfig(URL uRL) throws Exception {
        if (uRL == null) {
            throw (Throwable)new IOException(Messages.cfig_unableToLoad_noURL);
        }
        ConfigurationParser configurationParser = null;
        try {
            configurationParser = new ConfigurationParser();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        this.config = null;
        Exception exception = null;
        try {
            this.config = configurationParser.parse(uRL);
            if (this.config == null) {
                throw (Throwable)new Exception(Messages.PlatformConfiguration_cannotFindConfigFile);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
            try {
                URL uRL2 = new URL(String.valueOf(uRL.toExternalForm()) + CONFIG_FILE_TEMP_SUFFIX);
                this.config = configurationParser.parse(uRL2);
                if (this.config == null) {
                    throw (Throwable)new Exception();
                }
                this.config.setDirty(true);
            }
            catch (Exception exception3) {
                try {
                    File[] fileArray;
                    File file;
                    File file2;
                    if ("file".equals(uRL.getProtocol()) && (file2 = (file = new File(uRL.getFile().replace('/', File.separatorChar))).getParentFile()) != null && file2.exists() && (fileArray = file2.listFiles(new PlatformConfiguration$1(this))) != null && fileArray.length > 0) {
                        URL uRL3 = fileArray[fileArray.length - 1].toURL();
                        this.config = configurationParser.parse(uRL3);
                    }
                    if (this.config == null) {
                        throw (Throwable)exception;
                    }
                    this.config.setDirty(true);
                }
                catch (IOException iOException) {
                    throw (Throwable)exception;
                }
            }
        }
        return this.config;
    }

    public static boolean supportsDetection(URL uRL) {
        String string = uRL.getProtocol();
        if (string.equals("file")) {
            return true;
        }
        if (string.equals("platform")) {
            URL uRL2 = null;
            try {
                uRL2 = PlatformConfiguration.resolvePlatformURL(uRL);
            }
            catch (IOException iOException) {
                return false;
            }
            return uRL2.getProtocol().equals("file");
        }
        return false;
    }

    private static void verifyPath(URL uRL) {
        Serializable serializable;
        String string = uRL.getProtocol();
        String string2 = null;
        if (string.equals("file")) {
            string2 = uRL.getFile();
        } else if (string.equals("platform")) {
            serializable = null;
            try {
                serializable = PlatformConfiguration.resolvePlatformURL(uRL);
                if (((URL)serializable).getProtocol().equals("file")) {
                    string2 = ((URL)serializable).getFile();
                }
            }
            catch (IOException iOException) {}
        }
        if (string2 != null && (serializable = new File(string2).getParentFile()) != null) {
            ((File)serializable).mkdirs();
        }
    }

    public static URL resolvePlatformURL(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("platform")) {
            uRL = FileLocator.toFileURL((URL)uRL);
            File file = new File(uRL.getFile());
            uRL = file.toURL();
        }
        return uRL;
    }

    public static URL getInstallURL() {
        return installURL;
    }

    private void saveAsXML(OutputStream outputStream) throws CoreException, IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, XML_ENCODING));
        try {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setExpandEntityReferences(false);
                documentBuilderFactory.setValidating(false);
                documentBuilderFactory.setIgnoringComments(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                if (this.config == null) {
                    throw (Throwable)Utils.newCoreException(Messages.PlatformConfiguration_cannotSaveNonExistingConfig, null);
                }
                this.config.setDate(new Date());
                Element element = this.config.toXML(document);
                document.appendChild(element);
                XMLPrintHandler.printNode(bufferedWriter, document, XML_ENCODING);
            }
            catch (Exception exception) {
                throw (Throwable)Utils.newCoreException("", exception);
            }
        }
        finally {
            bufferedWriter.flush();
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    PlatformConfiguration(URL uRL) throws Exception {
        this.initialize(uRL);
    }

    public IPlatformConfiguration$IFeatureEntry createFeatureEntry(String string, String string2, String string3, boolean bl, String string4, URL[] uRLArray) throws  {
        return PlatformConfiguration$$Cold.createFeatureEntry(this, string, string2, string3, bl, string4, uRLArray);
    }

    public IPlatformConfiguration$IFeatureEntry createFeatureEntry(String string, String string2, String string3, String string4, boolean bl, String string5, URL[] uRLArray) throws  {
        return PlatformConfiguration$$Cold.createFeatureEntry(this, string, string2, string3, string4, bl, string5, uRLArray);
    }

    public synchronized void unconfigureSite(IPlatformConfiguration$ISiteEntry iPlatformConfiguration$ISiteEntry) {
        if (iPlatformConfiguration$ISiteEntry == null) {
            return;
        }
        URL uRL = iPlatformConfiguration$ISiteEntry.getURL();
        if (uRL == null) {
            return;
        }
        String string = uRL.toExternalForm();
        if (iPlatformConfiguration$ISiteEntry instanceof SiteEntry) {
            this.config.removeSiteEntry(string);
        }
    }

    public SiteEntry findConfiguredSite(URL uRL, boolean bl) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm();
        SiteEntry siteEntry = this.config.getSiteEntry(string);
        if (siteEntry == null) {
            try {
                string = UpdateURLDecoder.decode(string, XML_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            siteEntry = this.config.getSiteEntry(string);
        }
        if (siteEntry == null && bl) {
            try {
                siteEntry = this.findConfiguredSite(this.config.asPlatformURL(uRL), false);
            }
            catch (Exception exception) {}
        }
        return siteEntry;
    }

    public synchronized void configureFeatureEntry(IPlatformConfiguration$IFeatureEntry iPlatformConfiguration$IFeatureEntry) {
        if (iPlatformConfiguration$IFeatureEntry == null) {
            return;
        }
        String string = iPlatformConfiguration$IFeatureEntry.getFeatureIdentifier();
        if (string == null) {
            return;
        }
        if (this.config == null) {
            this.config = new Configuration();
        }
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            try {
                URL uRL = new URL(siteEntryArray[n].getURL(), "features/" + iPlatformConfiguration$IFeatureEntry.getFeatureIdentifier() + "_" + iPlatformConfiguration$IFeatureEntry.getFeatureVersion() + "/");
                if (new File(uRL.getFile()).exists()) {
                    siteEntryArray[n].addFeatureEntry(iPlatformConfiguration$IFeatureEntry);
                } else {
                    uRL = new URL(siteEntryArray[n].getURL(), "features/" + iPlatformConfiguration$IFeatureEntry.getFeatureIdentifier() + "/");
                    if (new File(uRL.getFile()).exists()) {
                        siteEntryArray[n].addFeatureEntry(iPlatformConfiguration$IFeatureEntry);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {}
            ++n;
        }
    }

    public synchronized void unconfigureFeatureEntry(IPlatformConfiguration$IFeatureEntry iPlatformConfiguration$IFeatureEntry) {
        if (iPlatformConfiguration$IFeatureEntry == null) {
            return;
        }
        String string = iPlatformConfiguration$IFeatureEntry.getFeatureIdentifier();
        if (string == null) {
            return;
        }
        this.config.unconfigureFeatureEntry(iPlatformConfiguration$IFeatureEntry);
    }

    public IPlatformConfiguration$IFeatureEntry[] getConfiguredFeatureEntries() {
        ArrayList<FeatureEntry> arrayList = new ArrayList<FeatureEntry>();
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            FeatureEntry[] featureEntryArray = siteEntryArray[n].getFeatureEntries();
            int n2 = 0;
            while (n2 < featureEntryArray.length) {
                arrayList.add(featureEntryArray[n2]);
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new FeatureEntry[arrayList.size()]);
    }

    public IPlatformConfiguration$IFeatureEntry findConfiguredFeatureEntry(String string) {
        if (string == null) {
            return null;
        }
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            FeatureEntry featureEntry = siteEntryArray[n].getFeatureEntry(string);
            if (featureEntry != null) {
                return featureEntry;
            }
            ++n;
        }
        return null;
    }

    public String getApplicationIdentifier() throws  {
        return PlatformConfiguration$$Cold.getApplicationIdentifier(this);
    }

    public String getPrimaryFeatureIdentifier() throws  {
        return PlatformConfiguration$$Cold.getPrimaryFeatureIdentifier(this);
    }

    public Set getPluginPaths() throws  {
        return PlatformConfiguration$$Cold.getPluginPaths(this);
    }

    public PluginEntry[] getPlugins() throws  {
        return PlatformConfiguration$$Cold.getPlugins(this);
    }

    public void isTransient(boolean bl) {
        if (this != PlatformConfiguration.getCurrent() && this.config != null) {
            this.config.setTransient(bl);
        }
    }

    public synchronized void refresh() throws  {
        PlatformConfiguration$$Cold.refresh(this);
    }

    private synchronized void initialize(URL uRL) throws Exception {
        if (uRL != null) {
            this.config = this.loadConfig(uRL);
            Utils.debug("Using configuration " + uRL.toString());
        }
        if (this.config == null) {
            this.config = new Configuration();
            Utils.debug("Creating empty configuration object");
        }
        this.config.setURL(uRL);
        this.configLocation = uRL;
    }

    private void configureExternalLinkSite(File file, Properties properties) {
        URL uRL;
        Object object;
        String string;
        String string2 = properties.getProperty(LINK_PATH);
        if (string2 == null) {
            Utils.debug("   no path definition");
            return;
        }
        boolean bl = true;
        if (string2.startsWith("r ")) {
            bl = false;
            string = string2.substring(2).trim();
        } else {
            string = string2.startsWith("rw ") ? string2.substring(3).trim() : string2.trim();
        }
        try {
            object = new File(string);
            object = new File((File)object, ECLIPSE);
            uRL = ((File)object).toURL();
            if (this.findConfiguredSite(uRL, true) != null) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Utils.debug("  bad URL " + malformedURLException);
            return;
        }
        object = (SiteEntry)this.externalLinkSites.get(uRL);
        if (object == null) {
            IPlatformConfiguration$ISitePolicy iPlatformConfiguration$ISitePolicy = this.createSitePolicy(PlatformConfiguration.getDefaultPolicy(), DEFAULT_POLICY_LIST);
            object = (SiteEntry)this.createSiteEntry(uRL, iPlatformConfiguration$ISitePolicy);
        }
        ((SiteEntry)object).setUpdateable(bl);
        ((SiteEntry)object).setLinkFileName(file.getAbsolutePath());
        this.configureSite((IPlatformConfiguration$ISiteEntry)object);
        this.config.setDirty(true);
        Utils.debug("   " + (bl ? "R/W -> " : "R/O -> ") + uRL.toString());
    }

    private void linkInitializedState(Configuration configuration, Location location, Location location2) {
        try {
            URL uRL = new URL(location2.getURL(), CONFIG_INI);
            if (!uRL.getProtocol().equals("file")) {
                return;
            }
            File file = new File(uRL.getFile());
            Properties properties = new Properties();
            String string = Utils.makeRelative(Utils.getInstallURL(), location.getURL()).toExternalForm();
            properties.put("osgi.sharedConfiguration.area", string);
            properties.store(new FileOutputStream(file), "Linked configuration");
            this.config = new Configuration(new Date());
            this.config.setURL(new URL(location2.getURL(), CONFIG_NAME));
            this.config.setLinkedConfig(configuration);
            this.config.setDirty(true);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void reconcile() throws CoreException {
        long l = this.config.getDate().getTime();
        SiteEntry[] siteEntryArray = this.config.getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            long l2;
            if (siteEntryArray[n].isUpdateable() && (l2 = siteEntryArray[n].getChangeStamp()) > l) {
                siteEntryArray[n].loadFromDisk(l);
            }
            ++n;
        }
        this.config.setDirty(true);
    }
}

