/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.chat.ui.action;

import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.meeting.CollaborationMeeting;
import com.ibm.team.collaboration.core.meeting.MeetingInvitationRequest;
import com.ibm.team.collaboration.core.service.CollaborationServiceJob;
import com.ibm.team.collaboration.core.service.ICollaborationService;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.core.session.CollaborationUser;
import com.ibm.team.collaboration.internal.chat.ui.ChatMessages;
import com.ibm.team.collaboration.internal.chat.ui.CollaborationChatPlugin;
import com.ibm.team.collaboration.internal.ui.util.CollaborationExceptionHandler;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class InviteContributorsAction
extends Action {
    final CollaborationMeeting fMeeting;

    public InviteContributorsAction(CollaborationMeeting meeting) {
        super(ChatMessages.InviteContributorsAction_0);
        Assert.isNotNull((Object)meeting);
        this.fMeeting = meeting;
        this.setDescription(ChatMessages.InviteContributorsAction_1);
        this.setToolTipText(ChatMessages.InviteContributorsAction_2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.team.collaboration.ui.invite_contributors");
    }

    public void run() {
        Shell shell;
        ITeamRepository repository;
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (part = page.getActivePart()) != null && (repository = CollaborationChatPlugin.selectTeamRepository(shell = window.getShell())) != null) {
            IContributorHandle[] handles;
            Collection participants = this.fMeeting.getParticipants();
            ArrayList<IContributorHandle> collection = new ArrayList<IContributorHandle>(participants.size());
            for (CollaborationUser participant : participants) {
                IContributorHandle contributorHandle = participant.getContributor();
                if (contributorHandle == null) continue;
                collection.add(contributorHandle);
            }
            TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(shell, repository, collection, true);
            dialog.setTitle(ChatMessages.InviteContributorsAction_3);
            dialog.setSeparatorLabel(ChatMessages.InviteContributorsAction_6);
            dialog.create();
            dialog.setMessage(ChatMessages.InviteContributorsAction_4);
            dialog.getShell().setText(ChatMessages.InviteContributorsAction_8);
            if (dialog.open() == 0 && (handles = dialog.getContributorResult()).length != 0) {
                final ICollaborationService service = CollaborationCore.getCollaborationService();
                service.scheduleJob(new CollaborationServiceJob(){

                    public String getName() {
                        return ChatMessages.InviteContributorsAction_5;
                    }

                    public boolean isSystem() {
                        return false;
                    }

                    public boolean isUser() {
                        return true;
                    }

                    public IStatus run(IProgressMonitor monitor) {
                        Assert.isNotNull((Object)monitor);
                        ArrayList<CollaborationUser> users = new ArrayList<CollaborationUser>(handles.length);
                        IContributorHandle[] iContributorHandleArray = handles;
                        int n = handles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContributorHandle handle = iContributorHandleArray[n2];
                            users.add(service.getUser(handle));
                            CollaborationPresenceStatus status = service.getPresenceStatus(handle, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 2));
                            if (!status.isActive()) {
                                return CollaborationExceptionHandler.handleErrorStatus((IStatus)new Status(4, "com.ibm.team.collaboration.chat.rcp.ui", 13, ChatMessages.InviteContributorsAction_7, null));
                            }
                            ++n2;
                        }
                        return CollaborationExceptionHandler.handleErrorStatus((IStatus)InviteContributorsAction.this.fMeeting.invite(new MeetingInvitationRequest(users, false), monitor));
                    }
                });
            }
        }
    }
}

