/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.NDC$DiagnosticContext;
import org.apache.log4j.helpers.LogLog;

public class NDC {
    static Hashtable ht = new Hashtable();
    static int pushCounter = 0;
    static final int REAP_THRESHOLD = 5;

    private NDC() {
    }

    public static void clear() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null) {
            ((Vector)stack).setSize(0);
        }
    }

    public static Stack cloneStack() {
        Object v = ht.get(Thread.currentThread());
        if (v == null) {
            return null;
        }
        Stack stack = (Stack)v;
        return (Stack)((Vector)stack).clone();
    }

    public static String get() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && !((Vector)stack).isEmpty()) {
            return ((NDC$DiagnosticContext)stack.peek()).fullMessage;
        }
        return null;
    }

    public static int getDepth() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack == null) {
            return 0;
        }
        return ((Vector)stack).size();
    }

    public static void inherit(Stack stack) {
        if (stack != null) {
            ht.put(Thread.currentThread(), stack);
        }
    }

    private static void lazyRemove() {
        Vector<Thread> vector;
        Hashtable hashtable = ht;
        synchronized (hashtable) {
            if (++pushCounter <= 5) {
                return;
            }
            pushCounter = 0;
            int n = 0;
            vector = new Vector<Thread>();
            Enumeration enumeration = ht.keys();
            while (enumeration.hasMoreElements() && n <= 4) {
                Thread thread = (Thread)enumeration.nextElement();
                if (thread.isAlive()) {
                    ++n;
                    continue;
                }
                n = 0;
                vector.addElement(thread);
            }
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Thread thread = (Thread)vector.elementAt(n2);
            LogLog.debug("Lazy NDC removal for thread [" + thread.getName() + "] (" + ht.size() + ").");
            ht.remove(thread);
            ++n2;
        }
    }

    public static String peek() {
        Thread thread = Thread.currentThread();
        Stack stack = (Stack)ht.get(thread);
        if (stack != null && !((Vector)stack).isEmpty()) {
            return ((NDC$DiagnosticContext)stack.peek()).message;
        }
        return "";
    }

    public static String pop() {
        Thread thread = Thread.currentThread();
        Stack stack = (Stack)ht.get(thread);
        if (stack != null && !((Vector)stack).isEmpty()) {
            return ((NDC$DiagnosticContext)stack.pop()).message;
        }
        return "";
    }

    public static void push(String string) {
        Thread thread = Thread.currentThread();
        Stack<NDC$DiagnosticContext> stack = (Stack<NDC$DiagnosticContext>)ht.get(thread);
        if (stack == null) {
            NDC$DiagnosticContext nDC$DiagnosticContext = new NDC$DiagnosticContext(string, null);
            stack = new Stack<NDC$DiagnosticContext>();
            ht.put(thread, stack);
            stack.push(nDC$DiagnosticContext);
        } else if (((Vector)stack).isEmpty()) {
            NDC$DiagnosticContext nDC$DiagnosticContext = new NDC$DiagnosticContext(string, null);
            stack.push(nDC$DiagnosticContext);
        } else {
            NDC$DiagnosticContext nDC$DiagnosticContext = (NDC$DiagnosticContext)stack.peek();
            stack.push(new NDC$DiagnosticContext(string, nDC$DiagnosticContext));
        }
    }

    public static void remove() {
        ht.remove(Thread.currentThread());
        NDC.lazyRemove();
    }

    public static void setMaxDepth(int n) {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && n < ((Vector)stack).size()) {
            ((Vector)stack).setSize(n);
        }
    }
}

