/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;
import org.apache.log4j.CategoryKey;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.ProvisionNode;
import org.apache.log4j.helpers.LogLog;

public class Hierarchy$$Cold {
    public static void emitNoAppenderWarning(Hierarchy hierarchy, Category category) {
        if (!hierarchy.emittedNoAppenderWarning) {
            LogLog.warn("No appenders could be found for logger (" + category.getName() + ").");
            LogLog.warn("Please initialize the log4j system properly.");
            hierarchy.emittedNoAppenderWarning = true;
        }
    }

    public static Logger exists(Hierarchy hierarchy, String string) {
        Object v = hierarchy.ht.get(new CategoryKey(string));
        if (v instanceof Logger) {
            return (Logger)v;
        }
        return null;
    }

    public static Enumeration getCurrentLoggers(Hierarchy hierarchy) {
        Vector vector = new Vector(hierarchy.ht.size());
        Enumeration enumeration = hierarchy.ht.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof Logger)) continue;
            vector.addElement(v);
        }
        return vector.elements();
    }

    public static void resetConfiguration(Hierarchy hierarchy) {
        ((Category)hierarchy.getRootLogger()).setLevel(Level.DEBUG);
        ((Category)hierarchy.root).setResourceBundle(null);
        hierarchy.setThreshold(Level.ALL);
        Hashtable hashtable = hierarchy.ht;
        synchronized (hashtable) {
            hierarchy.shutdown();
            Enumeration enumeration = hierarchy.getCurrentLoggers();
            while (enumeration.hasMoreElements()) {
                Logger logger = (Logger)enumeration.nextElement();
                ((Category)logger).setLevel(null);
                ((Category)logger).setAdditivity(true);
                ((Category)logger).setResourceBundle(null);
            }
        }
        hierarchy.rendererMap.clear();
    }

    public static void setThreshold(Hierarchy hierarchy, String string) {
        Level level = Level.toLevel(string, null);
        if (level != null) {
            hierarchy.setThreshold(level);
        } else {
            LogLog.warn("Could not convert [" + string + "] to Level.");
        }
    }

    public static void shutdown(Hierarchy hierarchy) {
        Logger logger = hierarchy.getRootLogger();
        ((Category)logger).closeNestedAppenders();
        Hashtable hashtable = hierarchy.ht;
        synchronized (hashtable) {
            Logger logger2;
            Enumeration enumeration = hierarchy.getCurrentLoggers();
            while (enumeration.hasMoreElements()) {
                logger2 = (Logger)enumeration.nextElement();
                ((Category)logger2).closeNestedAppenders();
            }
            ((Category)logger).removeAllAppenders();
            enumeration = hierarchy.getCurrentLoggers();
            while (enumeration.hasMoreElements()) {
                logger2 = (Logger)enumeration.nextElement();
                ((Category)logger2).removeAllAppenders();
            }
        }
    }

    public static final void updateChildren(Hierarchy hierarchy, ProvisionNode provisionNode, Logger logger) {
        int n = ((Vector)provisionNode).size();
        int n2 = 0;
        while (n2 < n) {
            Logger logger2 = (Logger)((Vector)provisionNode).elementAt(n2);
            if (!((Category)logger2).parent.name.startsWith(((Category)logger).name)) {
                ((Category)logger).parent = ((Category)logger2).parent;
                ((Category)logger2).parent = logger;
            }
            ++n2;
        }
    }
}

