/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Category$$Cold;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class Category
implements AppenderAttachable {
    protected String name;
    protected volatile Level level;
    protected volatile Category parent;
    private static final String FQCN = (class$org$apache$log4j$Category != null ? class$org$apache$log4j$Category : (class$org$apache$log4j$Category = Category.class$("org.apache.log4j.Category"))).getName();
    protected ResourceBundle resourceBundle;
    protected LoggerRepository repository;
    AppenderAttachableImpl aai;
    protected boolean additive = true;
    static Class class$org$apache$log4j$Category;

    protected Category(String string) {
        this.name = string;
    }

    public void assertLog(boolean bl, String string) {
        if (!bl) {
            this.error(string);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
        }
    }

    public static Logger exists(String string) {
        return LogManager.exists(string);
    }

    public boolean getAdditivity() {
        return this.additive;
    }

    public static Enumeration getCurrentCategories() {
        return LogManager.getCurrentLoggers();
    }

    public static LoggerRepository getDefaultHierarchy() {
        return LogManager.getLoggerRepository();
    }

    public LoggerRepository getHierarchy() {
        return this.repository;
    }

    public static Category getInstance(Class clazz) {
        return LogManager.getLogger(clazz);
    }

    public static Category getInstance(String string) {
        return LogManager.getLogger(string);
    }

    public final Level getLevel() {
        return this.level;
    }

    public LoggerRepository getLoggerRepository() {
        return this.repository;
    }

    public final String getName() {
        return this.name;
    }

    public final Category getParent() {
        return this.parent;
    }

    public final Level getPriority() {
        return this.level;
    }

    public static final Category getRoot() {
        return LogManager.getRootLogger();
    }

    public void setAdditivity(boolean bl) {
        this.additive = bl;
    }

    final void setHierarchy(LoggerRepository loggerRepository) {
        this.repository = loggerRepository;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setPriority(Priority priority) {
        this.level = (Level)priority;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public static void shutdown() {
        LogManager.shutdown();
    }

    public synchronized void addAppender(Appender appender) throws  {
        Category$$Cold.addAppender(this, appender);
    }

    public void callAppenders(LoggingEvent loggingEvent) throws  {
        Category$$Cold.callAppenders(this, loggingEvent);
    }

    synchronized void closeNestedAppenders() throws  {
        Category$$Cold.closeNestedAppenders(this);
    }

    public void debug(Object object) {
        if (this.repository.isDisabled(10000)) {
            return;
        }
        if (((Priority)Level.DEBUG).isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.DEBUG, object, null);
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (this.repository.isDisabled(10000)) {
            return;
        }
        if (((Priority)Level.DEBUG).isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.DEBUG, object, throwable);
        }
    }

    public void error(Object object) {
        if (this.repository.isDisabled(40000)) {
            return;
        }
        if (((Priority)Level.ERROR).isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.ERROR, object, null);
        }
    }

    public void error(Object object, Throwable throwable) {
        if (this.repository.isDisabled(40000)) {
            return;
        }
        if (((Priority)Level.ERROR).isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.ERROR, object, throwable);
        }
    }

    public void fatal(Object object) {
        if (this.repository.isDisabled(50000)) {
            return;
        }
        if (((Priority)Level.FATAL).isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.FATAL, object, null);
        }
    }

    public void fatal(Object object, Throwable throwable) {
        if (this.repository.isDisabled(50000)) {
            return;
        }
        if (((Priority)Level.FATAL).isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.FATAL, object, throwable);
        }
    }

    protected void forcedLog(String string, Priority priority, Object object, Throwable throwable) throws  {
        Category$$Cold.forcedLog(this, string, priority, object, throwable);
    }

    public synchronized Enumeration getAllAppenders() throws  {
        return Category$$Cold.getAllAppenders(this);
    }

    public synchronized Appender getAppender(String string) throws  {
        return Category$$Cold.getAppender(this, string);
    }

    public Priority getChainedPriority() throws  {
        return Category$$Cold.getChainedPriority(this);
    }

    public Level getEffectiveLevel() throws  {
        return Category$$Cold.getEffectiveLevel(this);
    }

    public ResourceBundle getResourceBundle() throws  {
        return Category$$Cold.getResourceBundle(this);
    }

    protected String getResourceBundleString(String string) throws  {
        return Category$$Cold.getResourceBundleString(this, string);
    }

    public void info(Object object) {
        if (this.repository.isDisabled(20000)) {
            return;
        }
        if (((Priority)Level.INFO).isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.INFO, object, null);
        }
    }

    public void info(Object object, Throwable throwable) {
        if (this.repository.isDisabled(20000)) {
            return;
        }
        if (((Priority)Level.INFO).isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.INFO, object, throwable);
        }
    }

    public boolean isAttached(Appender appender) throws  {
        return Category$$Cold.isAttached(this, appender);
    }

    public boolean isDebugEnabled() throws  {
        return Category$$Cold.isDebugEnabled(this);
    }

    public boolean isEnabledFor(Priority priority) throws  {
        return Category$$Cold.isEnabledFor(this, priority);
    }

    public boolean isInfoEnabled() throws  {
        return Category$$Cold.isInfoEnabled(this);
    }

    public void l7dlog(Priority priority, String string, Throwable throwable) {
        if (this.repository.isDisabled(priority.level)) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getEffectiveLevel())) {
            String string2 = this.getResourceBundleString(string);
            if (string2 == null) {
                string2 = string;
            }
            this.forcedLog(FQCN, priority, string2, throwable);
        }
    }

    public void l7dlog(Priority priority, String string, Object[] objectArray, Throwable throwable) {
        if (this.repository.isDisabled(priority.level)) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getEffectiveLevel())) {
            String string2 = this.getResourceBundleString(string);
            String string3 = string2 == null ? string : MessageFormat.format(string2, objectArray);
            this.forcedLog(FQCN, priority, string3, throwable);
        }
    }

    public void log(String string, Priority priority, Object object, Throwable throwable) throws  {
        Category$$Cold.log(this, string, priority, object, throwable);
    }

    public void log(Priority priority, Object object) {
        if (this.repository.isDisabled(priority.level)) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, priority, object, null);
        }
    }

    public void log(Priority priority, Object object, Throwable throwable) {
        if (this.repository.isDisabled(priority.level)) {
            return;
        }
        if (priority.isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, priority, object, throwable);
        }
    }

    public synchronized void removeAllAppenders() throws  {
        Category$$Cold.removeAllAppenders(this);
    }

    public synchronized void removeAppender(String string) throws  {
        Category$$Cold.removeAppender(this, string);
    }

    public synchronized void removeAppender(Appender appender) throws  {
        Category$$Cold.removeAppender(this, appender);
    }

    public void warn(Object object) {
        if (this.repository.isDisabled(30000)) {
            return;
        }
        if (((Priority)Level.WARN).isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.WARN, object, null);
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (this.repository.isDisabled(30000)) {
            return;
        }
        if (((Priority)Level.WARN).isGreaterOrEqual(this.getEffectiveLevel())) {
            this.forcedLog(FQCN, Level.WARN, object, throwable);
        }
    }
}

