/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LoggingEvent;

public class Category$$Cold {
    public static void addAppender(Category category, Appender appender) {
        if (category.aai == null) {
            category.aai = new AppenderAttachableImpl();
        }
        category.aai.addAppender(appender);
        category.repository.fireAddAppenderEvent(category, appender);
    }

    public static void callAppenders(Category category, LoggingEvent loggingEvent) {
        int n = 0;
        Category category2 = category;
        while (category2 != null) {
            Category category3 = category2;
            synchronized (category3) {
                if (category2.aai != null) {
                    n += category2.aai.appendLoopOnAppenders(loggingEvent);
                }
                if (!category2.additive) {
                    break;
                }
            }
            category2 = category2.parent;
        }
        if (n == 0) {
            category.repository.emitNoAppenderWarning(category);
        }
    }

    public static void closeNestedAppenders(Category category) {
        Enumeration enumeration = category.getAllAppenders();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Appender appender = (Appender)enumeration.nextElement();
                if (!(appender instanceof AppenderAttachable)) continue;
                appender.close();
            }
        }
    }

    public static void forcedLog(Category category, String string, Priority priority, Object object, Throwable throwable) {
        category.callAppenders(new LoggingEvent(string, category, priority, object, throwable));
    }

    public static Enumeration getAllAppenders(Category category) {
        if (category.aai == null) {
            return NullEnumeration.getInstance();
        }
        return category.aai.getAllAppenders();
    }

    public static Appender getAppender(Category category, String string) {
        if (category.aai == null || string == null) {
            return null;
        }
        return category.aai.getAppender(string);
    }

    public static Priority getChainedPriority(Category category) {
        Category category2 = category;
        while (category2 != null) {
            if (category2.level != null) {
                return category2.level;
            }
            category2 = category2.parent;
        }
        return null;
    }

    public static Level getEffectiveLevel(Category category) {
        Category category2 = category;
        while (category2 != null) {
            if (category2.level != null) {
                return category2.level;
            }
            category2 = category2.parent;
        }
        return null;
    }

    public static ResourceBundle getResourceBundle(Category category) {
        Category category2 = category;
        while (category2 != null) {
            if (category2.resourceBundle != null) {
                return category2.resourceBundle;
            }
            category2 = category2.parent;
        }
        return null;
    }

    public static String getResourceBundleString(Category category, String string) {
        ResourceBundle resourceBundle = category.getResourceBundle();
        if (resourceBundle == null) {
            return null;
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            category.error("No resource is associated with key \"" + string + "\".");
            return null;
        }
    }

    public static boolean isAttached(Category category, Appender appender) {
        if (appender == null || category.aai == null) {
            return false;
        }
        return category.aai.isAttached(appender);
    }

    public static boolean isDebugEnabled(Category category) {
        if (category.repository.isDisabled(10000)) {
            return false;
        }
        return ((Priority)Level.DEBUG).isGreaterOrEqual(category.getEffectiveLevel());
    }

    public static boolean isEnabledFor(Category category, Priority priority) {
        if (category.repository.isDisabled(priority.level)) {
            return false;
        }
        return priority.isGreaterOrEqual(category.getEffectiveLevel());
    }

    public static boolean isInfoEnabled(Category category) {
        if (category.repository.isDisabled(20000)) {
            return false;
        }
        return ((Priority)Level.INFO).isGreaterOrEqual(category.getEffectiveLevel());
    }

    public static void log(Category category, String string, Priority priority, Object object, Throwable throwable) {
        if (category.repository.isDisabled(priority.level)) {
            return;
        }
        if (priority.isGreaterOrEqual(category.getEffectiveLevel())) {
            category.forcedLog(string, priority, object, throwable);
        }
    }

    public static void removeAllAppenders(Category category) {
        if (category.aai != null) {
            category.aai.removeAllAppenders();
            category.aai = null;
        }
    }

    public static void removeAppender(Category category, String string) {
        if (string == null || category.aai == null) {
            return;
        }
        category.aai.removeAppender(string);
    }

    public static void removeAppender(Category category, Appender appender) {
        if (appender == null || category.aai == null) {
            return;
        }
        category.aai.removeAppender(appender);
    }
}

