/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.core.utils;

import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.rcp.core.internal.Messages;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public final class StreamReference
implements IInputStreamProvider,
DisposableInputStreamProvider {
    private Root root;

    private StreamReference(Root root) {
        this.root = root;
    }

    public IInputStreamProvider getOriginal() {
        return this.root.streamProvider;
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException {
        this.checkState();
        return this.root.streamProvider.getInputStream(monitor);
    }

    public static StreamReference create(IInputStreamProvider isp) {
        if (isp instanceof StreamReference) {
            StreamReference sr = (StreamReference)isp;
            return sr.incRef();
        }
        Root newRoot = new Root(isp);
        return new StreamReference(newRoot);
    }

    public StreamReference incRef() {
        this.checkState();
        this.root.incRef();
        return new StreamReference(this.root);
    }

    public void dispose() throws IOException {
        if (this.root == null) {
            return;
        }
        this.root.decRef();
        this.root = null;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void checkState() {
        if (this.root == null) {
            throw new IllegalStateException(Messages.StreamReference_0);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StreamReference other = (StreamReference)obj;
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }

    private static class Root {
        IInputStreamProvider streamProvider;
        private int refCount = 1;

        private Root(IInputStreamProvider streamProvider) {
            this.streamProvider = streamProvider;
        }

        synchronized void incRef() {
            ++this.refCount;
        }

        synchronized void decRef() throws IOException {
            if (this.refCount > 0) {
                --this.refCount;
                if (this.refCount == 0) {
                    try {
                        if (this.streamProvider instanceof DisposableInputStreamProvider) {
                            DisposableInputStreamProvider dis = (DisposableInputStreamProvider)this.streamProvider;
                            dis.dispose();
                        }
                    }
                    finally {
                        this.streamProvider = null;
                    }
                }
            }
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.streamProvider == null ? 0 : this.streamProvider.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Root other = (Root)obj;
            return !(this.streamProvider == null ? other.streamProvider != null : !this.streamProvider.equals(other.streamProvider));
        }
    }
}

