/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.core.preferences;

import com.ibm.team.repository.rcp.core.internal.PrefSerializableRegistry;
import com.ibm.team.repository.rcp.core.operations.IStatusCollector;
import com.ibm.team.repository.rcp.core.preferences.IPrefSerializable;
import com.ibm.team.repository.rcp.core.preferences.SerializationContext;
import com.ibm.team.repository.rcp.core.utils.ClassIdentifier;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefSerializableUtil {
    private static final String ATT_CLASSNAME = "prefserializable.classname";
    private static final String ATT_BUNDLE = "prefserializable.bundle";

    public void saveList(SerializationContext prefs, List<? extends IPrefSerializable> toSave, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)toSave.size());
        int counter = 0;
        for (IPrefSerializable iPrefSerializable : toSave) {
            SerializationContext child = prefs.node("" + counter++);
            PrefSerializableUtil.saveNode(child, iPrefSerializable, (IProgressMonitor)progress.newChild(1));
        }
    }

    public static <T> List<T> loadList(SerializationContext prefs, Class<T> elementType, IProgressMonitor monitor) throws CoreException {
        final CoreException[] toThrow = new CoreException[1];
        IStatusCollector statusCollector = new IStatusCollector(){

            public void reportProblem(IStatus toReport) {
                if (toThrow[0] == null && toReport.getException() instanceof CoreException) {
                    toThrow[0] = (CoreException)toReport.getException();
                }
            }
        };
        List<T> result = PrefSerializableUtil.loadList(prefs, elementType, statusCollector, monitor);
        if (toThrow[0] != null) {
            throw toThrow[0];
        }
        return result;
    }

    public static <T> List<T> loadList(SerializationContext prefs, Class<T> elementType, IStatusCollector problems, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)prefs.getPrefs().childrenNames().length);
            ArrayList<T> result = new ArrayList<T>();
            int counter = 0;
            while (true) {
                String nodeName = "" + counter++;
                if (!prefs.getPrefs().nodeExists(nodeName)) break;
                SerializationContext node = prefs.node(nodeName);
                try {
                    result.add(PrefSerializableUtil.loadNode(node, elementType, (IProgressMonitor)progress.newChild(1)));
                }
                catch (CoreException e) {
                    problems.reportProblem(StatusUtil.newStatus(PrefSerializableUtil.class, e));
                }
            }
            return result;
        }
        catch (BackingStoreException e1) {
            throw new CoreException(StatusUtil.newStatus(PrefSerializableUtil.class, e1));
        }
    }

    public static <T> T loadNode(SerializationContext node, Class<T> expectedType, IProgressMonitor monitor) throws CoreException {
        String className = node.getPrefs().get(ATT_CLASSNAME, "");
        ClassIdentifier classId = PrefSerializableRegistry.lookupClass(className);
        try {
            Class clazz = classId.loadClass();
            if (!expectedType.isAssignableFrom(clazz)) {
                throw new CoreException(StatusUtil.newStatus(PrefSerializableUtil.class, NLS.bind((String)"Expecting object of type {0}, but found type {1}", (Object)expectedType.getName(), (Object)clazz.getName())));
            }
            Constructor constructor = clazz.getDeclaredConstructor(SerializationContext.class, IProgressMonitor.class);
            return constructor.newInstance(node, monitor);
        }
        catch (Exception e) {
            throw new CoreException(StatusUtil.newStatus(PrefSerializableUtil.class, e));
        }
    }

    public static void saveNode(SerializationContext prefs, IPrefSerializable toSave, IProgressMonitor monitor) throws CoreException {
        ClassIdentifier classId = new ClassIdentifier(toSave.getClass());
        String className = PrefSerializableRegistry.lookupName(classId);
        prefs.getPrefs().put(ATT_CLASSNAME, className);
        toSave.save(prefs, monitor);
    }
}

