/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.workitem.common.internal.model.ApprovalState;
import com.ibm.team.workitem.common.internal.model.ApprovalType;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.Messages;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemApprovals {
    public static final IApprovalType APPROVAL_TYPE = new ApprovalType("com.ibm.team.workitem.approvalType.approval", Messages.getString("WorkItemApprovals.APPROVAL_TYPE"), WorkItemApprovals.createURL("icons/obj16/appr_generic.gif"));
    public static final IApprovalType REVIEW_TYPE = new ApprovalType("com.ibm.team.workitem.approvalType.review", Messages.getString("WorkItemApprovals.REVIEW_TYPE"), WorkItemApprovals.createURL("icons/obj16/appr_review.gif"));
    public static final IApprovalType VERIFICATION_TYPE = new ApprovalType("com.ibm.team.workitem.approvalType.verification", Messages.getString("WorkItemApprovals.VERIFICATION_TYPE"), WorkItemApprovals.createURL("icons/obj16/appr_verification.gif"));
    public static final IApprovalState PENDING_STATE = new ApprovalState("com.ibm.team.workitem.approvalState.pending", Messages.getString("WorkItemApprovals.PENDING_STATE"), WorkItemApprovals.createURL("icons/obj16/appr_pending.gif"));
    public static final IApprovalState APPROVED_STATE = new ApprovalState("com.ibm.team.workitem.approvalState.approved", Messages.getString("WorkItemApprovals.APPROVED_STATE"), WorkItemApprovals.createURL("icons/obj16/appr_approved.gif"));
    public static final IApprovalState REJECTED_STATE = new ApprovalState("com.ibm.team.workitem.approvalState.rejected", Messages.getString("WorkItemApprovals.REJECTED_STATE"), WorkItemApprovals.createURL("icons/obj16/appr_rejected.gif"));
    private static Map<String, IApprovalType> fgTypesMap = new HashMap<String, IApprovalType>();
    private static List<IApprovalType> fgTypes = new ArrayList<IApprovalType>();
    private static Map<String, IApprovalState> fgStatesMap = new HashMap<String, IApprovalState>();
    private static List<IApprovalState> fgStates = new ArrayList<IApprovalState>();

    static {
        WorkItemApprovals.add(APPROVAL_TYPE.getIdentifier(), APPROVAL_TYPE);
        WorkItemApprovals.add(REVIEW_TYPE.getIdentifier(), REVIEW_TYPE);
        WorkItemApprovals.add(VERIFICATION_TYPE.getIdentifier(), VERIFICATION_TYPE);
        WorkItemApprovals.add(APPROVED_STATE.getIdentifier(), APPROVED_STATE);
        WorkItemApprovals.add(REJECTED_STATE.getIdentifier(), REJECTED_STATE);
        WorkItemApprovals.add(PENDING_STATE.getIdentifier(), PENDING_STATE);
    }

    public static IApprovalType getType(String identifier) {
        return fgTypesMap.get(identifier);
    }

    public static List<IApprovalType> getTypes() {
        return Collections.unmodifiableList(fgTypes);
    }

    public static IApprovalState getState(String identifier) {
        return fgStatesMap.get(identifier);
    }

    public static List<IApprovalState> getStates() {
        return Collections.unmodifiableList(fgStates);
    }

    private static void add(String identifier, IApprovalType approvalType) {
        fgTypesMap.put(identifier, approvalType);
        fgTypes.add(approvalType);
    }

    private static void add(String identifier, IApprovalState approvalState) {
        fgStatesMap.put(identifier, approvalState);
        fgStates.add(approvalState);
    }

    private static URL createURL(String path) {
        return FileLocator.find((String)"com.ibm.team.workitem.common", (IPath)new Path(path));
    }
}

