/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.util.DataQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.AttributeType;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsAttributeType
extends AttributeType {
    public TagsAttributeType(String identifier) {
        super(identifier, String.class, new AttributeOperation[]{AttributeOperation.CONTAINS, AttributeOperation.NOT_CONTAINS, AttributeOperation.EQUALS, AttributeOperation.NOT_EQUALS}, new String[0], "_tags");
    }

    @Override
    public Object[] getValueSet(IAuditableCommon auditableCommon, IWorkItem workItem, IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
        return workItemCommon.findTags(attribute.getProjectArea(), monitor).toArray();
    }

    public static Object[] getValueSet(IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        DataQueryIterator<String> iter = WorkItemQueries.distinctWorkItemTags(auditableCommon);
        return TagsAttributeType.parseTags(iter, monitor).toArray();
    }

    @Override
    public Object getNullValue(IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return "";
    }

    public static Set<String> parseTags(DataQueryIterator<String> iter, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<String> result = new HashSet<String>();
        while (iter.hasNext(monitor)) {
            TagsAttributeType.parseTags(result, iter.next(monitor));
        }
        return result;
    }

    public static Collection<String> parseTags(String value) {
        ArrayList<String> result = new ArrayList<String>();
        TagsAttributeType.parseTags(result, value);
        return result;
    }

    private static void parseTags(Collection<String> result, String value) {
        if (value.length() > 0) {
            String[] tags = value.split(",");
            int j = 0;
            while (j < tags.length) {
                String part = tags[j].toLowerCase().trim();
                if (part.length() > 0 && !result.contains(part)) {
                    result.add(part);
                }
                ++j;
            }
        }
    }

    public static String normalizeTags(String tags) {
        String result = "";
        if (tags.length() > 0) {
            tags = tags.replaceAll(" ", ",");
            Collection<String> parsed = TagsAttributeType.parseTags(tags);
            for (String entry : parsed) {
                if (entry.length() <= 0) continue;
                result = String.valueOf(result) + ", " + entry;
            }
            if (result.length() > 0) {
                result = result.substring(2);
            }
        }
        return result;
    }

    @Override
    public Object valueOf(String stringValue, Object origin) {
        String nospaces = stringValue.replaceAll(" ", "");
        return nospaces.toLowerCase();
    }
}

