/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.model;

import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.Attachment;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.rest.IAttachmentRestService;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ItemURI {
    public static final String DFLT_ENCODING = "UTF-8";

    public static URI generateAuditableURI(String repositoryURI, Object object) {
        try {
            if (!(object instanceof EObject)) {
                throw new IllegalArgumentException();
            }
            Object[] result = ItemURI.findContainer((EObject)object);
            IAuditableHandle handle = (IAuditableHandle)result[0];
            String query = (String)result[1];
            return ItemURI.generateAuditableURI((IItemHandle)handle, repositoryURI, query);
        }
        catch (TeamRepositoryException x) {
            throw new RuntimeException(x);
        }
    }

    public static URI createWorkItemURI(IAuditableCommon auditableCommon, int id) {
        IWorkItem wi = (IWorkItem)auditableCommon.createAuditable(IWorkItem.ITEM_TYPE);
        ((WorkItem)wi).setId(id);
        try {
            return Location.namedLocation((IItem)wi, (String)auditableCommon.getRepositoryURI()).toAbsoluteUri();
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI createAttachmentURI(IAuditableCommon auditableCommon, int id) {
        IAttachment att = (IAttachment)auditableCommon.createAuditable(IAttachment.ITEM_TYPE);
        ((Attachment)att).setId(id);
        try {
            return Location.namedLocation((IItem)att, (String)auditableCommon.getRepositoryURI(), null, (String)IAttachmentRestService.class.getName()).toAbsoluteUri();
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI createWorkItemCommentURI(IAuditableCommon auditableCommon, int id, int commentIndex) {
        IWorkItem wi = (IWorkItem)auditableCommon.createAuditable(IWorkItem.ITEM_TYPE);
        ((WorkItem)wi).setId(id);
        try {
            return Location.namedLocation((IItem)wi, (String)auditableCommon.getRepositoryURI(), (String)("path=internalComments[" + (commentIndex + 1) + "]"), null).toAbsoluteUri();
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI createWorkItemCommentURI(IAuditableCommon auditableCommon, IWorkItemHandle handle, int commentIndex) {
        try {
            return new URI(String.valueOf(ItemURI.generateAuditableURI(auditableCommon.getRepositoryURI(), handle).toString()) + "?path=internalComments[" + (commentIndex + 1) + "]");
        }
        catch (URISyntaxException x) {
            throw new RuntimeException(x);
        }
    }

    @Deprecated
    public static URI generateAuditableURI(String repositoryURI, IItemHandle handle) {
        try {
            return ItemURI.generateAuditableURI(handle, repositoryURI, null);
        }
        catch (TeamRepositoryException x) {
            throw new RuntimeException(x);
        }
    }

    private static URI generateAuditableURI(IItemHandle handle, String repositoryURI, String query) throws TeamRepositoryException {
        if ("".equals(repositoryURI)) {
            repositoryURI = null;
        }
        String service = null;
        if (handle instanceof IAttachmentHandle) {
            service = IAttachmentRestService.class.getName();
        }
        Location location = Location.itemLocation((IItemHandle)handle, (String)repositoryURI, (String)query, (String)service);
        if (repositoryURI != null) {
            return location.toAbsoluteUri();
        }
        return location.toRelativeUri();
    }

    private static Object[] findContainer(EObject eObject) {
        if (eObject instanceof IAuditableHandle) {
            Object[] objectArray = new Object[2];
            objectArray[0] = eObject;
            return objectArray;
        }
        String query = "";
        while (!(eObject instanceof IItemHandle)) {
            if (eObject.eContainer() == null) {
                throw new IllegalArgumentException();
            }
            EStructuralFeature feature = eObject.eContainingFeature();
            String selector = "";
            if (feature.isMany()) {
                Object collection = eObject.eContainer().eGet(feature);
                if (collection instanceof List) {
                    int index = ((List)collection).indexOf(eObject) + 1;
                    selector = "[" + index + "]";
                } else {
                    throw new IllegalArgumentException("Unsupported collection type");
                }
            }
            query = "/" + feature.getName() + selector + query;
            eObject = eObject.eContainer();
        }
        query = "path=" + query.substring(1);
        if (!(eObject instanceof IAuditableHandle)) {
            throw new IllegalArgumentException();
        }
        return new Object[]{eObject, query};
    }

    public static IItemType findItemType(URI uri) {
        String namespace = ItemURI.findItemTypeNamespaceURI(uri);
        if (namespace == null) {
            return ItemURI.findItemType2(uri);
        }
        String name = ItemURI.findItemTypeName(uri);
        if (name == null) {
            return ItemURI.findItemType2(uri);
        }
        return IItemType.IRegistry.INSTANCE.getItemType(name, namespace);
    }

    private static IItemType findItemType2(URI uri) {
        try {
            Location location = Location.location((URI)uri);
            return location.getItemType();
        }
        catch (TeamRepositoryException teamRepositoryException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    private static String findItemTypeNamespaceURI(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            return null;
        }
        String qualifiedType = ItemURI.getValue(query, "type");
        if (qualifiedType == null) {
            return null;
        }
        int i = qualifiedType.lastIndexOf(".");
        if (i == -1) {
            return null;
        }
        String nsPrefix = qualifiedType.substring(0, i);
        if (nsPrefix.equals("core")) {
            nsPrefix = "repository";
        }
        if (nsPrefix.equals("magnolia.model")) {
            nsPrefix = "workitem";
        }
        String nsURI = null;
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        ArrayList ePackages = new ArrayList(registry.values());
        for (Object object : ePackages) {
            EPackage ePackage;
            if (object instanceof EPackage.Descriptor) {
                try {
                    ePackage = ((EPackage.Descriptor)object).getEPackage();
                }
                catch (WrappedException x) {
                    if (x.exception() instanceof ClassNotFoundException) continue;
                    throw x;
                }
            } else {
                ePackage = (EPackage)object;
            }
            if (ePackage == null || !ePackage.getNsPrefix().equals(nsPrefix)) continue;
            nsURI = ePackage.getNsURI();
            break;
        }
        return nsURI;
    }

    private static String findItemTypeName(URI uri) {
        String query = uri.getQuery();
        if (query == null) {
            return null;
        }
        String qualifiedType = ItemURI.getValue(query, "type");
        if (qualifiedType == null) {
            return null;
        }
        int i = qualifiedType.lastIndexOf(".");
        if (i == -1) {
            return null;
        }
        return qualifiedType.substring(i + 1);
    }

    public static String getValue(String query, String key) {
        int i;
        if (query.startsWith(String.valueOf(key) + "=")) {
            i = key.length() + 1;
        } else {
            i = query.indexOf("&" + key + "=");
            if (i == -1) {
                return null;
            }
            i += key.length() + 2;
        }
        int j = query.indexOf("&", i);
        if (j == -1) {
            j = query.length();
        }
        return query.substring(i, j);
    }

    public static IItemHandle resolveItemHandle(IAuditableCommon auditableCommon, URI uri) throws TeamRepositoryException {
        ItemQueryIterator<IContributorHandle> contributorByName;
        String query = uri.getQuery();
        if (query == null) {
            return ItemURI.resolveLocation(auditableCommon, uri);
        }
        String itemId = ItemURI.decode(ItemURI.getValue(query, "itemId"));
        String id = ItemURI.getValue(query, "id");
        String name = ItemURI.decode(ItemURI.getValue(query, "name"));
        if (itemId == null && id == null && name == null) {
            return ItemURI.resolveLocation(auditableCommon, uri);
        }
        IItemType itemType = ItemURI.findItemType(uri);
        if (itemType == null) {
            return ItemURI.resolveLocation(auditableCommon, uri);
        }
        if (IWorkItem.ITEM_TYPE.equals(itemType) && id != null) {
            try {
                ItemQueryIterator<IWorkItemHandle> workItemById = WorkItemQueries.workItemById(auditableCommon, Integer.parseInt(id));
                if (workItemById.hasNext(null)) {
                    return workItemById.next(null);
                }
            }
            catch (NumberFormatException x) {
                WorkItemCommonPlugin.log("Exception while parsing Work Item id", x);
            }
        }
        if (IContributor.ITEM_TYPE.equals(itemType) && name != null && (contributorByName = WorkItemQueries.contributorByName(auditableCommon, name)).hasNext(null)) {
            return contributorByName.next(null);
        }
        if (itemId != null) {
            if (auditableCommon.getOrigin() == null) {
                return itemType.createItemHandle(UUID.valueOf((String)itemId), null);
            }
            return itemType.createItemHandle(auditableCommon.getOrigin(), UUID.valueOf((String)itemId), null);
        }
        return ItemURI.resolveLocation(auditableCommon, uri);
    }

    public static IItemHandle resolveLocation(IAuditableCommon auditableCommon, URI uri) {
        IItemHandle handle;
        block5: {
            Location location = Location.location((URI)uri);
            handle = location.getItemHandle();
            if (handle != null) break block5;
            return null;
        }
        try {
            if (handle.getOrigin() == null && auditableCommon.getOrigin() != null) {
                return handle.getItemType().createItemHandle(auditableCommon.getOrigin(), handle.getItemId(), null);
            }
            return handle;
        }
        catch (TeamRepositoryException teamRepositoryException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    public static String encode(String string) {
        block3: {
            try {
                if (string != null) break block3;
                return null;
            }
            catch (UnsupportedEncodingException x) {
                throw new RuntimeException(x);
            }
        }
        return URLEncoder.encode(string, DFLT_ENCODING).replaceAll("\\+", "%20");
    }

    public static String decode(String string) {
        block3: {
            try {
                if (string != null) break block3;
                return null;
            }
            catch (UnsupportedEncodingException x) {
                throw new RuntimeException(x);
            }
        }
        return URLDecoder.decode(string.replaceAll("%20", "\\+"), DFLT_ENCODING);
    }
}

